<?php 
/*
 * Template Name: Team5 Page
 * Description: A Page Template with a Page Builder design.
 */
   $avaxy_redux_demo = get_option('redux_demo');
   
   get_header('');?>  
            <?php if(isset($avaxy_redux_demo['team_image']['url']) && $avaxy_redux_demo['team_image']['url'] != ''){?>
            <div class="breadcrumb-section breadcrumb-style-3" style="background-image: url('<?php echo esc_url($avaxy_redux_demo['team_image']['url']);?>');">
            <?php }else{?>
            <div class="breadcrumb-section breadcrumb-style-3">
            <?php }?> 

                <!-- main-section -->
                <div class="main-section">
                    <!-- section-container -->
                    <div class="section-container">


                        <!-- container -->
                        <div class="container">
                            <!-- row -->
                            <div class="row">


                                <!-- col-md-12 -->
                                <div class="col-md-12">


                                    <!-- breadcrumb-head -->
                                    <div class="breadcrumb-head">

                                        <!-- breadcrumb-sub-title -->
                                        <div class="breadcrumb-sub-title">
                                            <h5><?php if(isset($avaxy_redux_demo['team_text_top'])){?>
                                                <?php echo esc_attr($avaxy_redux_demo['team_text_top']); ?>
                                                <?php }else{?>
                                                <?php echo esc_html__( 'project details', 'avaxy' );
                                                }
                                                ?></h5>
                                        </div><!-- /breadcrumb-sub-title -->

                                        <!-- breadcrumb-title -->
                                        <div class="breadcrumb-title">
                                            <h1><?php if(isset($avaxy_redux_demo['team_title'])){?>
                                                <?php echo esc_attr($avaxy_redux_demo['team_title']); ?>
                                                <?php }else{?>
                                                <?php echo esc_html__( 'project details', 'avaxy' );
                                                }
                                                ?></h1>
                                        </div><!-- /breadcrumb-title -->

                                    </div><!-- /breadcrumb-head -->


                                    <!-- breadcrumb -->
                                    <ol class="breadcrumb">
                                        <li><a href="<?php echo esc_url(home_url('/')); ?>"><?php echo esc_html__( 'Home', 'avaxy' ); ?></a></li>
                                        <li class="active"><?php if(isset($avaxy_redux_demo['team_title'])){?>
                                                <?php echo esc_attr($avaxy_redux_demo['team_title']); ?>
                                                <?php }else{?>
                                                <?php echo esc_html__( 'Team', 'avaxy' );
                                                }
                                                ?></li>
                                    </ol>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="light-section">
                <div class="main-section">
                    <div class="section-container">
                        <div class="container">
                            <div class="row">
                                <!-- col-md-12 -->
                                <div class="col-md-12">

                                    <!-- filter-section -->
                                    <div class="filter-section">


                                        <h5><?php if(isset($avaxy_redux_demo['team_filter'])){?>
                                                <?php echo esc_attr($avaxy_redux_demo['team_filter']); ?>
                                                <?php }else{?>
                                                <?php echo esc_html__( 'All', 'avaxy' );
                                                }
                                                ?></h5>


                                        <!-- select-input -->
                                        <div class="select-input">

                                            <!-- team-filter-container -->
                                            <div id="team-filter-container">

                                                <select>
                                                    <option data-filter="*" selected="selected"><?php if(isset($avaxy_redux_demo['all'])){?>
                                                <?php echo esc_attr($avaxy_redux_demo['all']); ?>
                                                <?php }else{?>
                                                <?php echo esc_html__( 'All', 'avaxy' );
                                                }
                                                ?></option>
                                                    <?php 
                                                                $categories = get_terms('title');   
                                                                 foreach( (array)$categories as $categorie){
                                                                    $cat_name = $categorie->name;
                                                                    $cat_slug = $categorie->slug;
                                                            ?>
                                                    <option data-filter=".<?php echo esc_attr($cat_slug);?>"><?php echo esc_html($cat_name);?></option>
                                                    <?php } ?>
                                                </select>

                                            </div><!-- /team-filter-container -->

                                        </div><!-- /select-input -->


                                    </div><!-- /filter-section -->

                                </div><!-- /col-md-12 -->
                            </div><!-- /row -->


                            <!-- row -->
                            <div class="row">
                                <div class="team-blocks-wrapper">
                                <?php 
                                                $args = array(   
                                                            'post_type' => 'team',   
                                                            'paged' => $paged,
                                                        );  
                                                        $wp_query = new WP_Query($args);
                                                        $i = 1;
                                                        while ($wp_query -> have_posts()) : $wp_query -> the_post(); 
                                                        $cates = get_the_terms(get_the_ID(),'title');
                                                        $cate_name ='';
                                                        $cate_slug = '';
                                                              foreach((array)$cates as $cate){
                                                    if(count($cates)>0){
                                                        $cate_name .= $cate->name.' ' ;
                                                        $cate_slug .= $cate->slug .' ';     
                                                        } 
                                                        } 
                                        ?> 


                                    <!-- col-md-3 member-block -->
                                    <div class="col-md-3 member-block <?php echo esc_attr($cate_slug);?>">
                                        <!-- member-item -->
                                        <div class="member-item">


                                            <!-- member-header -->
                                            <div class="member-header">
                                                <img src="<?php echo wp_get_attachment_url( get_post_thumbnail_id());?>" alt="Member Image" />
                                            </div><!-- /member-header -->


                                            <!-- member-footer -->
                                            <div class="member-footer">

                                                <!-- member-name -->
                                                <div class="member-name">
                                                    <h4>
                                                        <a href="<?php the_permalink();?>" ><?php the_title(); ?></a>
                                                    </h4>
                                                </div><!-- /member-name -->

                                                <!-- member-title -->
                                                <div class="member-title">
                                                    <p><?php echo esc_html($cate_name);?></p>
                                                </div><!-- /member-title -->

                                                <?php 
                                                
                                                $member_excerpt_des = get_post_meta(get_the_ID(),'_cmb_member_excerpt_des', true); 
                                                $member_face = get_post_meta(get_the_ID(),'_cmb_member_face', true); 
                                                $member_twit = get_post_meta(get_the_ID(),'_cmb_member_twit', true); 
                                                $member_goog = get_post_meta(get_the_ID(),'_cmb_member_goog', true); 
                                                $member_beha = get_post_meta(get_the_ID(),'_cmb_member_beha', true);
                                                ?>

                                                <!-- member-desc -->
                                                <div class="member-desc">
                                                    <p><?php echo esc_html($member_excerpt_des);?></p>
                                                </div><!-- /member-desc -->

                                                <!-- member-social -->
                                                <div class="member-social">

                                                    <!-- social-icons -->
                                                    <div class="social-icons">
                                                        <ul>
                                                        <li>
                                                            <a href="<?php echo esc_attr($member_face);?>"><i class="fa fa-facebook"></i></a>
                                                        </li>
                                                        <li>
                                                            <a href="<?php echo esc_attr($member_twit);?>"><i class="fa fa-twitter"></i></a>
                                                        </li>
                                                        <li>
                                                            <a href="<?php echo esc_attr($member_goog);?>"><i class="fa fa-google-plus"></i></a>
                                                        </li>
                                                        <li>
                                                            <a href="<?php echo esc_attr($member_beha);?>"><i class="fa fa-behance"></i></a>
                                                        </li>
                                                    </ul>
                                                    </div><!-- /social-icons -->

                                                </div><!-- /member-social -->

                                            </div><!-- /member-footer -->


                                        </div><!-- /member-item -->
                                    </div><!-- /col-md-3 member-block -->

                                    <?php $i++;
                                                    endwhile;?> 


                                </div>
                            </div><!-- /row -->


                        </div><!-- /container -->


                    </div><!-- /section-container -->
                </div><!-- /main-section -->

            </div><!-- /light-section -->
            <?php if(isset($avaxy_redux_demo['team5_template'])){?>             
            <?php echo html_entity_decode($avaxy_redux_demo['team5_template']) ?>
            <?php } ?>
<?php get_footer('portfolio');?>  