<?php 
   $avaxy_redux_demo = get_option('redux_demo');
   
   get_header();?>  

   <!-- =========================================
            Breadcrumb Section
            ========================================== -->
            <!-- breadcrumb-section -->
            <?php if(isset($avaxy_redux_demo['blog_image']['url']) && $avaxy_redux_demo['blog_image']['url'] != ''){?>
            <div class="breadcrumb-section breadcrumb-style-3" style="background-image: url('<?php echo esc_url($avaxy_redux_demo['blog_image']['url']);?>');">
            <?php }else{?>
            <div class="breadcrumb-section breadcrumb-style-3">
            <?php }?> 

                <!-- main-section -->
                <div class="main-section">
                    <!-- section-container -->
                    <div class="section-container">


                        <!-- container -->
                        <div class="container">
                            <!-- row -->
                            <div class="row">


                                <!-- col-md-12 -->
                                <div class="col-md-12">


                                    <!-- breadcrumb-head -->
                                    <div class="breadcrumb-head">

                                        <!-- breadcrumb-sub-title -->
                                        <div class="breadcrumb-sub-title">
                                            <h5><?php if(isset($avaxy_redux_demo['blog_text_top'])){?>
                                                                    <?php echo esc_attr($avaxy_redux_demo['blog_text_top']); ?>
                                                                    <?php }else{?>
                                                                    <?php echo esc_html__( 'latest news', 'avaxy' );
                                                                    }
                                                                    ?></h5>
                                        </div><!-- /breadcrumb-sub-title -->

                                        <!-- breadcrumb-title -->
                                        <div class="breadcrumb-title">
                                            <h1><?php printf( esc_html__( 'Search Results for: %s', 'avaxy' ), get_search_query() ); ?></h1>
                                        </div><!-- /breadcrumb-title -->

                                    </div><!-- /breadcrumb-head -->


                                    <!-- breadcrumb -->
                                    <ol class="breadcrumb">
                                        <li><a href="<?php echo esc_url(home_url('/')); ?>"><?php echo esc_html__( 'Home', 'avaxy' ); ?></a></li>
                                        <li class="active"><?php if(isset($avaxy_redux_demo['blog_title'])){?>
                                                                    <?php echo esc_attr($avaxy_redux_demo['blog_title']); ?>
                                                                    <?php }else{?>
                                                                    <?php echo esc_html__( 'our blog', 'avaxy' );
                                                                    }
                                                                    ?></li>
                                    </ol><!-- /breadcrumb -->


                                </div><!-- /col-md-12 -->


                            </div><!-- /row -->
                        </div><!-- /container -->


                    </div><!-- /section-container -->
                </div><!-- /main-section -->

            </div><!-- /breadcrumb-section -->




            <!-- =========================================
            Light Section
            ========================================== -->
            <!-- light-section -->
            <div class="light-section">

                <!-- main-section -->
                <div class="main-section">
                    <!-- section-container -->
                    <div class="section-container">


                        <!-- container -->
                        <div class="container">
                            <!-- row -->
                            <div class="row">



                                <!-- col-md-9 main-content -->
                                <div class="col-md-9 main-content">


                                    <!-- row -->
                                    <div class="row">
                                        <!-- col-md-12 -->
                                        <div class="col-md-12">

                                            <!-- spinner-loader -->
                                            <div class="spinner-loader">
                                                <i class="fa fa-spinner fa-pulse"></i>
                                            </div><!-- /spinner-loader -->

                                        </div><!-- /col-md-12 -->
                                    </div><!-- /row -->


                                    <!-- row -->
                                    <div class="row">
                                        <!-- col-md-12 -->
                                        <div class="col-md-12">

                                            <!-- blog-posts-wrapper -->
                                            <div class="blog-posts-wrapper">
                                            <?php 
                                                while (have_posts()): the_post(); 
                                            ?> 
                                            <?php $format = get_post_format($post->ID); ?>


                                                <!-- blog-post -->
                                                <article class="blog-post">
                                                    <!-- post -->
                                                    <div class="post">


                                                        <!-- post-header -->
                                                        <div class="post-header">

                                                            <!-- post-meta -->
                                                            <p class="post-meta">
                                                                <span class="meta-date">
                                                                    <i class="glyphicon glyphicon-time"></i>
                                                                    <a href="#" ><?php the_time('F j, Y'); ?></a>
                                                                </span>
                                                            </p><!-- /post-meta -->

                                                            <!-- post-title -->
                                                            <div class="post-title">
                                                                <h2>
                                                                    <a href="<?php the_permalink();?>" >
                                                                        <?php the_title();?>
                                                                    </a>
                                                                </h2>
                                                            </div><!-- /post-title -->

                                                            <!-- post-meta -->
                                                            <p class="post-meta">
                                                                <span class="meta-author">
                                                                    <i class="glyphicon glyphicon-user"></i>
                                                                    <?php the_author_posts_link(); ?>
                                                                </span>
                                                                <span class="meta-cat">
                                                                    <i class="fa fa-folder"></i>
                                                                    <?php 
                                            // Show all category for post
                                            $i = 1; foreach((get_the_category()) as $category) { 
                                            if ($i == 1){echo ''; }else {echo ' , ';}
                                                echo '<a href="'.get_category_link($category->cat_ID).'" title="'.$category->category_nicename . '" >'.$category->category_nicename . ' '.'</a>'; 
                                                
                                                $i++;
                                            } ?>
                                                                </span>
                                                                <span class="meta-comment">
                                                                    <a href="#" >
                                                                        <i class="glyphicon glyphicon-comment"></i> </a><?php comments_popup_link( esc_html__(' 0 ', 'avaxy'), esc_html__(' 1 ', 'avaxy'), ' % '. esc_html__('', 'avaxy')); ?>
                                                                   
                                                                </span>
                                                                <span class="meta-like">
                                                                    <a href="#" >
                                                                        <i class="glyphicon glyphicon-heart"></i>7
                                                                    </a>
                                                                </span>
                                                            </p><!-- /post-meta -->

                                                        </div><!-- /post-header -->


                                                        <!-- post-type -->
                                                        <div class="post-type">
                                                        <?php if($format == 'image'){?>
                                                            <?php if ( has_post_thumbnail() ) { ?>

                                                            <a href="<?php the_permalink();?>" >
                                                                <img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" alt="<?php the_title_attribute(); ?>" />
                                                            </a>
                                                            <?php }?>
                                                        <?php }elseif($format == 'gallery'){?>  
                                                        <!-- owl-slider-wrapper -->
                                                            <div class="owl-slider-wrapper">
                                                            <?php $gallery = get_post_gallery( get_the_ID(), false );
                                                             if(isset($gallery['ids'])){    
                                                              $gallery_ids = $gallery['ids'];
                                                              $img_ids = explode(",",$gallery_ids);
                                                              $i=0; $j=0;?>
                                                                <!-- owl-slider -->
                                                                <ul class="owl-slider">
                                                                <?php   
                                                                foreach( $img_ids AS $img_id ){ 
                                                                $image_src = wp_get_attachment_image_src($img_id,''); 
                                                                    ?>


                                                                    <!-- slide-item -->
                                                                    <li>

                                                                        <!-- post-item -->
                                                                        <div class="post-item">

                                                                            <a href="<?php the_permalink();?>" >
                                                                                <img src="<?php echo esc_url($image_src[0]); ?>" alt="<?php the_title_attribute(); ?>" />
                                                                            </a>

                                                                        </div><!-- /post-item -->

                                                                    </li><!-- /slide-item -->
                                                                    <?php 
                                                                        $j++;   
                                                                        }
                                                                          ?>


                                                                    </ul><!-- /owl-slider -->
                                                            </div><!-- /owl-slider-wrapper -->  
                                                            <?php }?>
                                                            <?php }elseif($format == 'video'){?>
                                                            <!-- fitvid-iframe -->
                                                            <div class="fitvid-iframe">
                                                            <?php $video = get_post_meta(get_the_ID(),'_cmb_link_video', true);?>
                                                            <?php if($video != ''){?>
                                                                <iframe src="<?php echo esc_url($video);?>"></iframe>
                                                            <?php }?>
                                                            
                                                            
                                                            </div><!-- /fitvid-iframe --> 
                                                            <?php }else{?>
                                                            
                                                            <?php } ?>

                                                        </div><!-- /post-type -->


                                                        <!-- post-content -->
                                                        <div class="post-content">

                                                            <!-- post-excerpt -->
                                                            <div class="post-excerpt">
                                                                <p><?php if(isset($avaxy_redux_demo['blog_excerpt'])){?>
                                                                    <?php echo avaxy_excerpt($avaxy_redux_demo['blog_excerpt']); ?>
                                                                    <?php }else{?>
                                                                    <?php echo esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur in est eu nisi feugiat posuere a sed metus. Proin accumsan odio, at porttitor ipsum semper pellentesque. Mauris maximus nisl vitae urna malesuada, nec ornare risus tincidunt. Fusce sapien, porttitor neque hendrerit non. Etiam elementum at tortor ac malesuada. Phasellus gravida vulputate ut mollis. Class taciti amet sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. In ut risus ac diam tristique vestibulum. Mauris maximus nisl vitae urna malesuada.', 'avaxy' );
                                                                    }
                                                                    ?></p>
                                                            </div><!-- /post-excerpt -->

                                                            <!-- post-link -->
                                                            <div class="post-link">
                                                                <a href="<?php the_permalink();?>"  class="btn btn-nesto">
                                                                    <?php if(isset($avaxy_redux_demo['continue_reading'])){?>
                                                                    <?php echo esc_attr($avaxy_redux_demo['continue_reading']); ?>
                                                                    <?php }else{?>
                                                                    <?php echo esc_html__( 'Continue reading', 'avaxy' );
                                                                    }
                                                                    ?>
                                                                </a>
                                                            </div><!-- /post-link -->

                                                        </div><!-- /post-content -->


                                                    </div><!-- /post -->
                                                </article><!-- /blog-post -->
                                                <?php endwhile;?>



                                            </div><!-- /blog-posts-wrapper -->

                                        </div><!-- /col-md-12 -->
                                    </div><!-- /row -->


                                    <!-- row -->
                                    <div class="row">
                                        <!-- col-md-12 -->
                                        <div class="col-md-12">

                                            <!-- pagination-wrapper -->
                                            <div class="pagination-wrapper">

                                                <nav>
                                                    <?php avaxy_pagination();?>
                                                </nav>

                                            </div><!-- /pagination-wrapper -->

                                        </div><!-- /col-md-12 -->
                                    </div><!-- /row -->


                                </div><!-- /col-md-9 main-content -->



                                <!-- col-md-3 sidebar -->
                                <div class="col-md-3 sidebar">


                                     <?php get_sidebar();?>


                                </div><!-- /col-md-3 sidebar -->



                            </div><!-- /row -->
                        </div><!-- /container -->


                    </div><!-- /section-container -->
                </div><!-- /main-section -->

            </div><!-- /light-section -->

   <?php get_footer();?>  
