<?php

/*************************************************
## Scripts
*************************************************/
function grogin_product_request_quote_scripts() {
	wp_register_script( 'klb-request-quote',   plugins_url( 'js/request-quote.js', __FILE__ ), false, '1.0');
	wp_register_style( 'klb-request-quote',   plugins_url( 'css/request-quote.css', __FILE__ ), false, '1.0');
}
add_action( 'wp_enqueue_scripts', 'grogin_product_request_quote_scripts' );

/*************************************************
## Product Request Quote Button
*************************************************/
function grogin_request_quote(){
	wp_enqueue_script( 'klb-request-quote');
	wp_enqueue_style( 'klb-request-quote');
	
	echo '<div class="product-request-quote">';
	echo '<a class="button" href="#">'.esc_html__('Request Quote', 'grogin-core').'</a>';
	echo '</div><!-- product-request-quote -->';
}
add_action('woocommerce_single_product_summary', 'grogin_request_quote',40);

/*************************************************
## Product Request Quote Holder
*************************************************/	
function grogin_request_quote_holder(){
	
	if(!is_product()){
		return;
	}
	
	$formid = get_theme_mod( 'bacola_request_quote_form' );
	
	echo '<div class="site-request-quote-holder">';
	echo '<div class="request-quote-inner">';
	echo '<div class="request-quote-header">';
	echo '<h4 class="entry-title">'.esc_html(get_theme_mod('bacola_request_quote_title')).'</h4>';
	echo '<h6 class="product_title entry-title">'.get_the_title().'</h6>';
	echo '<div class="request-quote-close"><i class="klbth-icon-cancel"></i></div>';
	echo '</div><!-- request-quote-header -->';
	echo '<div class="tab-content">';
	echo '<div class="tab-pane fade show active">';
	echo do_shortcode( '[contact-form-7 id="'.$formid.'"]' );
	echo '</div>';
	echo '</div>';
	echo '</div><!-- request-quote-inner -->';
	echo '<div class="request-quote-mask"></div>';
	echo '</div><!-- request-quote-holder -->';
}
add_action('wp_footer', 'grogin_request_quote_holder'); 