<?php
if( function_exists('acf_add_local_field_group') ):

acf_add_local_field_group(array(
	'key' => 'group_5ba249fd4ae33',
	'title' => 'Menu Settings',
	'fields' => array(
		array(
			'key' => 'field_5ba24d119c495__trashed',
			'label' => 'Mega Menu',
			'name' => 'mega_menu',
			'type' => 'true_false',
			'instructions' => 'Activate the mega menu.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_5ba36847b8be9__trashed',
			'label' => 'Mega Menu Columns',
			'name' => 'mega_menu_columns',
			'type' => 'select',
			'instructions' => 'Select the columns of mega menu.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ba24d119c495',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => '2 Columns',
				2 => '3 Columns',
				3 => '4 Columns',
				4 => '5 Columns',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5ba3a694b1027__trashed',
			'label' => 'Unclickable',
			'name' => 'menu_unclickable',
			'type' => 'true_false',
			'instructions' => 'Make this menu unclickable. <br />
<small>Note: Can be used for dropdown parents or mega menu headings.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_5bb4c411e84b0__trashed',
			'label' => 'Label',
			'name' => 'menu_label',
			'type' => 'select',
			'instructions' => 'Add a label to the menu item.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'None',
				2 => 'New',
				3 => 'Hot',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'nav_menu_item',
				'operator' => '==',
				'value' => 'all',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'modified' => 1547738712,
));

acf_add_local_field_group(array(
	'key' => 'group_5d30d89a41d67',
	'title' => 'Settings',
	'fields' => array(
		array(
			'key' => 'field_5bab770e496c9',
			'label' => 'General',
			'name' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_5bab7a2751dc7',
			'label' => 'Title',
			'name' => 'general_title',
			'type' => 'select',
			'instructions' => 'Show or hide the title of this page/post. <br />
<small>Note: The default options are placed in Customizer > Utility > Title.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Show',
				3 => 'Hide',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5bab7a4051dc8',
			'label' => 'Breadcrumb',
			'name' => 'general_breadcrumb',
			'type' => 'select',
			'instructions' => 'Show or hide the breadcrumb of this page/post. <br />
<small>Note: The default options are placed in Customizer > Utility > Breadcrumbs.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Show',
				3 => 'Hide',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5c62d3cefe691',
			'label' => 'Body Offset',
			'name' => 'general_body_offset',
			'type' => 'button_group',
			'instructions' => 'Create a left or right spacing to the content, best use case when creating a lateral header to eliminate the FOUC effect.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'On',
				2 => 'Off',
			),
			'allow_null' => 1,
			'default_value' => '',
			'layout' => 'horizontal',
			'return_format' => 'value',
		),
		array(
			'key' => 'field_5c62d421fe692',
			'label' => 'Padding Left',
			'name' => 'general_body_offset_padding_left',
			'type' => 'text',
			'instructions' => 'Enter the Padding Left offset. <br />
<small>Note: Do not forget to enter the unit too.</small>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62d3cefe691',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_5c62d43dfe693',
			'label' => 'Padding Right',
			'name' => 'general_body_offset_padding_right',
			'type' => 'text',
			'instructions' => 'Enter the Padding Right offset. <br />
<small>Note: Do not forget to enter the unit too.</small>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62d3cefe691',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_5c62d467fe694',
			'label' => 'Offset Breakpoint',
			'name' => 'general_body_offset_breakpoint',
			'type' => 'select',
			'instructions' => 'Select from which device you want to remove the offset.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62d3cefe691',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Tablet',
				2 => 'Mobile',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5bb24a1e53877',
			'label' => 'Redirect',
			'name' => 'general_redirect',
			'type' => 'true_false',
			'instructions' => 'Make this post/page a redirect.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_5bb24a627bc91',
			'label' => 'Redirect URL',
			'name' => 'general_redirect_url',
			'type' => 'link',
			'instructions' => 'Enter the URL.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5bb24a1e53877',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'url',
		),
		array(
			'key' => 'field_5ce55b24d1964',
			'label' => 'Theme Borders',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5ce55b37d1965',
			'label' => 'Visibility',
			'name' => 'theme_borders',
			'type' => 'select',
			'instructions' => 'Add borders all around the theme, you\'ll be able to specify the thickness and the color in the fields below.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'On',
				3 => 'Off',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5ce55b6fd1966',
			'label' => 'Thickness',
			'name' => 'theme_borders_thickness',
			'type' => 'range',
			'instructions' => 'Override the theme border thickness.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ce55b37d1965',
						'operator' => '==',
						'value' => '2',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => 16,
			'min' => '',
			'max' => '',
			'step' => '',
			'prepend' => '',
			'append' => 'px',
		),
		array(
			'key' => 'field_5ce55bb5d1967',
			'label' => 'Color',
			'name' => 'theme_borders_color',
			'type' => 'color_picker',
			'instructions' => 'Change the color of the theme borders.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ce55b37d1965',
						'operator' => '==',
						'value' => '2',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
		),
		array(
			'key' => 'field_5ceff19e7c500',
			'label' => 'Site',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5d30bc283e771',
			'label' => 'Background Type',
			'name' => 'background_type',
			'type' => 'button_group',
			'instructions' => 'Select the background type of this page or post.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'classic' => 'Classic',
				'gradient' => 'Gradient',
			),
			'allow_null' => 1,
			'default_value' => '',
			'layout' => 'horizontal',
			'return_format' => 'value',
		),
		array(
			'key' => 'field_5cf0046b8f33d',
			'label' => 'Color',
			'name' => 'background_site_color',
			'type' => 'color_picker',
			'instructions' => 'Choose the color of the background.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30bc283e771',
						'operator' => '==',
						'value' => 'classic',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
		),
		array(
			'key' => 'field_5cf0053f5f1a0',
			'label' => 'Image',
			'name' => 'background_site_image',
			'type' => 'image',
			'instructions' => 'Upload the image.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30bc283e771',
						'operator' => '==',
						'value' => 'classic',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'url',
			'preview_size' => 'medium',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '',
		),
		array(
			'key' => 'field_5cf005995f1a2',
			'label' => 'Position',
			'name' => 'background_site_position',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30bc283e771',
						'operator' => '==',
						'value' => 'classic',
					),
					array(
						'field' => 'field_5cf0053f5f1a0',
						'operator' => '!=empty',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'center' => 'Default',
				'top-left' => 'Top Left',
				'top-center' => 'Top Center',
				'top-right' => 'Top Right',
				'center-left' => 'Center Left',
				'center-center' => 'Center Center',
				'center-right' => 'Center Right',
				'bottom-left' => 'Bottom Left',
				'bottom-center' => 'Bottom Center',
				'bottom-right' => 'Bottom Right',
			),
			'default_value' => array(
				0 => 'center',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5cf006035f1a4',
			'label' => 'Attachment',
			'name' => 'background_site_attachment',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30bc283e771',
						'operator' => '==',
						'value' => 'classic',
					),
					array(
						'field' => 'field_5cf0053f5f1a0',
						'operator' => '!=empty',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'scroll' => 'Scroll',
				'fixed' => 'Fixed',
			),
			'default_value' => array(
				0 => 'scroll',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5cf006275f1a6',
			'label' => 'Repeat',
			'name' => 'background_site_repeat',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30bc283e771',
						'operator' => '==',
						'value' => 'classic',
					),
					array(
						'field' => 'field_5cf0053f5f1a0',
						'operator' => '!=empty',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'no-repeat' => 'No-repeat',
				'repeat' => 'Repeat',
				'repeat-x' => 'Repeat-x',
				'repeat-y' => 'Repeat-y',
			),
			'default_value' => array(
				0 => 'no-repeat',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5cf006785f1a7',
			'label' => 'Size',
			'name' => 'background_site_size',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30bc283e771',
						'operator' => '==',
						'value' => 'classic',
					),
					array(
						'field' => 'field_5cf0053f5f1a0',
						'operator' => '!=empty',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'auto' => 'Auto',
				'cover' => 'Cover',
				'contain' => 'Contain',
			),
			'default_value' => array(
				0 => 'auto',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5d30cd6041836',
			'label' => 'Color',
			'name' => 'background_gradient_top_color',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30bc283e771',
						'operator' => '==',
						'value' => 'gradient',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
		),
		array(
			'key' => 'field_5d30cd9541837',
			'label' => 'Location',
			'name' => 'background_gradient_top_location',
			'type' => 'range',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30bc283e771',
						'operator' => '==',
						'value' => 'gradient',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => 0,
			'min' => 0,
			'max' => 100,
			'step' => 1,
			'prepend' => '',
			'append' => '%',
		),
		array(
			'key' => 'field_5d30cdce41838',
			'label' => 'Second Color',
			'name' => 'background_gradient_bottom_color',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30bc283e771',
						'operator' => '==',
						'value' => 'gradient',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
		),
		array(
			'key' => 'field_5d30cddd41839',
			'label' => 'Location',
			'name' => 'background_gradient_bottom_location',
			'type' => 'range',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30bc283e771',
						'operator' => '==',
						'value' => 'gradient',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => 100,
			'min' => 0,
			'max' => 100,
			'step' => 1,
			'prepend' => '',
			'append' => '%',
		),
		array(
			'key' => 'field_5d30cdf24183a',
			'label' => 'Type',
			'name' => 'background_gradient_type',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30bc283e771',
						'operator' => '==',
						'value' => 'gradient',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'linear' => 'Linear',
				'radial' => 'Radial',
			),
			'default_value' => array(
				0 => 'linear',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5d30ce164183b',
			'label' => 'Angle',
			'name' => 'background_gradient_angle',
			'type' => 'range',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30bc283e771',
						'operator' => '==',
						'value' => 'gradient',
					),
					array(
						'field' => 'field_5d30cdf24183a',
						'operator' => '==',
						'value' => 'linear',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => 180,
			'min' => 0,
			'max' => 360,
			'step' => 1,
			'prepend' => '',
			'append' => 'deg',
		),
		array(
			'key' => 'field_5d30ce614183d',
			'label' => 'Position',
			'name' => 'background_gradient_position',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30bc283e771',
						'operator' => '==',
						'value' => 'gradient',
					),
					array(
						'field' => 'field_5d30cdf24183a',
						'operator' => '==',
						'value' => 'radial',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'at-center-center' => 'Center Center',
				'at-center-left' => 'Center Left',
				'at-center-right' => 'Center Right',
				'at-top-center' => 'Top Center',
				'at-top-left' => 'Top Left',
				'at-top-right' => 'Top Right',
				'at-bottom-center' => 'Bottom Center',
				'at-bottom-left' => 'Bottom Left',
				'at-bottom-right' => 'Bottom Right',
			),
			'default_value' => array(
				0 => 'at-center-center',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5d30d1ccc65bd',
			'label' => 'Site Width',
			'name' => 'site_width',
			'type' => 'button_group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'full-width' => 'Full Width',
				'boxed' => 'Boxed',
			),
			'allow_null' => 1,
			'default_value' => '',
			'layout' => 'horizontal',
			'return_format' => 'value',
		),
		array(
			'key' => 'field_5d30d40c66d5b',
			'label' => 'Boxed Width',
			'name' => 'boxed_width',
			'type' => 'range',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30d1ccc65bd',
						'operator' => '==',
						'value' => 'boxed',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => 1170,
			'min' => 600,
			'max' => 1800,
			'step' => 10,
			'prepend' => '',
			'append' => 'px',
		),
		array(
			'key' => 'field_5d30d4b39cc98',
			'label' => 'Boxed Background Type',
			'name' => 'boxed_background_type',
			'type' => 'button_group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30d1ccc65bd',
						'operator' => '==',
						'value' => 'boxed',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'classic' => 'Classic',
				'gradient' => 'Gradient',
			),
			'allow_null' => 1,
			'default_value' => '',
			'layout' => 'horizontal',
			'return_format' => 'value',
		),
		array(
			'key' => 'field_5d30d4bb9cc99',
			'label' => 'Color',
			'name' => 'boxed_background_color',
			'type' => 'color_picker',
			'instructions' => 'Choose the color of the background.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30d1ccc65bd',
						'operator' => '==',
						'value' => 'boxed',
					),
					array(
						'field' => 'field_5d30d4b39cc98',
						'operator' => '==',
						'value' => 'classic',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
		),
		array(
			'key' => 'field_5d30d4c99cc9a',
			'label' => 'Image',
			'name' => 'boxed_background_image',
			'type' => 'image',
			'instructions' => 'Upload the image.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30d1ccc65bd',
						'operator' => '==',
						'value' => 'boxed',
					),
					array(
						'field' => 'field_5d30d4b39cc98',
						'operator' => '==',
						'value' => 'classic',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'url',
			'preview_size' => 'medium',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '',
		),
		array(
			'key' => 'field_5d30d4d59cc9b',
			'label' => 'Position',
			'name' => 'boxed_background_repeat',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30d1ccc65bd',
						'operator' => '==',
						'value' => 'boxed',
					),
					array(
						'field' => 'field_5d30d4b39cc98',
						'operator' => '==',
						'value' => 'classic',
					),
					array(
						'field' => 'field_5d30d4c99cc9a',
						'operator' => '!=empty',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'center' => 'Default',
				'top-left' => 'Top Left',
				'top-center' => 'Top Center',
				'top-right' => 'Top Right',
				'center-left' => 'Center Left',
				'center-center' => 'Center Center',
				'center-right' => 'Center Right',
				'bottom-left' => 'Bottom Left',
				'bottom-center' => 'Bottom Center',
				'bottom-right' => 'Bottom Right',
			),
			'default_value' => array(
				0 => 'center',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5d30d4e29cc9c',
			'label' => 'Attachment',
			'name' => 'boxed_background_attachment',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30d1ccc65bd',
						'operator' => '==',
						'value' => 'boxed',
					),
					array(
						'field' => 'field_5d30d4b39cc98',
						'operator' => '==',
						'value' => 'classic',
					),
					array(
						'field' => 'field_5d30d4c99cc9a',
						'operator' => '!=empty',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'scroll' => 'Scroll',
				'fixed' => 'Fixed',
			),
			'default_value' => array(
				0 => 'scroll',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5d30d4f99cc9d',
			'label' => 'Repeat',
			'name' => 'boxed_background_repeat',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30d1ccc65bd',
						'operator' => '==',
						'value' => 'boxed',
					),
					array(
						'field' => 'field_5d30d4b39cc98',
						'operator' => '==',
						'value' => 'classic',
					),
					array(
						'field' => 'field_5d30d4c99cc9a',
						'operator' => '!=empty',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'no-repeat' => 'No-repeat',
				'repeat' => 'Repeat',
				'repeat-x' => 'Repeat-x',
				'repeat-y' => 'Repeat-y',
			),
			'default_value' => array(
				0 => 'no-repeat',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5d30d50a9cc9e',
			'label' => 'Size',
			'name' => 'boxed_background_size',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30d4b39cc98',
						'operator' => '==',
						'value' => 'classic',
					),
					array(
						'field' => 'field_5d30d1ccc65bd',
						'operator' => '==',
						'value' => 'boxed',
					),
					array(
						'field' => 'field_5d30d4c99cc9a',
						'operator' => '!=empty',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'auto' => 'Auto',
				'cover' => 'Cover',
				'contain' => 'Contain',
			),
			'default_value' => array(
				0 => 'auto',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5d30d5219cc9f',
			'label' => 'Color',
			'name' => 'boxed_background_gradient_top_color',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30d4b39cc98',
						'operator' => '==',
						'value' => 'gradient',
					),
					array(
						'field' => 'field_5d30d1ccc65bd',
						'operator' => '==',
						'value' => 'boxed',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
		),
		array(
			'key' => 'field_5d30d52c9cca0',
			'label' => 'Location',
			'name' => 'boxed_background_gradient_top_location',
			'type' => 'range',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30d4b39cc98',
						'operator' => '==',
						'value' => 'gradient',
					),
					array(
						'field' => 'field_5d30d1ccc65bd',
						'operator' => '==',
						'value' => 'boxed',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => 0,
			'min' => 0,
			'max' => 100,
			'step' => 1,
			'prepend' => '',
			'append' => '%',
		),
		array(
			'key' => 'field_5d30d5449cca2',
			'label' => 'Second Color',
			'name' => 'boxed_background_gradient_bottom_color',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30d4b39cc98',
						'operator' => '==',
						'value' => 'gradient',
					),
					array(
						'field' => 'field_5d30d1ccc65bd',
						'operator' => '==',
						'value' => 'boxed',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
		),
		array(
			'key' => 'field_5d30d54e9cca3',
			'label' => 'Location',
			'name' => 'boxed_background_gradient_bottom_location',
			'type' => 'range',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30d4b39cc98',
						'operator' => '==',
						'value' => 'gradient',
					),
					array(
						'field' => 'field_5d30d1ccc65bd',
						'operator' => '==',
						'value' => 'boxed',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => 100,
			'min' => 0,
			'max' => 100,
			'step' => 1,
			'prepend' => '',
			'append' => '%',
		),
		array(
			'key' => 'field_5d30d5609cca4',
			'label' => 'Type',
			'name' => 'boxed_background_gradient_type',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30d4b39cc98',
						'operator' => '==',
						'value' => 'gradient',
					),
					array(
						'field' => 'field_5d30d1ccc65bd',
						'operator' => '==',
						'value' => 'boxed',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'linear' => 'Linear',
				'radial' => 'Radial',
			),
			'default_value' => array(
				0 => 'linear',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5d30d5699cca5',
			'label' => 'Angle',
			'name' => 'boxed_background_gradient_angle',
			'type' => 'range',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30d4b39cc98',
						'operator' => '==',
						'value' => 'gradient',
					),
					array(
						'field' => 'field_5d30d1ccc65bd',
						'operator' => '==',
						'value' => 'boxed',
					),
					array(
						'field' => 'field_5d30cdf24183a',
						'operator' => '==',
						'value' => 'linear',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => 180,
			'min' => 0,
			'max' => 360,
			'step' => 1,
			'prepend' => '',
			'append' => 'deg',
		),
		array(
			'key' => 'field_5d30d5799cca6',
			'label' => 'Position',
			'name' => 'boxed_background_gradient_position',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5d30d4b39cc98',
						'operator' => '==',
						'value' => 'gradient',
					),
					array(
						'field' => 'field_5d30d1ccc65bd',
						'operator' => '==',
						'value' => 'boxed',
					),
					array(
						'field' => 'field_5d30d5609cca4',
						'operator' => '==',
						'value' => 'radial',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'at-center-center' => 'Center Center',
				'at-center-left' => 'Center Left',
				'at-center-right' => 'Center Right',
				'at-top-center' => 'Top Center',
				'at-top-left' => 'Top Left',
				'at-top-right' => 'Top Right',
				'at-bottom-center' => 'Bottom Center',
				'at-bottom-left' => 'Bottom Left',
				'at-bottom-right' => 'Bottom Right',
			),
			'default_value' => array(
				0 => 'at-center-center',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fae313a714',
			'label' => 'Header',
			'name' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_5cdc10d578c6b',
			'label' => 'Layout',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5c62f32349980',
			'label' => 'Visibility',
			'name' => 'header_visibility',
			'type' => 'select',
			'instructions' => 'Show or hide the classic header in your website, default is show. <br />
<small>Note: You\'ll still be able to place header templates.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Show',
				3 => 'Hide',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5c62f34749981',
			'label' => 'Type',
			'name' => 'header_type',
			'type' => 'select',
			'instructions' => 'Select the type of header. <br />
<small>Note: The default option won\'t work if visibility is set to hide.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Default',
				3 => 'Template',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5c62f36049982',
			'label' => 'Template',
			'name' => 'header_template',
			'type' => 'post_object',
			'instructions' => 'Select the template. <br /><small>Note: Do not forget to add headers in Elementor Templates.</small>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62f34749981',
						'operator' => '==',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'post_type' => array(
				0 => 'elementor_library',
			),
			'taxonomy' => array(
				0 => 'elementor_library_type:header',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'return_format' => 'id',
			'ui' => 1,
		),
		array(
			'key' => 'field_5b9faea95b33f',
			'label' => 'Skin',
			'name' => 'header_skin',
			'type' => 'select',
			'instructions' => 'Select the header skin, light skin means white logo text and white hamburger.
<br />
<small>Note: The default option is dark skin.</small>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62f34749981',
						'operator' => '!=',
						'value' => '3',
					),
					array(
						'field' => 'field_5c62f32349980',
						'operator' => '!=',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Dark',
				3 => 'Light',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9faf2add5a5',
			'label' => 'Position',
			'name' => 'header_position',
			'type' => 'select',
			'instructions' => 'Select the header position, the absolute header will push the content to the top of the page
<br />
<small>Note: The default option is static.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Static',
				3 => 'Absolute',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9faf51dd5a6',
			'label' => 'Transparency',
			'name' => 'header_transparency',
			'type' => 'select',
			'instructions' => 'Select the header transparency, sticky will stay fixed in the scroll option.
<br />
<small>Note: The default option is normal.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Normal',
				3 => 'Sticky',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5c62f3c249984',
			'label' => 'Template',
			'name' => 'header_sticky_template',
			'type' => 'post_object',
			'instructions' => 'Select the header template that will be used as sticky.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5b9faf51dd5a6',
						'operator' => '==',
						'value' => '3',
					),
					array(
						'field' => 'field_5c62f34749981',
						'operator' => '==',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'post_type' => array(
				0 => 'elementor_library',
			),
			'taxonomy' => array(
				0 => 'elementor_library_type:header',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'return_format' => 'id',
			'ui' => 1,
		),
		array(
			'key' => 'field_5b9faf74dd5a7',
			'label' => 'Autohide',
			'name' => 'header_autohide',
			'type' => 'select',
			'instructions' => 'Switch on if you want to activate the autohide header. The header will be hidden when scrolling down, it will appear only when the user scrolls up, the option is valid only when Sticky is selected as transparency. 
<br />
<small>Note: The default option is on, when sticky is selected.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'On',
				3 => 'Off',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9faf9bd4005',
			'label' => 'Container',
			'name' => 'header_container',
			'type' => 'select',
			'instructions' => 'Select if you want to use container holder for the header if disable is selected the header will push into left and right.
<br />
<small>Note: The default option is on.</small>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62f32349980',
						'operator' => '!=',
						'value' => '3',
					),
					array(
						'field' => 'field_5c62f34749981',
						'operator' => '!=',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'On',
				3 => 'Off',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fafbb13bc8',
			'label' => 'Logo',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62f32349980',
						'operator' => '!=',
						'value' => '3',
					),
					array(
						'field' => 'field_5c62f34749981',
						'operator' => '!=',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5b9fb253a1722',
			'label' => 'Dark',
			'name' => 'header_dark_logo',
			'type' => 'image',
			'instructions' => 'Upload your logo, will be used as a dark logo. 
<br />
<small>Note: In case the skin is selected Light, this logo will not be visible in default transparency.</small>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62f32349980',
						'operator' => '!=',
						'value' => '3',
					),
					array(
						'field' => 'field_5c62f34749981',
						'operator' => '!=',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'id',
			'preview_size' => 'thumbnail',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '',
		),
		array(
			'key' => 'field_5b9fb277a1723',
			'label' => 'Light',
			'name' => 'header_light_logo',
			'type' => 'image',
			'instructions' => 'Upload your light logo, will be used as white logo in light skin.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62f32349980',
						'operator' => '!=',
						'value' => '3',
					),
					array(
						'field' => 'field_5c62f34749981',
						'operator' => '!=',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'id',
			'preview_size' => 'thumbnail',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '',
		),
		array(
			'key' => 'field_5b9fb28da1724',
			'label' => 'Width',
			'name' => 'header_logo_width',
			'type' => 'number',
			'instructions' => 'Enter the number that will change the logo image width. 
<br />
<small>Note: Enter only the number without {px}.</small>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62f32349980',
						'operator' => '!=',
						'value' => '3',
					),
					array(
						'field' => 'field_5c62f34749981',
						'operator' => '!=',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => 'px',
			'min' => 1,
			'max' => '',
			'step' => 1,
		),
		array(
			'key' => 'field_5b9fb2b8a1726',
			'label' => 'Height',
			'name' => 'header_logo_height',
			'type' => 'number',
			'instructions' => 'Enter the number that will change the logo image height. 
<br />
<small>Note: Enter only the number without {px}.</small>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62f32349980',
						'operator' => '!=',
						'value' => '3',
					),
					array(
						'field' => 'field_5c62f34749981',
						'operator' => '!=',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => 'px',
			'min' => 1,
			'max' => '',
			'step' => 1,
		),
		array(
			'key' => 'field_5bd1ce6469b86',
			'label' => 'Other',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62f32349980',
						'operator' => '!=',
						'value' => '3',
					),
					array(
						'field' => 'field_5c62f34749981',
						'operator' => '!=',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5bd1ce3369b84',
			'label' => 'Top Header',
			'name' => 'top_header_visibility',
			'type' => 'select',
			'instructions' => 'Select the visibility of the top header. <br />
<small>Note: The default option is hide.</small>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62f32349980',
						'operator' => '!=',
						'value' => '3',
					),
					array(
						'field' => 'field_5c62f34749981',
						'operator' => '!=',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Show',
				3 => 'Hide',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5bd1cf1c69b89',
			'label' => 'Search',
			'name' => 'header_search_visibility',
			'type' => 'select',
			'instructions' => 'Select the visibility of the search. <br />
<small>Note: The default option is show.</small>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62f32349980',
						'operator' => '!=',
						'value' => '3',
					),
					array(
						'field' => 'field_5c62f34749981',
						'operator' => '!=',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Show',
				3 => 'Hide',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5bd1cee469b87',
			'label' => 'Sliding Bar',
			'name' => 'sliding_bar_visibility',
			'type' => 'select',
			'instructions' => 'Select the visibility of the sliding bar. <br />
<small>Note: The default option is hide.</small>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62f32349980',
						'operator' => '!=',
						'value' => '3',
					),
					array(
						'field' => 'field_5c62f34749981',
						'operator' => '!=',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Show',
				3 => 'Hide',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5bd1cef969b88',
			'label' => 'Shopping Cart',
			'name' => 'shopping_cart_visibility',
			'type' => 'select',
			'instructions' => 'Select the visibility of the shopping cart.<br />
<small>Note: The default option is show.</small>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62f32349980',
						'operator' => '!=',
						'value' => '3',
					),
					array(
						'field' => 'field_5c62f34749981',
						'operator' => '!=',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Show',
				3 => 'Hide',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fae483a716',
			'label' => 'Footer',
			'name' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_5b9fb2ead1b1e',
			'label' => 'General',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5c62fb6466b36',
			'label' => 'Type',
			'name' => 'footer_type',
			'type' => 'select',
			'instructions' => 'Select the footer type. <br /> <small>Note: Make sure to create templates with Elementor as footer type.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Default',
				3 => 'Template',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5c62fb8366b37',
			'label' => 'Template',
			'name' => 'footer_template',
			'type' => 'post_object',
			'instructions' => 'Select the footer template.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62fb6466b36',
						'operator' => '==',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'post_type' => array(
				0 => 'elementor_library',
			),
			'taxonomy' => array(
				0 => 'elementor_library_type:footer',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'return_format' => 'id',
			'ui' => 1,
		),
		array(
			'key' => 'field_5b9fb2f5d1b1f',
			'label' => 'Skin',
			'name' => 'footer_skin',
			'type' => 'select',
			'instructions' => 'Select the footer skin, if dark is selected the background will be dark and elements and vice versa. <br />
<small>Note: The default option is dark.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Dark',
				3 => 'Light',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fb311d1b20',
			'label' => 'Container',
			'name' => 'footer_container',
			'type' => 'select',
			'instructions' => 'Select if you want to use container holder for the footer if off is selected the footer will push into left and right.
<br />
<small>Note: The default option is on.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'On',
				3 => 'Off',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5ce56011f476a',
			'label' => 'Parallax',
			'name' => 'footer_parallax',
			'type' => 'select',
			'instructions' => 'Enable a parallax effect for your footer. The footer will come smoothly in the position fixed when scrolling at the bottom. <br />
<small>Note: The default option is off.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'On',
				3 => 'Off',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5bc714993f2ce',
			'label' => 'Widgets',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62fb6466b36',
						'operator' => '!=',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5b9fb327d1b21',
			'label' => 'Widgets',
			'name' => 'footer_widgets',
			'type' => 'select',
			'instructions' => 'Switch on if you want to show the widgets on the footer.
<br />
<small>Note: The default option is on.</small>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62fb6466b36',
						'operator' => '!=',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'On',
				3 => 'Off',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fb346d1b23',
			'label' => 'Columns',
			'name' => 'footer_widgets_columns',
			'type' => 'select',
			'instructions' => 'Select the columns of widgets.
<br />
<small>Note: The default option is 4 columns.</small>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62fb6466b36',
						'operator' => '!=',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => '1 Column',
				3 => '2 Columns',
				4 => '3 Columns',
				5 => '4 Columns',
				6 => '5 Columns',
				7 => '6 Columns',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fb35bd1b24',
			'label' => 'Mobile Visibility',
			'name' => 'footer_widgets_mobile_visibility',
			'type' => 'select',
			'instructions' => 'Select the visibility of the widgets in mobile layout mode (< 768px).
<br />
<small>Note: The default option is visible.</small>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62fb6466b36',
						'operator' => '!=',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Visible',
				3 => 'Hidden',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fb3b781b3a',
			'label' => 'Copyright',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62fb6466b36',
						'operator' => '!=',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5bc9ea6b88306',
			'label' => 'Visibility',
			'name' => 'footer_copyright_visibility',
			'type' => 'select',
			'instructions' => 'Show or hide the copyright, by hiding the copyright the social media will be hidden too.
<br />
<small>Note: The default option is show.</small>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62fb6466b36',
						'operator' => '!=',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Show',
				3 => 'Hide',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fb3c381b3b',
			'label' => 'Alignment',
			'name' => 'footer_copyright_alignment',
			'type' => 'select',
			'instructions' => 'Select the alignment of copyright, if selected left the social media will be placed on the right and vice versa.
<br />
<small>Note: The default option is left.</small>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62fb6466b36',
						'operator' => '!=',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Left',
				3 => 'Right',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fb3df81b3c',
			'label' => 'Social Media',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62fb6466b36',
						'operator' => '!=',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5b9fb3ee81b3d',
			'label' => 'Visibility',
			'name' => 'footer_social_media_visibility',
			'type' => 'select',
			'instructions' => 'Show or hide the social media in the footer.
<br />
<small>Note: The default option is show.</small>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5c62fb6466b36',
						'operator' => '!=',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Show',
				3 => 'Hide',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fb41d81b3e',
			'label' => 'Portfolio Item Settings',
			'name' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_5b9fb544f60f4',
			'label' => 'Functionality',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5b9fb5a3f9300',
			'label' => 'Type',
			'name' => 'portfolio_item_type',
			'type' => 'select',
			'instructions' => 'Select the type of portfolio item.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Side Portfolio',
				2 => 'Vertical Portfolio',
				3 => 'Elementor',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fb5bbf9301',
			'label' => 'Subtitle',
			'name' => 'portfolio_item_subtitle',
			'type' => 'text',
			'instructions' => 'Enter the subtitle of portfolio item.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => 'Hey there! I am a subtitle.',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_5b9fb7c21abd0',
			'label' => 'Side Portfolio',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5b9fb5a3f9300',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5ba90449de6fa',
			'label' => 'Description Sticky',
			'name' => 'side_portfolio_description_sticky',
			'type' => 'true_false',
			'instructions' => 'Make the portfolio content fixed when scrolling.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5b9fb5a3f9300',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_5b9fb7cd1abd1',
			'label' => 'Description Alignment',
			'name' => 'side_portfolio_description_alignment',
			'type' => 'select',
			'instructions' => 'Select the alignment of description.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5b9fb5a3f9300',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Left',
				2 => 'Right',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fb856474bb',
			'label' => 'Description Width',
			'name' => 'side_portfolio_description_width',
			'type' => 'select',
			'instructions' => 'Select the width of description.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5b9fb5a3f9300',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'One Half (1/2)',
				2 => 'One Third Column (1/3)',
				3 => 'One Fourth Column (1/4)',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fb9135804b',
			'label' => 'Vertical Portfolio',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5b9fb5a3f9300',
						'operator' => '==',
						'value' => '2',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5b9fb9475804c',
			'label' => 'Description Place',
			'name' => 'vertical_portfolio_description_place',
			'type' => 'select',
			'instructions' => 'Select the place of description, the default is above the gallery.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5b9fb5a3f9300',
						'operator' => '==',
						'value' => '2',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Above Gallery',
				2 => 'Below Gallery',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fb9635804d',
			'label' => 'Description Width',
			'name' => 'vertical_portfolio_description_width',
			'type' => 'select',
			'instructions' => 'Select the width of description.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5b9fb5a3f9300',
						'operator' => '==',
						'value' => '2',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Full Width Column (1/1)',
				2 => 'One Half Column (1/2)',
				3 => 'Two Third Column (2/3)',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fb989e6a9d',
			'label' => 'Elementor',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5b9fb5a3f9300',
						'operator' => '==',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '<p>Make sure to enable Elementor for the post type Portfolio in <a href="admin.php?page=elementor"> Elementor Settings</a>.</p>',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5b9fb9fc64888',
			'label' => 'Navigation',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5b9fba0a64889',
			'label' => 'Visibility',
			'name' => 'portfolio_item_navigation_visibility',
			'type' => 'select',
			'instructions' => 'Show or hide the navigation on portfolio item.
<br />
<small>Note: The default option is show.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Show',
				3 => 'Hide',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fba1e6488a',
			'label' => 'Category',
			'name' => 'portfolio_item_navigation_category',
			'type' => 'select',
			'instructions' => 'Enable if you want the posts to be navigated only in the same category.
<br />
<small>Note: The default option is disable.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Enable',
				3 => 'Disable',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fba326488b',
			'label' => 'Portfolio Item Gallery',
			'name' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'top',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_5b9fba426488c',
			'label' => 'Columns',
			'name' => 'portfolio_item_gallery_columns',
			'type' => 'select',
			'instructions' => 'Select the columns of the portfolio item gallery.
<br />
<small>Note: The default option is one column.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'One Column',
				3 => 'Two Columns',
				4 => 'Three Columns',
				5 => 'Four Columns',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fba576488d',
			'label' => 'Animation',
			'name' => 'portfolio_item_gallery_animation',
			'type' => 'select',
			'instructions' => 'Select initial loading animation for the gallery.
<br />
<small>Note: The default option is fade in.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'None',
				3 => 'Fade In',
				4 => 'Fade In Up',
				5 => 'Fade In (with delay)',
				6 => 'Fade In Up (with delay)',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fba676488e',
			'label' => 'Gallery',
			'name' => 'portfolio_item_gallery',
			'type' => 'flexible_content',
			'instructions' => 'Add gallery items.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layouts' => array(
				'5b9fba72c0b5e' => array(
					'key' => '5b9fba72c0b5e',
					'name' => 'portfolio_item_gallery_image',
					'label' => 'Image',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_5b9fba836488f',
							'label' => 'Image',
							'name' => 'portfolio_item_gallery_image_obj',
							'type' => 'image',
							'instructions' => 'Upload an image.',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'preview_size' => 'thumbnail',
							'library' => 'all',
							'min_width' => '',
							'min_height' => '',
							'min_size' => '',
							'max_width' => '',
							'max_height' => '',
							'max_size' => '',
							'mime_types' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
			),
			'button_label' => 'Add Gallery Item',
			'min' => '',
			'max' => '',
		),
		array(
			'key' => 'field_5b9fbad6dc460',
			'label' => 'Portfolio Item Tabs',
			'name' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'top',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_5b9fbae0dc461',
			'label' => 'Custom Tabs',
			'name' => 'portfolio_item_custom_tabs',
			'type' => 'repeater',
			'instructions' => 'Add custom tabs to your project item.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'collapsed' => '',
			'min' => 0,
			'max' => 0,
			'layout' => 'block',
			'button_label' => 'Add Tab',
			'sub_fields' => array(
				array(
					'key' => 'field_5b9fbaf7dc462',
					'label' => 'Title',
					'name' => 'portfolio_item_custom_tabs_title',
					'type' => 'text',
					'instructions' => 'Enter the title of tab.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array(
					'key' => 'field_5b9fbb03dc463',
					'label' => 'Type',
					'name' => 'portfolio_item_custom_tabs_type',
					'type' => 'button_group',
					'instructions' => 'Select if you want to show plain description or link.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						1 => 'Description',
						2 => 'Link',
					),
					'allow_null' => 0,
					'default_value' => 1,
					'layout' => 'horizontal',
					'return_format' => 'value',
				),
				array(
					'key' => 'field_5b9fbb25dc464',
					'label' => 'Description',
					'name' => 'portfolio_item_custom_tabs_description',
					'type' => 'textarea',
					'instructions' => 'Enter the tab description.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5b9fbb03dc463',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => 'The tab description.',
					'maxlength' => '',
					'rows' => '',
					'new_lines' => '',
				),
				array(
					'key' => 'field_5b9fbb48dc465',
					'label' => 'Link Title',
					'name' => 'portfolio_item_custom_tabs_link_title',
					'type' => 'text',
					'instructions' => 'Enter the name of link, incase you don\'t write any title, the url will be used as title.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5b9fbb03dc463',
								'operator' => '==',
								'value' => '2',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => 'Just another website!',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array(
					'key' => 'field_5b9fbb5adc466',
					'label' => 'Link Url',
					'name' => 'portfolio_item_custom_tabs_link_url',
					'type' => 'url',
					'instructions' => 'Enter the name of the link, in case you don\'t write any title, the url will be used as the title.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5b9fbb03dc463',
								'operator' => '==',
								'value' => '2',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => 'http://www.neuronthemes.com',
				),
				array(
					'key' => 'field_5b9fbb8ddc467',
					'label' => 'Link Target',
					'name' => 'portfolio_item_custom_tabs_link_target',
					'type' => 'true_false',
					'instructions' => 'Tick if you want the link to be opened in a new tab.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5b9fbb03dc463',
								'operator' => '==',
								'value' => '2',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => 'New Tab',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
			),
		),
		array(
			'key' => 'field_5b9fbc9dc94b5',
			'label' => 'Hero',
			'name' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_5b9fbe87c94b6',
			'label' => 'Settings',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5b9fbe8fc94b7',
			'label' => 'Visibility',
			'name' => 'hero_visibility',
			'type' => 'select',
			'instructions' => 'Show or hide the hero.
<br />
<small>Note: The default option is show.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Show',
				3 => 'Hide',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fbeb1c94b9',
			'label' => 'Height',
			'name' => 'hero_height',
			'type' => 'select',
			'instructions' => 'Inherit the value of height from Theme Options or set it custom.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Custom',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fbec7c94ba',
			'label' => 'Custom Height',
			'name' => 'hero_custom_height',
			'type' => 'text',
			'instructions' => 'Enter the height with units.
<br />
<small>Note: Do not forget to add the unit too, for example px/vh/rem/em/%.</small>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5b9fbeb1c94b9',
						'operator' => '==',
						'value' => '2',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '500px',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_5b9fc6a3c94bb',
			'label' => 'Container',
			'name' => 'hero_container',
			'type' => 'select',
			'instructions' => 'Select if you want the hero to be boxed in 1140px width or not.
<br />
<small>Note: The default option is on.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'On',
				3 => 'Off',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fc8ca53dae',
			'label' => 'Image',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5b9fc6e6c94be',
			'label' => 'Image',
			'name' => 'hero_image',
			'type' => 'select',
			'instructions' => 'Select the image you want to display as hero background image. <br />
<small>Note: The default option is no image.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Use the post/page featured image',
				3 => 'Use the theme default image',
				4 => 'Custom Image',
				5 => 'No Image',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fc701c94bf',
			'label' => 'Custom Image',
			'name' => 'hero_custom_image',
			'type' => 'image',
			'instructions' => 'Select the custom image you want to display as hero background image.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5b9fc6e6c94be',
						'operator' => '==',
						'value' => '4',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'id',
			'preview_size' => 'thumbnail',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '',
		),
		array(
			'key' => 'field_5b9fc71fc94c0',
			'label' => 'Repeat',
			'name' => 'hero_image_repeat',
			'type' => 'select',
			'instructions' => 'Select the image repeat settings. <br />
<small>Note: The default option is no repeat.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'No Repeat',
				3 => 'Repeat All',
				4 => 'Repeat Horizontally',
				5 => 'Repeat Vertically',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fc732c94c1',
			'label' => 'Attachment',
			'name' => 'hero_image_attachment',
			'type' => 'select',
			'instructions' => 'Select the image attachment settings. <br />
<small>Note: The default option is scroll.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Scroll',
				3 => 'Fixed',
				4 => 'Local',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fc746c94c2',
			'label' => 'Position',
			'name' => 'hero_image_position',
			'type' => 'select',
			'instructions' => 'Select the image position settings. <br />
<small>Note: The default option is center center.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Left Top',
				3 => 'Left Center',
				4 => 'Left Bottom',
				5 => 'Center Top',
				6 => 'Center Center',
				7 => 'Center Bottom',
				8 => 'Right Top',
				9 => 'Right Center',
				10 => 'Right Bottom',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5c23a533f5e3f',
			'label' => 'Size',
			'name' => 'hero_image_size',
			'type' => 'select',
			'instructions' => 'Select the image size settings. <br />
<small>Note: The default option is cover.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Auto',
				3 => 'Cover',
				4 => 'Contain',
				5 => 'Initial',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fc75fc94c3',
			'label' => 'Overlay',
			'name' => 'hero_image_overlay',
			'type' => 'select',
			'instructions' => 'Show an overlay for the background image. <br />
<small>Note: The default option is hide.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Show',
				3 => 'Hide',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fc774c94c4',
			'label' => 'Overlay Opacity',
			'name' => 'hero_image_overlay_opacity',
			'type' => 'number',
			'instructions' => 'Enter the number of overlay opacity, the number can be in range of 0 and 1.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5b9fc75fc94c3',
						'operator' => '==',
						'value' => '2',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'min' => 0,
			'max' => 1,
			'step' => '0.01',
		),
		array(
			'key' => 'field_5b9fc790c94c5',
			'label' => 'Overlay Color',
			'name' => 'hero_image_overlay_color',
			'type' => 'color_picker',
			'instructions' => 'Select the color of overlay.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5b9fc75fc94c3',
						'operator' => '==',
						'value' => '2',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
		),
		array(
			'key' => 'field_5b9fc6c6c94bc',
			'label' => 'Alignment',
			'name' => 'hero_alignment',
			'type' => 'select',
			'instructions' => 'Select the text alignment of the hero. <br />
<small>Note: The default option is left.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Left',
				3 => 'Center',
				4 => 'Right',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fc7a2c94c6',
			'label' => 'Title',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5b9fc7aac94c7',
			'label' => 'Title',
			'name' => 'hero_title',
			'type' => 'select',
			'instructions' => 'Select the title you want to display in the hero. <br />
<small>Note: The default option is use this post/page title.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Use this post/page title',
				3 => 'Custom Title',
				4 => 'No Title',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fc7c5c94c9',
			'label' => 'Custom Title',
			'name' => 'hero_custom_title',
			'type' => 'textarea',
			'instructions' => 'Enter the title, it accepts html tags too.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5b9fc7aac94c7',
						'operator' => '==',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'maxlength' => '',
			'rows' => '',
			'new_lines' => 'br',
		),
		array(
			'key' => 'field_5b9fc7e7c94ca',
			'label' => 'Animation',
			'name' => 'hero_title_animation',
			'type' => 'select',
			'instructions' => 'Select initial loading animation for the title. <br />
<small>Note: The default option in Fade In.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'None',
				3 => 'Fade In',
				4 => 'Fade In Up',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5be08bf1a2cc1',
			'label' => 'Color',
			'name' => 'hero_title_color',
			'type' => 'select',
			'instructions' => 'Select the color of title. <br />
<small>Note: The default option in #232931.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Custom',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5be08c0aa2cc2',
			'label' => 'Custom Color',
			'name' => 'hero_title_color_custom',
			'type' => 'color_picker',
			'instructions' => 'Select the custom color from the picker.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5be08bf1a2cc1',
						'operator' => '==',
						'value' => '2',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '#232931',
		),
		array(
			'key' => 'field_5c3daad4b557b',
			'label' => 'Breadcrumb',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5c3dab01b557c',
			'label' => 'Breadcrumb',
			'name' => 'hero_breadcrumb',
			'type' => 'select',
			'instructions' => 'Show the breadcrumb on hero.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Show',
				3 => 'Hide',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fc8f5ae0d5',
			'label' => 'Product',
			'name' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'top',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_5b9fc8fdae0d6',
			'label' => 'General',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5b9fc907ae0d7',
			'label' => 'Navigation',
			'name' => 'product_navigation',
			'type' => 'select',
			'instructions' => 'Select the visibility of the navigation. <br />
<small>Note: The default option is show.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Show',
				3 => 'Hide',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fc91dae0d8',
			'label' => 'Gallery',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5b9fc926ae0d9',
			'label' => 'Alignment',
			'name' => 'product_gallery_alignment',
			'type' => 'select',
			'instructions' => 'Select the alignment of the gallery, if left is selected the content will move right and vice versa. <br />
<small>Note: The default option is left.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Left',
				3 => 'Right',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fc941ae0da',
			'label' => 'Width',
			'name' => 'product_gallery_width',
			'type' => 'select',
			'instructions' => 'Select the width of the gallery. <br />
<small>Note: The default option is one half (1/2).</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'One Half (1/2)',
				3 => 'Two Third Column (2/3)',
				4 => 'Three Fourth Column (3/4)',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fc964ae0db',
			'label' => 'Related',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5b9fc96cae0dc',
			'label' => 'Visibility',
			'name' => 'product_related_visibility',
			'type' => 'select',
			'instructions' => 'Select the visibility of the related products. <br />
<small>Note: The default option is show.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Show',
				3 => 'Hide',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fc984ae0dd',
			'label' => 'Number',
			'name' => 'product_related_count',
			'type' => 'select',
			'instructions' => 'Select how many products you want to display in the related section.
<small>Note: The default option is 4 products</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => '1 Product',
				3 => '2 Products',
				4 => '3 Products',
				5 => '4 Products',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5ba524cf15054',
			'label' => 'Post Single',
			'name' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_5bb388cf621e4',
			'label' => 'Thumbnail',
			'name' => 'blog_post_thumbnail',
			'type' => 'select',
			'instructions' => 'Show or hide the thumbnail on post. <br />
<small>Note: The default option is show.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Show',
				3 => 'Hide',
				4 => 'Custom',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5cdad9ebcf9d1',
			'label' => 'Custom Thumbnail',
			'name' => 'blog_post_custom_thumbnail',
			'type' => 'image',
			'instructions' => 'Upload the custom thumbnail.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5bb388cf621e4',
						'operator' => '==',
						'value' => '4',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'array',
			'preview_size' => 'medium',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '',
		),
		array(
			'key' => 'field_5ba525dd15056',
			'label' => 'Navigation Visibility',
			'name' => 'blog_post_navigation_visibility',
			'type' => 'select',
			'instructions' => 'Show or hide the navigation on post. <br />
<small>Note: The default option is show.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Show',
				3 => 'Hide',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5ba5261215057',
			'label' => 'Navigation Category',
			'name' => 'blog_post_navigation_category',
			'type' => 'select',
			'instructions' => 'Enable if you want the posts to be navigated only in the same category. <br />
<small>Note: The default option is disable.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Enable',
				3 => 'Disable',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5ba5263a15058',
			'label' => 'Share',
			'name' => 'blog_post_share',
			'type' => 'select',
			'instructions' => 'Select the visibility of share icons. <br />
<small>Note: The default option is show.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Show',
				3 => 'Hide',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5ba5274615059',
			'label' => 'Sidebar',
			'name' => 'blog_post_sidebar',
			'type' => 'select',
			'instructions' => 'Select the placement of sidebar or hide it. <br />
<small>Note: The default option is right.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Left',
				3 => 'Right',
				4 => 'Hide',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5cdade0ea8a88',
			'label' => 'Author Box',
			'name' => 'blog_post_author_box',
			'type' => 'select',
			'instructions' => 'Show or hide the author box in the end of post. <br />
<small>Note: The default option is show.</small>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Show',
				3 => 'Hide',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5cdc1991bf16f',
			'label' => 'Related',
			'name' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_5cdc1ae4bf170',
			'label' => 'Related',
			'name' => 'related_posts',
			'type' => 'select',
			'instructions' => 'Show or hide the related posts.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Show',
				3 => 'Hide',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5cdc1b36bf171',
			'label' => 'Template',
			'name' => 'related_posts_template',
			'type' => 'post_object',
			'instructions' => 'Show or hide the related posts.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5cdc1ae4bf170',
						'operator' => '==',
						'value' => '2',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'post_type' => array(
				0 => 'elementor_library',
			),
			'taxonomy' => '',
			'allow_null' => 0,
			'multiple' => 0,
			'return_format' => 'id',
			'ui' => 1,
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'post',
			),
		),
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'page',
			),
		),
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'portfolio',
			),
		),
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'product',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_5b9fc9ef281df',
	'title' => 'Taxonomy Settings',
	'fields' => array(
		array(
			'key' => 'field_5bab80e915c90',
			'label' => 'General',
			'name' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'top',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_5bab80f745bf9',
			'label' => 'Breadcrumb',
			'name' => 'general_archive_breadcrumb',
			'type' => 'select',
			'instructions' => 'Show or hide the breadcrumb of this archive.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Show',
				3 => 'Hide',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fc9ef37dfc',
			'label' => 'Hero',
			'name' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'top',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_5b9fc9ef37e1e',
			'label' => 'Settings',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5b9fc9ef380c7',
			'label' => 'Visibility',
			'name' => 'hero_visibility',
			'type' => 'text',
			'instructions' => '',
			'required' => false,
			'conditional_logic' => false,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			0 => false,
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_5b9fc9ef381b8',
			'label' => 'Height',
			'name' => 'hero_height',
			'type' => 'select',
			'instructions' => 'Inherit the value of height from Theme Options or set it custom.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Custom',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fc9ef38207',
			'label' => 'Custom Height',
			'name' => 'hero_custom_height',
			'type' => 'text',
			'instructions' => '',
			'required' => false,
			'conditional_logic' => false,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			0 => false,
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_5b9fc9ef38286',
			'label' => 'Container',
			'name' => 'hero_container',
			'type' => 'text',
			'instructions' => '',
			'required' => false,
			'conditional_logic' => false,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			0 => false,
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_5b9fc9ef38389',
			'label' => 'Alignment',
			'name' => 'hero_alignment',
			'type' => 'text',
			'instructions' => '',
			'required' => false,
			'conditional_logic' => false,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			0 => false,
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_5b9fc9ef383d3',
			'label' => 'Image',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5b9fc9ef386ed',
			'label' => 'Image',
			'name' => 'hero_image',
			'type' => 'select',
			'instructions' => 'Select the image you want to display as hero background image. <br />',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Use the theme default image',
				3 => 'Custom Image',
				4 => 'No Image',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5b9fc9ef38a86',
			'label' => 'Custom Image',
			'name' => 'hero_custom_image',
			'type' => 'image',
			'instructions' => 'Select the custom image you want to display as hero background image.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5b9fc9ef386ed',
						'operator' => '==',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'id',
			'preview_size' => 'thumbnail',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '',
		),
		array(
			'key' => 'field_5b9fc9ef38b0e',
			'label' => 'Repeat',
			'name' => 'hero_image_repeat',
			'type' => 'text',
			'instructions' => '',
			'required' => false,
			'conditional_logic' => false,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			0 => false,
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_5b9fc9ef38b4f',
			'label' => 'Attachment',
			'name' => 'hero_image_attachment',
			'type' => 'text',
			'instructions' => '',
			'required' => false,
			'conditional_logic' => false,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			0 => false,
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_5b9fc9ef38bdd',
			'label' => 'Position',
			'name' => 'hero_image_position',
			'type' => 'text',
			'instructions' => '',
			'required' => false,
			'conditional_logic' => false,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			0 => false,
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_5c23a464721b0',
			'label' => 'Size',
			'name' => 'hero_image_size',
			'type' => 'text',
			'instructions' => '',
			'required' => false,
			'conditional_logic' => false,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			0 => false,
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_5b9fc9ef38c17',
			'label' => 'Overlay',
			'name' => 'hero_image_overlay',
			'type' => 'text',
			'instructions' => '',
			'required' => false,
			'conditional_logic' => false,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			0 => false,
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_5b9fc9ef38edc',
			'label' => 'Overlay Opacity',
			'name' => 'hero_image_overlay_opacity',
			'type' => 'number',
			'instructions' => 'Enter the number of overlay opacity, the number can be in range of 0 and 1.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5b9fc9ef38c17',
						'operator' => '==',
						'value' => '2',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'min' => 0,
			'max' => 1,
			'step' => '0.01',
		),
		array(
			'key' => 'field_5b9fc9ef38f28',
			'label' => 'Overlay Color',
			'name' => 'hero_image_overlay_color',
			'type' => 'color_picker',
			'instructions' => 'Select the color of overlay.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5b9fc9ef38c17',
						'operator' => '==',
						'value' => '2',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
		),
		array(
			'key' => 'field_5b9fc9ef3935e',
			'label' => 'Title',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5b9fc9ef397c5',
			'label' => 'Title',
			'name' => 'hero_title',
			'type' => 'text',
			'instructions' => '',
			'required' => false,
			'conditional_logic' => false,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			0 => false,
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_5b9fc9ef39c2c',
			'label' => 'Custom Title',
			'name' => 'hero_custom_title',
			'type' => 'textarea',
			'instructions' => 'Enter the title, it accepts html tags too.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5b9fc9ef397c5',
						'operator' => '==',
						'value' => '3',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'maxlength' => '',
			'rows' => '',
			'new_lines' => 'br',
		),
		array(
			'key' => 'field_5b9fc9ef39cb6',
			'label' => 'Animation',
			'name' => 'hero_title_animation',
			'type' => 'text',
			'instructions' => '',
			'required' => false,
			'conditional_logic' => false,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			0 => false,
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_5be08ce86ca55',
			'label' => 'Color',
			'name' => 'hero_title_color',
			'type' => 'text',
			'instructions' => '',
			'required' => false,
			'conditional_logic' => false,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			0 => false,
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_5be08d201930a',
			'label' => 'Custom Color',
			'name' => 'hero_title_color_custom',
			'type' => 'color_picker',
			'instructions' => 'Select the custom color from the picker.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5be08ce86ca55',
						'operator' => '==',
						'value' => '2',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '#000000',
		),
		array(
			'key' => 'field_5c40d285d0f9b',
			'label' => 'Breadcrumb',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5c40d28bd0f9c',
			'label' => 'Breadcrumb',
			'name' => 'hero_breadcrumb',
			'type' => 'select',
			'instructions' => 'Show the breadcrumb on the hero.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 'Inherit',
				2 => 'Show',
				3 => 'Hide',
			),
			'default_value' => array(
				0 => 1,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'taxonomy',
				'operator' => '==',
				'value' => 'all',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'modified' => 1547752097,
));

endif;