<?php

/**
 * Core functions loaded here
 *
 * @package blockshop
 */

if (! function_exists('blockshop_fs')) {
	$option_key = 'blockshop_fs_delay';
	$is_delayed = get_option($option_key);

	if (!$is_delayed) {
		update_option($option_key, time());
	} else {
		if ((time() - $is_delayed) > 3600*12) {

			function blockshop_fs() {
				global $blockshop_fs;
		
				if ( ! isset( $blockshop_fs ) ) {
					// Include Freemius SDK.
					require_once dirname( __FILE__ ) . '/vendor/freemius/start.php';
					$blockshop_fs = fs_dynamic_init( array(
						'id'                  => '16128',
						'slug'                => 'block-shop',
						'type'                => 'theme',
						'public_key'          => 'pk_49ac6061d8b22b6bcab06cb042bb5',
						'is_premium'          => false,
						'has_addons'          => false,
						'has_paid_plans'      => false,
						'is_org_compliant'    => false,
						'menu'                => array(
							'slug'           => 'getbowtied-dashboard',
							'first-path'     => 'admin.php?page=getbowtied-dashboard',
							'contact'        => false,
							'support'        => false,
						),
					) );
				}
		
				return $blockshop_fs;
			}

			blockshop_fs();
			do_action('blockshop_fs_loaded');
		}
	}
}

require_once get_template_directory() . '/core/init.php';
