jQuery(document).ready(function($) {
    // Use delegated event binding to fix double-click issue
    $(document).on('click', '.rz--delete-conversation', function(e) {
        e.preventDefault();

        if (!confirm('Are you sure you want to delete this conversation?')) {
            return;
        }

        var postId = $(this).data('id');

        $.ajax({
            url: chatDeleteAjax.ajax_url,
            type: 'POST',
            data: {
                action: 'delete_chat_conversation',
                post_id: postId,
                nonce: chatDeleteAjax.nonce
            },
            success: function(response) {
                if (response.success) {
                    // Remove the conversation row smoothly
                    $('tr').has('[data-id="' + postId + '"]').fadeOut();
                } else {
                    alert(response.data);
                }
            },
            error: function() {
                alert('Something went wrong. Please try again.');
            }
        });
    });
});
