<?php

// Get pages to exclude
$submission_page_id = get_option('rz_page_submission'); // Submission page
$explore_page_id    = get_option('rz_page_explore');    // Explore page
$myaccount_page_id  = get_option('woocommerce_myaccount_page_id'); // My Account page

$exclude_pages = array_filter([
    $submission_page_id,
    $explore_page_id,
    $myaccount_page_id
]);


// Get Elementor footer shortcode from theme options
$custom_footer_shortcode = get_option('rz_footer_shortcode');

if ( ! empty($custom_footer_shortcode) && ! is_page($exclude_pages) ) {
    // Render Elementor footer
    echo do_shortcode( stripslashes($custom_footer_shortcode) );
} else {

    // Default footer logic
    $has_footer = true;
    if( function_exists('is_account_page') and is_account_page() ) {
        $has_footer = false;
    }

    if( function_exists('routiz') and Rz()->is_submission() ) {
        $has_footer = false;
    }

    if( function_exists('routiz') and Rz()->get_meta('rz_hide_footer') ) {
        $has_footer = false;
    }

    $page_wide = Brk()->is_wide_page();
    $footer_columns = max( 3, min( 6, (int) get_option('rz_footer_columns') ) );

    if( $has_footer ): ?>
        <div class="brk-footer">

            <?php if( is_active_sidebar('footer-top') ): ?>
                <div class="brk--top">
                    <div class="brk-row">
                        <div class="brk--widgets">
                            <?php dynamic_sidebar('footer-top'); ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if( is_active_sidebar('footer') ): ?>
                <div class="brk--content" data-cols="<?php echo (int) $footer_columns; ?>">
                    <div class="brk-row">
                        <div class="brk--widgets">
                            <?php dynamic_sidebar('footer'); ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php $footer_copy = get_option( 'rz_footer_copy' ); ?>
            <?php $footer_summary = get_option( 'rz_footer_summary' ); ?>
            <?php $footer_account_text = get_option( 'rz_footer_account' ); ?>
            <?php if( empty( $footer_copy ) ) { $footer_copy = esc_html( get_bloginfo('description') ); } ?>
            <?php if( ! empty( $footer_copy ) || ! empty( $footer_summary ) || ! empty( $footer_account_text ) ): ?>
                <div class="brk--bottom">
                    <div class="brk-row">
                        <div class="brk--bottom-inner">
                            <?php if( ! empty( $footer_copy ) ): ?>
                                <div class="brk--cell-copy">
                                    <p><?php echo do_shortcode( stripslashes( $footer_copy ) ); ?></p>
                                </div>
                            <?php endif; ?>
                            <?php if( ! empty( $footer_summary ) ): ?>
                                <div class="brk--cell-copy">
                                    <p><?php echo do_shortcode( stripslashes( $footer_summary ) ); ?></p>
                                </div>
                            <?php endif; ?>
                            <?php if( ! empty( $footer_account_text ) ): ?>
                                <div class="brk--cell-copy">
                                    <p><?php echo do_shortcode( stripslashes( $footer_account_text ) ); ?></p>
                                </div>
                            <?php endif; ?>

                            <?php if( has_nav_menu('bottom') ): ?>
                                <div class="brk-site-nav">
                                    <nav class="brk-nav-bottom">
                                        <?php
                                            wp_nav_menu([
                                                'theme_location' => 'bottom',
                                                'container' => false,
                                                'depth' => 1
                                            ]);
                                        ?>
                                    </nav>
                                </div>
                            <?php endif; ?>

                        </div>
                    </div>
                </div>
            <?php endif; ?>

        </div>
    <?php endif; ?>
<?php } ?>

</div> <!-- end .site -->

<?php if( function_exists('routiz') ): ?>
    <?php get_template_part('templates/modals/lightbox'); ?>
<?php endif; ?>

<?php if( ! ( function_exists('routiz') and Rz()->is_submission() ) ): ?>
    <?php get_template_part('templates/mobile/bar'); ?>
<?php endif; ?>

<?php wp_footer(); ?>


<script>
jQuery(document).ready(function($) {
    let suggestionSelected = false;
    
    // Track when user selects suggestion from Google Places
    $(document).on('mousedown', '.pac-item', function() {
        suggestionSelected = true;
    });
    
    // Reset flag when user types
    $(document).on('input', 'input[name="rz_geo"]', function() {
        suggestionSelected = false;
    });
    
    // Handle Enter key press - Brikks specific approach
    $(document).on('keydown', 'input[name="rz_geo"]', function(e) {
        if (e.which === 13 || e.keyCode === 13) { // Enter key
            const $input = $(this);
            
            if (!suggestionSelected) {
                e.preventDefault();
                e.stopPropagation();
                
                // Wait a moment for suggestions to be visible
                setTimeout(function() {
                    // Look for the first visible suggestion
                    let $firstSuggestion = $('.pac-item:first:visible');
                    
                    // Alternative selectors for different implementations
                    if ($firstSuggestion.length === 0) {
                        $firstSuggestion = $('.pac-container:visible .pac-item:first');
                    }
                    if ($firstSuggestion.length === 0) {
                        $firstSuggestion = $('[class*="pac-item"]:visible:first');
                    }
                    
                    console.log('Suggestions found:', $('.pac-item').length); // Debug
                    console.log('Visible suggestions:', $('.pac-item:visible').length); // Debug
                    
                    if ($firstSuggestion.length > 0) {
                        // Simulate the exact same events that happen on manual click
                        $firstSuggestion[0].dispatchEvent(new MouseEvent('mousedown', {
                            bubbles: true,
                            cancelable: true,
                            view: window
                        }));
                        
                        $firstSuggestion[0].dispatchEvent(new MouseEvent('mouseup', {
                            bubbles: true,
                            cancelable: true,
                            view: window
                        }));
                        
                        $firstSuggestion[0].dispatchEvent(new MouseEvent('click', {
                            bubbles: true,
                            cancelable: true,
                            view: window
                        }));
                        
                        // Mark as selected
                        suggestionSelected = true;
                        
                        // Submit the form after Google Places processes the selection
                        setTimeout(function() {
                            // Try home page button first
                            if ($('.rz-search-submit button[type="submit"]').length > 0) {
                                $('.rz-search-submit button[type="submit"]')[0].click();
                            }
                            // Try explore page button
                            else if ($('.rz-button-accent.rz-action-filter').length > 0) {
                                $('.rz-button-accent.rz-action-filter')[0].click();
                            }
                            // Fallback to form submit
                            else {
                                $input.closest('form').submit();
                            }
                        }, 300);
                        
                    } else {
                        console.log('No suggestions found, checking input value'); // Debug
                        
                        // If there are no suggestions but there's text, allow submission
                        if ($input.val().trim().length > 0) {
                            suggestionSelected = true;
                            // Try home page button first
                            if ($('.rz-search-submit button[type="submit"]').length > 0) {
                                $('.rz-search-submit button[type="submit"]')[0].click();
                            }
                            // Try explore page button
                            else if ($('.rz-button-accent.rz-action-filter').length > 0) {
                                $('.rz-button-accent.rz-action-filter')[0].click();
                            }
                            // Fallback
                            else {
                                $input.closest('form').submit();
                            }
                        } else {
                            alert('Please type a location and select from suggestions');
                        }
                    }
                }, 100);
                
                return false;
            }
        }
    });
    
    // Additional approach: Use Google's native keyboard navigation
    $(document).on('keydown', 'input[name="rz_geo"]', function(e) {
        if (e.which === 13 && !suggestionSelected) {
            const input = this;
            
            // Try using Google's built-in keyboard navigation
            setTimeout(function() {
                // Simulate arrow down to highlight first suggestion
                const arrowDownEvent = new KeyboardEvent('keydown', {
                    key: 'ArrowDown',
                    keyCode: 40,
                    which: 40,
                    bubbles: true,
                    cancelable: true
                });
                
                input.dispatchEvent(arrowDownEvent);
                
                // Then simulate enter to select it
                setTimeout(function() {
                    const enterEvent = new KeyboardEvent('keydown', {
                        key: 'Enter',
                        keyCode: 13,
                        which: 13,
                        bubbles: true,
                        cancelable: true
                    });
                    
                    input.dispatchEvent(enterEvent);
                }, 50);
                
            }, 50);
        }
    });
});
</script>





</body>
</html>
