<!doctype html>
<html <?php language_attributes(); ?>>
<head>

    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">

    <?php wp_head(); ?>

</head>

<body <?php body_class(); ?>>

<?php wp_body_open(); ?>

<div id="page" class="site">

    <?php


	 // Get pages to exclude
	$submission_page_id = get_option('rz_page_submission'); // Submission page
	$explore_page_id    = get_option('rz_page_explore');    // Explore page
	$myaccount_page_id  = get_option('woocommerce_myaccount_page_id'); // My Account page

	$exclude_pages = array_filter([
	    $submission_page_id,
	    $explore_page_id,
	    $myaccount_page_id
	]);


    // Get Elementor header shortcode from theme options
    $custom_header_shortcode = get_option('rz_head_shortcode');

    if ( ! empty($custom_header_shortcode) && ! is_page($exclude_pages) ) {
        // Render Elementor header
        echo do_shortcode( stripslashes($custom_header_shortcode) );
    } else {
        // Render default theme header (current templates/header.php)
        if( ! ( function_exists('routiz') and Rz()->is_submission() ) ):

            // Mobile Header
            get_template_part('templates/mobile/header');

            // Desktop / Default Header
            get_template_part('templates/header');

        endif;
    }
    ?>
