<?php
     $brushup_redux_demo = get_option('redux_demo');
     get_header('blog'); 
?>
<main>

    <!-- breadcrumb-area-start -->
    <div class="breadcrumb-area blue-soft-bg pt-50 pb-50">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="breadcrumb-text">
                        <ul class="breadcrumb-menu">
                            <li><span>
                              <?php the_post(); printf( esc_html__( 'All posts by %s', 'brushup' ), get_the_author() );?>
                              </span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb-area-end -->
    <!-- blog-area-start -->
    <div class="blog-area pt-120 pb-80 ">
        <div class="container">
            <div class="row">
                <div class="col-xl-8 col-lg-8 m-30">
                    <div class="blog-standard mr-10">
                        <?php 
                        while (have_posts()): the_post(); ?>
                        <div class="blog-wrapper mb-40 pos-rel">
                            <div class="blog-img">
                                <a href="<?php the_permalink(); ?>"><img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" alt=""></a>
                                <div class="blog-text">
                                    <div class="blog-meta">
                                        <span> <i class="far fa-calendar-alt"></i><?php the_time(get_option( 'date_format' ));?></span>
                                        <span> <i class="far fa-user-alt"></i><?php the_author_posts_link(); ?></span>
                                    </div>
                                    <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                    <p class="post-desc"><?php if(isset($brushup_redux_demo['blog_excerpt'])){?>
                                        <?php echo esc_attr(brushup_excerpt($brushup_redux_demo['blog_excerpt'])); ?>
                                    <?php }else{?>
                                        <?php echo esc_attr(brushup_excerpt(40)); 
                                    }
                                    ?></p>
                                    <div class="blog-button text-center">
                                        <a href="<?php the_permalink(); ?>"><?php if(isset($brushup_redux_demo['read_more'])){?>
                                        <?php echo htmlspecialchars_decode(esc_attr($brushup_redux_demo['read_more']));?>
                                        <?php }else{?>
                                        <?php echo esc_html__( 'Read more', 'brushup' );
                                        }
                                        ?></a>
                                    </div>
                                </div>
                           </div>
                        </div>
                        <?php endwhile; ?>
                        <div class="basic-pagination basic-pagination-2 mb-40">
                            <?php brushup_pagination();?>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-4 mb-30">
                    <?php get_sidebar();?>
                </div>
            </div>
        </div>
    </div>
    <!-- blog-area-end -->
</main>
<?php
    get_footer();
?>