<?php
$brushup_redux_demo = get_option('redux_demo');

//Custom fields:
require_once get_template_directory() . '/framework/wp_bootstrap_navwalker.php';
require_once get_template_directory() . '/framework/widget/recent-post.php';
require_once get_template_directory() . '/framework/class-ocdi-importer.php';
//Theme Set up:
function brushup_theme_setup() {
    /*
     * This theme uses a custom image size for featured images, displayed on
     * "standard" posts and pages.
     */
	add_theme_support( 'custom-header' ); 
  remove_filter ('the_content', 'wpautop');
	add_theme_support( 'custom-background' );
	$lang = get_template_directory_uri() . '/languages';
  load_theme_textdomain('brushup', $lang);
  add_theme_support( 'post-thumbnails' );
  // Adds RSS feed links to <head> for posts and comments.
  add_theme_support( 'automatic-feed-links' );
  // Switches default core markup for search form, comment form, and comments
  // to output valid HTML5.
  add_theme_support( "title-tag" );
  add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list' ) );
  // This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
    'primary' =>  esc_html__( 'Primary Navigation Menu.', 'brushup' ),
	) );
    // This theme uses its own gallery styles.
}
add_action( 'after_setup_theme', 'brushup_theme_setup' );
if ( ! isset( $content_width ) ) $content_width = 900;

function brushup_fonts_url() {
    $font_url = '';

    if ( 'off' !== _x( 'on', 'Google font: on or off', 'brushup' ) ) {
        $font_url = add_query_arg( 'family', urlencode( 'Poppins:300,300i,400,400i,500,500i,600,600i,700,800,800i,900&subset=latin,latin-ext' ), "//fonts.googleapis.com/css" );
    }
    return $font_url;
}

function brushup_theme_scripts_styles() {
	$brushup_redux_demo = get_option('redux_demo');
	$protocol = is_ssl() ? 'https' : 'http';
    wp_enqueue_style( 'bootstrap', get_template_directory_uri().'/assets/css/bootstrap.min.css');
    wp_enqueue_style( 'owl-carousel', get_template_directory_uri().'/assets/css/owl.carousel.min.css');
    wp_enqueue_style( 'animate', get_template_directory_uri().'/assets/css/animate.min.css');
    wp_enqueue_style( 'magnific-popup', get_template_directory_uri().'/assets/css/magnific-popup.css');
    wp_enqueue_style( 'fontawesome-all', get_template_directory_uri().'/assets/css/fontawesome-all.min.css');
    wp_enqueue_style( 'brushup-themify-icons', get_template_directory_uri().'/assets/css/themify-icons.css');
    wp_enqueue_style( 'metisMenu', get_template_directory_uri().'/assets/css/metisMenu.css');
    wp_enqueue_style( 'slick', get_template_directory_uri().'/assets/css/slick.css');
    wp_enqueue_style( 'brushup-default', get_template_directory_uri().'/assets/css/default.css');
    wp_enqueue_style( 'brushup-main', get_template_directory_uri().'/assets/css/main.css');
    wp_enqueue_style( 'brushup-responsive', get_template_directory_uri().'/assets/css/responsive.css');
    wp_enqueue_style( 'brushup-css', get_stylesheet_uri(), array(), '2020-06-05' );

if(isset($brushup_redux_demo['chosen-color']) && $brushup_redux_demo['chosen-color']==1){
    wp_enqueue_style( 'color', get_template_directory_uri().'/framework/color.php');
    }    
if(isset($brushup_redux_demo['support-rtl']) && $brushup_redux_demo['support-rtl']==1){
    wp_enqueue_style( 'support-rtl', get_template_directory_uri().'/rtl.css');
    }
    
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )
    wp_enqueue_script( 'comment-reply' );
  //Javascript
    wp_enqueue_script("modernizr", get_template_directory_uri()."/assets/js/vendor/modernizr-3.5.0.min.js",array(),false,true);
    wp_enqueue_script("jquery1", get_template_directory_uri()."/assets/js/vendor/jquery-1.12.4.min.js",array(),false,true);
    wp_enqueue_script("popper", get_template_directory_uri()."/assets/js/popper.min.js",array(),false,true);
    wp_enqueue_script("bootstrap", get_template_directory_uri()."/assets/js/bootstrap.min.js",array(),false,true);
    wp_enqueue_script("owl-carousel", get_template_directory_uri()."/assets/js/owl.carousel.min.js",array(),false,true);
    wp_enqueue_script("isotope-pkgd", get_template_directory_uri()."/assets/js/isotope.pkgd.min.js",array(),false,true);
    wp_enqueue_script("slick", get_template_directory_uri()."/assets/js/slick.min.js",array(),false,true);  
    wp_enqueue_script("metisMenu", get_template_directory_uri()."/assets/js/metisMenu.min.js",array(),false,true); 
    wp_enqueue_script("brushup-ajax-form", get_template_directory_uri()."/assets/js/ajax-form.js",array(),false,true);
    wp_enqueue_script("wow", get_template_directory_uri()."/assets/js/wow.min.js",array(),false,true);
    wp_enqueue_script("waypoints", get_template_directory_uri()."/assets/js/waypoints.min.js",array(),false,true);
    wp_enqueue_script("jquery-appear", get_template_directory_uri()."/assets/js/jquery.appear.js",array(),false,true);
    wp_enqueue_script("jquery-knob", get_template_directory_uri()."/assets/js/jquery.knob.js",array(),false,true);
    wp_enqueue_script("jquery-counterup", get_template_directory_uri()."/assets/js/jquery.counterup.min.js",array(),false,true);
    wp_enqueue_script("jquery-scrollUp", get_template_directory_uri()."/assets/js/jquery.scrollUp.min.js",array(),false,true);
    wp_enqueue_script("imagesloaded-pkgd", get_template_directory_uri()."/assets/js/imagesloaded.pkgd.min.js",array(),false,true);  
    wp_enqueue_script("jquery-magnific-popup", get_template_directory_uri()."/assets/js/jquery.magnific-popup.min.js",array(),false,true);
    wp_enqueue_script("brushup-plugins", get_template_directory_uri()."/assets/js/plugins.js",array(),false,true);
    wp_enqueue_script("brushup-main", get_template_directory_uri()."/assets/js/main.js",array(),false,true);
}
add_filter( 'auto_update_plugin', '__return_false' );    
add_action( 'wp_enqueue_scripts', 'brushup_theme_scripts_styles' );
//Custom Excerpt Function
function brushup_do_shortcode($content) {
    global $shortcode_tags;
    if (empty($shortcode_tags) || !is_array($shortcode_tags))
        return $content;
    $pattern = get_shortcode_regex();
    return preg_replace_callback( "/$pattern/s", 'do_shortcode_tag', $content );
}  

add_filter('user_contactmethods', 'my_user_contactmethods');  
               
function my_user_contactmethods($user_contactmethods){  
  
    
  $user_contactmethods['facebook'] = 'Facebook Link';  
  $user_contactmethods['twitter'] = 'Twitter Link';
  $user_contactmethods['behance'] = 'Behance Link';  
  $user_contactmethods['youtube'] = 'Youtube Link';  
  $user_contactmethods['vimeo'] = 'Vimeo Link'; 
  
  return $user_contactmethods;  
} 

function brushup_mobile_menu() { ?>
  <?php
  $kingfact_menu = wp_nav_menu( array(
    'theme_location' => 'primary',
    'menu_class'     => '',
    'container'      => '',
    'menu_id'        => 'mobile-menu-active',
    'echo'           => false
  ) );

  $kingfact_menu = str_replace( "menu-item-has-children", "menu-item-has-children has-children", $kingfact_menu );
  echo wp_kses_post( $kingfact_menu );
  ?>
  <?php
}

// Widget Sidebar
function brushup_widgets_init() {
	register_sidebar( array(
    'name'          => esc_html__( 'Primary Sidebar', 'brushup' ),
    'id'            => 'sidebar-1',        
        'description'   => esc_html__( 'Appears in the sidebar section of the site.', 'brushup' ),        
        'before_widget' => '<div id="%1$s" class="widget mb-40 %2$s" >',        
        'after_widget'  => '</div>',        
        'before_title'  => '<h3 class="widget-title">',        
        'after_title'   => '</h3>'
    ) );
    register_sidebar( array(
    'name'          => esc_html__( 'Header Widget', 'brushup' ),
    'id'            => 'header-area-1',
    'description'   => esc_html__( 'Header Widget that appears on the Footer.', 'brushup' ),
    'before_widget' => ' ',
    'after_widget'  => ' ',
    'before_title'  => ' ',
    'after_title'   => ' ',
  ) );
    register_sidebar( array(
    'name'          => esc_html__( 'Footer One Widget', 'brushup' ),
    'id'            => 'footer-area-1',
    'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'brushup' ),
    'before_widget' => ' ',
    'after_widget'  => ' ',
    'before_title'  => ' ',
    'after_title'   => ' ',
  ) );
    register_sidebar( array(
    'name'          => esc_html__( 'Footer Two Widget', 'brushup' ),
    'id'            => 'footer-area-2',
    'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'brushup' ),
    'before_widget' => ' ',
    'after_widget'  => ' ',
    'before_title'  => ' ',
    'after_title'   => ' ',
  ) );
    register_sidebar( array(
    'name'          => esc_html__( 'Footer Three Widget', 'brushup' ),
    'id'            => 'footer-area-3',
    'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'brushup' ),
    'before_widget' => ' ',
    'after_widget'  => ' ',
    'before_title'  => ' ',
    'after_title'   => ' ',
  ) );
    register_sidebar( array(
    'name'          => esc_html__( 'Footer Four Widget', 'brushup' ),
    'id'            => 'footer-area-4',
    'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'brushup' ),
    'before_widget' => ' ',
    'after_widget'  => ' ',
    'before_title'  => ' ',
    'after_title'   => ' ',
  ) );
    register_sidebar( array(
    'name'          => esc_html__( 'Footer Five Widget', 'brushup' ),
    'id'            => 'footer-area-5',
    'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'brushup' ),
    'before_widget' => ' ',
    'after_widget'  => ' ',
    'before_title'  => ' ',
    'after_title'   => ' ',
  ) );
    register_sidebar( array(
    'name'          => esc_html__( 'Footer Six Widget', 'brushup' ),
    'id'            => 'footer-area-6',
    'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'brushup' ),
    'before_widget' => ' ',
    'after_widget'  => ' ',
    'before_title'  => ' ',
    'after_title'   => ' ',
  ) );
}
add_action( 'widgets_init', 'brushup_widgets_init' );

//function tag widgets
function brushup_tag_cloud_widget($args) {
	$args['number'] = 0; //adding a 0 will display all tags
	$args['largest'] = 18; //largest tag
	$args['smallest'] = 11; //smallest tag
	$args['unit'] = 'px'; //tag font unit
	$args['format'] = 'list'; //ul with a class of wp-tag-cloud
	$args['exclude'] = array(20, 80, 92); //exclude tags by ID
	return $args;
}
add_filter( 'widget_tag_cloud_args', 'brushup_tag_cloud_widget' );
function brushup_excerpt() {
  $brushup_redux_demo = get_option('redux_demo');
  if(isset($brushup_redux_demo['blog_excerpt'])){
    $limit = $brushup_redux_demo['blog_excerpt'];
  }else{
    $limit = 30;
  }
  $excerpt = explode(' ', get_the_excerpt(), $limit);
  if (count($excerpt)>=$limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt).'...';
  } else {
    $excerpt = implode(" ",$excerpt);
  }
  $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
  return $excerpt;
}

function brushup_pagination($pages='') {
    global $wp_query, $wp_rewrite;
    $wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;
    if($pages==''){
        global $wp_query;
         $pages = $wp_query->max_num_pages;
         if(!$pages)
         {
             $pages = 1;
         }
    }
    $pagination = array(
    'base'      => str_replace( 999999999, '%#%', get_pagenum_link( 999999999 ) ),
    'format'    => '',
    'current'     => max( 1, get_query_var('paged') ),
    'total'     => $pages,
    'prev_text' => wp_specialchars_decode(esc_html__( '<i class = "fa fa-angle-left"></i>', 'brushup' ),ENT_QUOTES),
    'next_text' => wp_specialchars_decode(esc_html__( '<i class = "fa fa-angle-right"></i>', 'brushup' ),ENT_QUOTES),
    'type'      => 'list',
    'end_size'    => 3,
    'mid_size'    => 3
);
    $return =  paginate_links( $pagination );
  echo str_replace( "<ul class='page-numbers'>", '<ul class="pagination">', $return );
}

function brushup_search_form( $form ) {
  $form = '
  <form  method="get" action="' . esc_url(home_url('/')) . '"> 
    <input type="text"  placeholder="'.esc_attr__('Search', 'brushup').'" value="' . get_search_query() . '" name="s" >
    <button type="submit"><span class="icon fa fa-search"></span></button>  
  </form>
	';
  return $form;
}
add_filter( 'get_search_form', 'brushup_search_form' );
//Custom comment List:
 
// Comment Form
function brushup_theme_comment($comment, $args, $depth) {
    //echo 's';
   $GLOBALS['comment'] = $comment; ?>
    <?php if(get_avatar($comment,$size='100' )!=''){?>
    <li>
        <div class="comments-box">
            <div class="comments-avatar">
                <?php echo get_avatar($comment,$size='100' ); ?>
            </div>
            <div class="comments-text">
                <div class="avatar-name">
                    <h5><?php printf( get_comment_author_link()) ?></h5>
                    <span><?php the_time(get_option( 'date_format' ));?></span>
                    <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
                </div>
                <?php comment_text() ?>
            </div>
        </div>
    </li>
    <?php }else{?>
    <li>
        <div class="comments-box">
            <div class="comments-text">
                <div class="avatar-name">
                    <h5><?php printf( get_comment_author_link()) ?></h5>
                    <span><?php the_time(get_option( 'date_format' ));?></span>
                    <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
                </div>
                <?php comment_text() ?>
            </div>
        </div>
    </li>
    <?php }?>

<?php
}

/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1
 * @author     Thomas Griffin <thomasgriffinmedia.com>
 * @author     Gary Jones <gamajo.com>
 * @copyright  Copyright (c) 2014, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/thomasgriffin/TGM-Plugin-Activation
 */
/**
 * Include the TGM_Plugin_Activation class.
 */
require_once get_template_directory() . '/framework/class-tgm-plugin-activation.php';
add_action( 'tgmpa_register', 'brushup_theme_register_required_plugins' );
/**
 * Register the required plugins for this theme.
 *
 * In this example, we register two plugins - one included with the TGMPA library
 * and one from the .org repo.
 *
 * The variable passed to tgmpa_register_plugins() should be an array of plugin
 * arrays.
 *
 * This function is hooked into tgmpa_init, which is fired within the
 * TGM_Plugin_Activation class constructor.
 */
 
 
function brushup_theme_register_required_plugins() {
    /**
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = array(
        // This is an example of how to include a plugin from the WordPress Plugin Repository.
      array(
            'name'      => esc_html__( 'One Click Demo Import', 'brushup' ),
            'slug'      => 'one-click-demo-import',
            'required'  => true,
        ), 
      array(
            'name'      => esc_html__( 'Classic Editor', 'brushup' ),
            'slug'      => 'classic-editor',
            'required'  => true,
        ), 
      array(
            'name'      => esc_html__( 'Classic Widgets', 'brushup' ),
            'slug'      => 'classic-widgets',
            'required'  => true,
        ),
      array(
            'name'      => esc_html__( 'Widget Importer & Exporter', 'brushup' ),
            'slug'      => 'widget-importer-&-exporter',
            'required'  => true,
        ), 
      array(
            'name'      => esc_html__( 'Contact Form 7', 'brushup' ),
            'slug'      => 'contact-form-7',
            'required'  => true,
        ), 
      array(
            'name'      => esc_html__( 'SVG Support', 'brushup' ),
            'slug'      => 'svg-support',
            'required'  => true,
        ), 
      array(
            'name'      => esc_html__( 'WP Maximum Execution Time Exceeded', 'brushup' ),
            'slug'      => 'wp-maximum-execution-time-exceeded',
            'required'  => true,
        ), 
      array(
            'name'                     => esc_html__( 'Elementor', 'brushup' ),
            'slug'                     => 'elementor',
            'required'                 => true,
        ),
      array(
            'name'                     => esc_html__( 'Brushup Common', 'brushup' ),
            'slug'                     => 'brushup-common',
            'required'                 => true,
            'source'                   => get_template_directory() . '/framework/plugins/brushup-common.zip',
        ),
      array(
            'name'                     => esc_html__( 'Brushup Elementor', 'brushup' ),
            'slug'                     => 'brushup-elementor',
            'required'                 => true,
            'source'                   => get_template_directory() . '/framework/plugins/brushup-elementor.zip',
        ),
    );
    /**
     * Array of configuration settings. Amend each line as needed.
     * If you want the default strings to be available under your own theme domain,
     * leave the strings uncommented.
     * Some of the strings are added into a sprintf, so see the comments at the
     * end of each line for what each argument will be.
     */
    $config = array(
        'default_path' => '',                      // Default absolute path to pre-packaged plugins.
        'menu'         => 'tgmpa-install-plugins', // Menu slug.
        'has_notices'  => true,                    // Show admin notices or not.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.
        'strings'      => array(
            'page_title'                      => esc_html__( 'Install Required Plugins', 'brushup' ),
            'menu_title'                      => esc_html__( 'Install Plugins', 'brushup' ),
            'installing'                      => esc_html__( 'Installing Plugin: %s', 'brushup' ), // %s = plugin name.
            'oops'                            => esc_html__( 'Something went wrong with the plugin API.', 'brushup' ),
            'notice_can_install_required'     => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'brushup' ), // %1$s = plugin name(s).
            'notice_can_install_recommended'  => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'brushup' ), // %1$s = plugin name(s).
            'notice_cannot_install'           => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'brushup' ), // %1$s = plugin name(s).
            'notice_can_activate_required'    => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'brushup' ), // %1$s = plugin name(s).
            'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'brushup' ), // %1$s = plugin name(s).
            'notice_cannot_activate'          => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'brushup' ), // %1$s = plugin name(s).
            'notice_ask_to_update'            => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'brushup' ), // %1$s = plugin name(s).
            'notice_cannot_update'            => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'brushup' ), // %1$s = plugin name(s).
            'install_link'                    => _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'brushup' ),
            'activate_link'                   => _n_noop( 'Begin activating plugin', 'Begin activating plugins', 'brushup' ),
            'return'                          => esc_html__( 'Return to Required Plugins Installer', 'brushup' ),
            'plugin_activated'                => esc_html__( 'Plugin activated successfully.', 'brushup' ),
            'complete'                        => esc_html__( 'All plugins installed and activated successfully. %s', 'brushup' ), // %s = dashboard link.
            'nag_type'                        => 'updated' // Determines admin notice type - can only be 'updated', 'update-nag' or 'error'.
        )
    );
    tgmpa( $plugins, $config );
}
?>