<!doctype html>

<html class="no-js" lang="zxx">

<?php $brushup_redux_demo = get_option('redux_demo'); ?>

    <head>

    <meta charset="utf-8">

    <meta http-equiv="x-ua-compatible" content="ie=edge">

    <meta name="description" content="">

    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) { ?>

    <?php if(isset($brushup_redux_demo['favicon']['url'])){?>

    <link rel="shortcut icon" href="<?php echo esc_url($brushup_redux_demo['favicon']['url']); ?>">

    <?php }?>

    <?php }?>

    <?php wp_head(); ?>

    </head>

    <body id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

    <!-- header-start -->

        <header>

            <div class="main-menu-area topbar-area pt-15 pb-15">

                <div class="container">

                    <div class="row align-items-center">

                        <div class="col-xl-3 col-lg-3 col-md-4 col-8">

                            <div class="logo logo-bg">

                                <a  href="<?php echo esc_url(home_url('/')); ?>">

                                <?php if(isset($brushup_redux_demo['logo']['url']) && $brushup_redux_demo['logo']['url'] != ''){ ?>

                                <img src="<?php echo esc_url($brushup_redux_demo['logo']['url']); ?>" alt="">

                                <?php }else{ ?>

                                  <img src="<?php echo get_template_directory_uri();?>/assets/img/logo/logo.png" alt="">

                                <?php } ?></a>

                            </div>

                        </div>

                        <div class="col-xl-9 col-lg-9 d-none d-lg-block">

                            <div class="header-top fix">

                                <div class="header-top-wrapper">

                                    <div class="header-top-icon f-left">

                                        <i class="far fa-alarm-clock"></i>

                                    </div>

                                    <div class="header-top-text">

                                        <span>Working Hours</span>

                                        <h5>Mon - Sat 9.00 to 17.00</h5>

                                    </div>

                                </div>

                                <div class="header-top-wrapper ">

                                    <div class="header-top-icon f-left">

                                        <i class="fal fa-map-marker-alt"></i>

                                    </div>

                                    <div class="header-top-text">

                                        <span>Our Address</span>

                                        <h5>4249 Hart Street, Enfield</h5>

                                    </div>

                                </div>

                                <div class="header-top-wrapper headers-wrapper">

                                    <div class="header-top-icon f-left">

                                        <i class="far fa-phone"></i>

                                    </div>

                                    <div class="header-top-text">

                                        <span>Call Us</span>

                                        <h5>860 -272 -9738</h5>

                                    </div>

                                </div>

                            </div>

                        </div>

                        <div class="col-md-8 col-4 d-block d-xl-none d-lg-none text-right">

                            <div class="open-mobile-menu">
                                <a href="javascript:void(0);">
                                    <i class="far fa-bars"></i>
                                </a>
                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <div id="sticky-header" class="menu-area d-none d-lg-block">

                <div class="container">

                    <div class="row">

                        <div class="col-xl-12">

                            <div class="menu-box mt-0">

                                <div class="menu-bar  info-bar f-right d-none d-md-none d-lg-block">

                                    <a href="#"><i class="fal fa-bars"></i></a>

                                </div>

                                <div class="main-menu">

                                    <nav id="mobile-menu">

                                        <?php 

                                          wp_nav_menu( 

                                          array( 

                                                'theme_location' => 'primary',

                                                'container' => '',

                                                'menu_class' => '', 

                                                'menu_id' => '',

                                                'menu'            => '',

                                                'container_class' => '',

                                                'container_id'    => '',

                                                'echo'            => true,

                                                'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',

                                                'walker'            => new Brushup_Wp_Bootstrap_Navwalker(),

                                                'before'          => '',

                                                'after'           => '',

                                                'link_before'     => '',

                                                'link_after'      => '',

                                                'items_wrap'      => '<ul  class=" %2$s">%3$s</ul>',

                                                'depth'           => 0,        

                                            )

                                        ); ?>

                                    </nav>

                                </div>

                            </div>

                        </div>                        

                    </div>

                </div>

            </div>

            <div class="extra-info">

                <div class="close-icon">

                    <button>

                        <i class="far fa-window-close"></i>

                    </button>

                </div>

                <div class="logo-side mb-30">

                    <a href="<?php echo esc_url(home_url('/')); ?>">

                        <img src="<?php echo get_template_directory_uri();?>/assets/img/logo/white-logo.png" alt="" />

                    </a>

                </div>

                <div class="side-info mb-30">

                    <div class="contact-list mb-30">

                        <h4>Office Address</h4>

                        <p>123/A, Miranda City Likaoli

                            Prikano, Dope</p>

                    </div>

                    <div class="contact-list mb-30">

                        <h4>Phone Number</h4>

                        <p>+0989 7876 9865 9</p>

                        <p>+(090) 8765 86543 85</p>

                    </div>

                    <div class="contact-list mb-30">

                        <h4>Email Address</h4>

                        <p>info@example.com</p>

                        <p>example.mail@hum.com</p>

                    </div>

                </div>

                <div class="instagram">

                    <a href="#">

                        <img src="<?php echo get_template_directory_uri();?>/assets/img/portfolio/p1.jpg" alt="">

                    </a>

                    <a href="#">

                        <img src="<?php echo get_template_directory_uri();?>/assets/img/portfolio/p2.jpg" alt="">

                    </a>

                    <a href="#">

                        <img src="<?php echo get_template_directory_uri();?>/assets/img/portfolio/p3.jpg" alt="">

                    </a>

                    <a href="#">

                        <img src="<?php echo get_template_directory_uri();?>/assets/img/portfolio/p4.jpg" alt="">

                    </a>

                    <a href="#">

                        <img src="<?php echo get_template_directory_uri();?>/assets/img/portfolio/p5.jpg" alt="">

                    </a>

                    <a href="#">

                        <img src="<?php echo get_template_directory_uri();?>/assets/img/portfolio/p6.jpg" alt="">

                    </a>

                </div>

                <div class="social-icon-right mt-20">

                    <a href="#">

                        <i class="fab fa-facebook-f"></i>

                    </a>

                    <a href="#">

                        <i class="fab fa-twitter"></i>

                    </a>

                    <a href="#">

                        <i class="fab fa-google-plus-g"></i>

                    </a>

                    <a href="#">

                        <i class="fab fa-instagram"></i>

                    </a>

                </div>

            </div>

        </header>

        <!-- header-start -->

        <!--    Slide Bar Start   -->
        <aside class="slide-bar">
            <div class="close-mobile-menu">
                <a href="javascript:void(0);"><i class="fas fa-times"></i></a>
            </div>
            <nav class="side-mobile-menu">
                <?php brushup_mobile_menu(); ?>
            </nav>
        </aside>
        <div class="body-overlay"></div>
        <!--    Slide Bar End    -->