<?php

/*

 * Template Name: Blog Grid

 * Description: A Page Template with a Page Builder design.

 */

     $brushup_redux_demo = get_option('redux_demo');

     get_header('blog'); 

?>

<main>



    <!-- breadcrumb-area-start -->

    <div class="breadcrumb-area blue-soft-bg pt-50 pb-50">

        <div class="container">

            <div class="row">

                <div class="col-xl-12">

                    <div class="breadcrumb-text">

                        <ul class="breadcrumb-menu">

                            <li><a href="<?php echo esc_url(home_url('/')); ?>">

                                <?php if(isset($brushup_redux_demo['home_text'])){?>

                                <?php echo wp_specialchars_decode(esc_attr($brushup_redux_demo['home_text']));?>

                                <?php }else{?>

                                <?php echo esc_html__( 'Home', 'brushup' );

                                }

                                ?> 

                                </a>

                            </li>

                            <li><span>

                              <?php if(isset($brushup_redux_demo['blog_grid_title'])){?>

                              <?php echo wp_specialchars_decode(esc_attr($brushup_redux_demo['blog_grid_title']));?>

                              <?php }else{?>

                              <?php echo esc_html__( 'Blog Grid', 'brushup' );

                              }

                              ?>

                              </span>

                            </li>

                        </ul>

                    </div>

                </div>

            </div>

        </div>

    </div>

    <!-- breadcrumb-area-end -->

    <!-- blog-area-start -->

    <div class="blog-area pt-120 pb-60 ">

        <div class="container">

            <div class="row">

                <?php  $args = array(    

                        'paged' => $paged,

                        'post_type' => 'post',

                        'posts_per_page' => $brushup_redux_demo['grid_number'],

                );

                $wp_query = new WP_Query($args);

                while (have_posts()): the_post(); ?>

                <?php $featured_image_3 = get_post_meta(get_the_ID(),'_cmb_featured_image_3', true); ?>

                <div class="col-xl-6 col-lg-6 col-md-6 mb-85">

                    <div class="blog-wrapper pos-rel">

                        <div class="blog-img">

                            <a href="<?php the_permalink(); ?>"><img src="<?php echo wp_get_attachment_url($featured_image_3);?>" alt=""></a>

                            <div class="blog-text">

                                <div class="blog-meta">

                                    <span> <i class="far fa-calendar-alt"></i><?php the_time(get_option( 'date_format' ));?></span>

                                    <span> <i class="far fa-user-alt"></i><?php the_author_posts_link(); ?></span>

                                </div>

                                <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>

                                <p class="post-desc"><?php if(isset($brushup_redux_demo['blog_excerpt'])){?>
                                    <?php echo esc_attr(brushup_excerpt($brushup_redux_demo['blog_excerpt'])); ?>
                                <?php }else{?>
                                    <?php echo esc_attr(brushup_excerpt(40)); 
                                }
                                ?></p>
                                <div class="blog-button text-center">
                                    <a href="<?php the_permalink(); ?>"><?php if(isset($brushup_redux_demo['read_more'])){?>
                                        <?php echo htmlspecialchars_decode(esc_attr($brushup_redux_demo['read_more']));?>
                                    <?php }else{?>
                                        <?php echo esc_html__( 'Read more', 'brushup' );
                                    }
                                    ?></a>
                                </div>

                            </div>

                       </div>

                    </div>

                </div>

                <?php endwhile; ?>

            </div>

        </div>

    </div>

    <!-- blog-area-end -->

</main>    

<?php

    get_footer();

?>