<?php
/**
 * The Template for displaying all single posts
 */
 $brushup_redux_demo = get_option('redux_demo');
get_header('blog'); ?>
<?php 
    while (have_posts()): the_post();
?>
<main>

    <!-- breadcrumb-area-start -->
    <div class="breadcrumb-area blue-soft-bg pt-50 pb-50">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="breadcrumb-text">
                        <ul class="breadcrumb-menu">
                            <li><a href="<?php echo esc_url(home_url('/')); ?>">
                                <?php if(isset($brushup_redux_demo['home_text'])){?>
                                <?php echo wp_specialchars_decode(esc_attr($brushup_redux_demo['home_text']));?>
                                <?php }else{?>
                                <?php echo esc_html__( 'Home', 'brushup' );
                                }
                                ?> 
                                </a>
                            </li>
                            <li><span>
                              <?php the_title(); ?>
                              </span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb-area-end -->
    <!-- blog-area start -->
    <div class="blog-area pt-120 pb-80 ">
        <div class="container">
            <div class="row">
              <div class="col-12" id="post-<?php the_ID(); ?>" <?php post_class(); ?> >
                <div class="blog-wrapper blog-details">
                  <div class="blog-thumb">
                    <a href="<?php the_permalink();?>">
                      <?php if ( has_post_thumbnail() ) { ?>
                      <img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>"  />
                      <?php } ?>
                    </a>
                  </div>
                  <div class="blog-content">
                      <?php the_content(); ?>
                      <?php wp_link_pages( array(
                      'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'brushup' ),
                      'after'       => '</div>',
                      'link_before' => '<span class="page-number">',
                      'link_after'  => '</span>',
                      ) ); ?>
                  </div>
                  <div class="next-prev-post clearfix">
                    <?php previous_post_link('%link',wp_specialchars_decode(esc_html__( '<i class="ion-arrow-left-c"></i> Previous Post','brushup'),ENT_QUOTES), true); ?>
                    <div class='right'><?php next_post_link('%link',wp_specialchars_decode(esc_html__('Next Post <i class="ion-arrow-right-c"></i>','brushup'),ENT_QUOTES), true); ?></div>
                  </div>
                 <?php           
                    if ( comments_open() || get_comments_number() ) {
                      comments_template();
                    }
                    ?>
                </div>        
              </div>
        </div>
      </div>
    </div>
</main>
<?php endwhile; ?>
<?php get_footer();?>