<?php

/*
Plugin Name: Calafate Portfolio
Description: A simple portfolio post type manager
Version: 0.2
Author: Ruben Bristian
Author URI: http://rubenbristian.com
License: GPL
License URI: http://www.gnu.org/copyleft/gpl.html
*/

class CalafatePortfolio {

    function __construct() {  

        $current_theme = wp_get_theme();
        
        require_once( plugin_dir_path( __FILE__ ) . 'includes/portfolio.php' );
        
        add_action( 'init', array( &$this, 'init' ) );

        add_action( 'wp_enqueue_scripts', array( &$this, 'route_scripts' ) );

        add_action( 'wp_enqueue_scripts', array( &$this, 'route_scripts_woo' ), 100 );

    }
    
    function init() {
        
    }

    function route_scripts() {

			wp_deregister_script( 'comment-reply' );
			wp_register_script( 'comment-reply', includes_url() . '/js/comment-reply.min.js' );
    }

    function route_scripts_woo() {

        wp_deregister_script( 'select2' );

        if ( function_exists( 'is_cart' ) && ( is_cart() || is_checkout() || is_account_page() ) ) {
            wp_enqueue_script( 'select2', get_template_directory_uri() . '/js/vendor/select2/select2.min.js', array(), false, false );
        }

    }
    
}

new CalafatePortfolio();

?>