<?php

if ( ! function_exists( 'calafate_twitter_slider_function' ) ) :

	function calafate_twitter_slider_function( $atts, $content, $shortcode ) {

		$atts = shortcode_atts( array(
			'username'	=> '',
			'no'     		=> '3'
		), $atts, $shortcode );

		$output = '';

		if ( function_exists( 'getTweets' ) ) {

			$tweets = getTweets( $atts['username'], $atts['no'] );

			if ( $atts['username'] == '' ) {

				$output .= '<p>' . esc_html__( 'Error (make sure that you set the username parameter for this shortcode)', 'calafate' ) . '</p>';

			} else if ( ! empty ( $tweets['error'] ) ) {

				$output .= '<p>' . esc_html__( 'Error (go to Settings > Twitter Feed Auth to resolve this)', 'calafate' ) . '<span style="color:red; ">' . $tweets['error'] . '</span></p>';

		    } else {

					$output .= '<div class="calafate-twitter">';

						$output .= '<div class="carousel-holder">';

							$output .= '<div class="carousel">';

			    			foreach ( $tweets as $tweet ) {

					    		$output .= '<div class="carousel-cell">
					    			<p class="body">' . calafate_parse_tweet( $tweet['text'] ) . '</p>
									</div>';

			    			}

		    			$output .= '</div>';

		    			$output .= '<div class="carousel-prev">' . calafate_svg( 'arrow-left' ) . '</div>';
		    			$output .= '<div class="carousel-next">' . calafate_svg( 'arrow-right' ) . '</div>';

		    		$output .= '</div>';

	    			$output .= '<div class="background">' . calafate_svg( 'twitter' ) . '</div>';

						$output .= '<a target="_blank" class="user button" href="' . esc_url( 'https://twitter.com/' . $atts['username'] ) . '">@' . $atts['username'] . '</a>';

	    		$output .= '</div>';

		    }

		} else {

			// translators: %s: oAuth Twitter Feed plugin url
			$output .= '<p>' . sprintf( wp_kses( __( 'Please install the <a href="%s">oAuth Twitter Feed Plugin</a> and configure it properly for the twitter widget to run. Read more about this in the theme documentation.', 'calafate' ), array( 'a' => array( 'href' => array() ) ) ), 'http://wordpress.org/plugins/oauth-twitter-feed-for-developers/' ) . '</p>'; // WPCS: XSS OK.

		}

		return $output;

	}

endif;

function calafate_parse_tweet( $string ) {

  $content_array = explode( " ", $string );
  $output = '';

  foreach ( $content_array as $content ) {

      if ( substr( $content, 0, 7 ) == "http://" ) {
          $content = '<a target="_blank" href="' . esc_url( $content ) . '">' . $content . '</a>';
      }

      //starts with www.
      if ( substr( $content, 0, 4 ) == "www." ) {
          $content = '<a target="_blank" href="' . esc_url( 'http://' . $content ) . '">' . $content . '</a>';
      }

      if ( substr( $content, 0, 8 ) == "https://" ) {
          $content = '<a target="_blank" href="' . esc_url( $content ) . '">' . $content . '</a>';
      }

      if ( substr( $content, 0, 1 ) == "#" ) {
          $content = '<a target="_blank" href="' . esc_url( 'https://twitter.com/search?src=hash&q=' . $content ) . '">' . $content . '</a>';
      }

      if ( substr( $content, 0, 1 ) == "@" ) {
          $content = '<a target="_blank" href="' . esc_url( 'https://twitter.com/' . $content ) . '">' . $content . '</a>';
      }

      $output .= " " . $content;

  }

  $output = trim( $output );

  return $output;

}

add_shortcode( 'calafate_twitter_slider', 'calafate_twitter_slider_function' );
