<?php
/**
 * SVG icons
 *
 * @package Calafate
*/

if ( ! function_exists( 'calafate_svg' ) ) :

	function calafate_svg( $type, $classname = '' ) {

		$output = '<span' . ( $classname != '' ? ' class="' . $classname . '"' : '' )  . '>';

		switch ( $type ) {

			case 'arrow-left':
				$output .= '<svg xmlns="http://www.w3.org/2000/svg" width="34" height="19" viewBox="0 12 34 19" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" transform="translate(16.000000, 21.000000) rotate(-180.000000) translate(-16.000000, -21.000000) translate(0.000000, 13.000000)"><path d="M1.18 8.14L23.01 8.14" stroke="#000000" stroke-width="2" stroke-linecap="square"/><path d="M23.66 0L31.66 8 23.66 16 23.66 0Z" fill="#000000"/></g></svg>';
				break;

			case 'arrow-right':
				$output .= '<svg xmlns="http://www.w3.org/2000/svg" width="34" height="19" viewBox="-2 12 34 19" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" transform="translate(16.000000, 21.000000) scale(-1, 1) rotate(-180.000000) translate(-16.000000, -21.000000) translate(0.000000, 13.000000)"><path d="M1.18 8.14L23.01 8.14" stroke="#000000" stroke-width="2" stroke-linecap="square"/><path d="M23.66 0L31.66 8 23.66 16 23.66 0Z" fill="#000000"/></g></svg>';
				break;

			case 'arrow-hero':
				$output .= '<svg xmlns="http://www.w3.org/2000/svg" width="86" height="38" viewBox="0 0 86 38" version="1.1"><defs><polygon points="0 0 0 86 38 86 38 0 0 0"/></defs><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><g transform="translate(43.000000, 19.000000) rotate(-90.000000) translate(-43.000000, -19.000000) translate(24.000000, -24.000000)"><mask fill="white"/><path d="M18.2 85.7C18.3 85.7 18.4 85.9 18.6 85.9 18.7 86 18.9 86 19 86 19.1 86 19.3 86 19.4 85.9 19.6 85.9 19.7 85.8 19.8 85.7L37.7 67.8C38.1 67.4 38.1 66.7 37.7 66.3 37.2 65.8 36.5 65.8 36.1 66.3L20.1 82.2 20 1.1C20.4 1.1 19.5 0 18.9 0 18.2 0 17.7 0.5 17.7 1.1L17.9 82.2 1.9 66.3C1.5 65.8 0.8 65.8 0.3 66.3 -0.1 66.7-0.1 67.4 0.3 67.8L18.2 85.7Z" fill="#000000" mask="url(#mask-2)"/></g></g></svg>';
				break;

			case 'filter':
				$output .= '<svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15" version="1.1"><rect stroke="none" fill="#000000" fill-rule="evenodd" x="0" y="0" width="5" height="5"/><rect stroke="none" fill="#000000" fill-rule="evenodd" x="10" y="0" width="5" height="5"/><rect stroke="none" fill="#000000" fill-rule="evenodd" x="10" y="10" width="5" height="5"/><rect stroke="none" fill="#000000" fill-rule="evenodd" x="0" y="10" width="5" height="5"/></svg>';
				break;

			case 'search':
				$output .= '<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 -1 12 12" version="1.1"><path d="M8.12 6.68C8.52 6.02 8.75 5.26 8.75 4.44 8.75 2.06 6.69 0 4.31 0 1.93 0 0 1.93 0 4.31 0 6.69 2.06 8.75 4.44 8.75 5.23 8.75 5.97 8.53 6.61 8.16L9.25 10.81C9.51 11.06 9.93 11.06 10.19 10.81L10.85 10.15C11.11 9.89 11.01 9.56 10.75 9.31L8.12 6.68ZM1.33 4.31C1.33 2.66 2.66 1.33 4.31 1.33 5.95 1.33 7.42 2.79 7.42 4.44 7.42 6.09 6.09 7.42 4.44 7.42 2.79 7.42 1.33 5.95 1.33 4.31L1.33 4.31Z" stroke="none" fill="#000000" fill-rule="evenodd"/></svg>';
				break;

			case 'plus':
				$output .= '<svg xmlns="http://www.w3.org/2000/svg" width="23" height="23" viewBox="-1 -1 23 23" version="1.1"><path d="M0.5 10L20.5 10" stroke="#000000" stroke-width="2" stroke-linecap="square" fill="none"/><path d="M0.5 10L20.5 10" stroke="#000000" stroke-width="2" stroke-linecap="square" fill="none" transform="translate(10.500000, 10.000000) rotate(-270.000000) translate(-10.500000, -10.000000) "/></svg>';
				break;

			case 'arrow':
				$output .= '<svg xmlns="http://www.w3.org/2000/svg" width="18" height="15" viewBox="5 8 18 15" version="1.1"><path d="M21.8 16C21.9 16 21.9 15.9 21.9 15.9 21.9 15.9 21.9 15.8 21.9 15.8 21.9 15.8 21.9 15.8 22 15.8 22 15.8 22 15.7 22 15.7 22 15.7 22 15.7 22 15.6 22 15.6 22 15.6 22 15.6 22 15.5 22 15.5 22 15.5 22 15.4 22 15.4 22 15.4 22 15.4 22 15.3 22 15.3 22 15.3 22 15.2 22 15.2 22 15.2 22 15.1 22 15.1 22 15.1 22 15.1 22 15 22 15 22 15 22 14.9 22 14.9 22 14.9 22 14.9 22 14.8 22 14.8 22 14.8 21.9 14.8 21.9 14.8 21.9 14.8 21.9 14.7 21.9 14.7 21.9 14.7 21.9 14.7 21.9 14.6 21.8 14.6 21.8 14.6 21.8 14.6 21.8 14.5 21.8 14.5 21.7 14.5 21.7 14.5 21.7 14.4 21.7 14.4 21.7 14.4L16 8.6C15.5 8.2 14.7 8.2 14.2 8.6 13.8 9.1 13.8 9.9 14.2 10.4L17.9 14.1 6.5 14.1C6.1 14.1 5.7 14.3 5.5 14.6 5.4 14.8 5.3 15 5.3 15.3 5.3 15.6 5.4 15.9 5.7 16.2 5.9 16.4 6.2 16.5 6.5 16.5L17.9 16.5 14.2 20.2C13.8 20.7 13.8 21.5 14.2 21.9 14.5 22.2 14.8 22.3 15.1 22.3 15.4 22.3 15.7 22.2 16 21.9L21.7 16.2C21.7 16.2 21.7 16.1 21.7 16.1 21.7 16.1 21.8 16.1 21.8 16.1 21.8 16 21.8 16 21.8 16" stroke="none" fill="#D0D0D0" fill-rule="evenodd"/></svg>';
				break;

			case 'arrow-small':
				$output .= '<svg xmlns="http://www.w3.org/2000/svg" width="45" height="24" viewBox="56 175 45 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" transform="translate(56.468750, 175.300000)"><path d="M41.2 12L31.9 21.4C31.7 21.6 31.7 22.1 31.9 22.3 32.2 22.6 32.6 22.6 32.9 22.3L43.3 11.8C43.4 11.7 43.4 11.7 43.4 11.7 43.4 11.6 43.4 11.6 43.4 11.6 43.5 11.6 43.5 11.5 43.5 11.5 43.5 11.5 43.5 11.4 43.5 11.4 43.5 11.4 43.5 11.3 43.5 11.3 43.5 11.3 43.5 11.2 43.5 11.2 43.5 11.2 43.5 11.1 43.5 11.1 43.5 11.1 43.5 11 43.5 11 43.5 11 43.5 11 43.4 10.9 43.4 10.9 43.4 10.9 43.4 10.9 43.3 10.8 43.3 10.8 43.3 10.8L32.9 0.2C32.8 0.1 32.6 0 32.4 0 32.2 0 32.1 0.1 31.9 0.2 31.7 0.5 31.7 0.9 31.9 1.2L41.2 10.6 0.7 10.6C0.3 10.6 0 10.9 0 11.3 0 11.7 0.3 12 0.7 12L41.2 12Z" fill="#FFFFFF"/></g></svg>';
				break;

			case 'twitter':
				$output .= '<svg xmlns="http://www.w3.org/2000/svg" width="2000" height="1625.36" viewbox="0 0 2000 1625.36"><path d="m 1999.9999,192.4 c -73.58,32.64 -152.67,54.69 -235.66,64.61 84.7,-50.78 149.77,-131.19 180.41,-227.01 -79.29,47.03 -167.1,81.17 -260.57,99.57 C 1609.3399,49.82 1502.6999,0 1384.6799,0 c -226.6,0 -410.328,183.71 -410.328,410.31 0,32.16 3.628,63.48 10.625,93.51 -341.016,-17.11 -643.368,-180.47 -845.739,-428.72 -35.324,60.6 -55.5583,131.09 -55.5583,206.29 0,142.36 72.4373,267.95 182.5433,341.53 -67.262,-2.13 -130.535,-20.59 -185.8519,-51.32 -0.039,1.71 -0.039,3.42 -0.039,5.16 0,198.803 141.441,364.635 329.145,402.342 -34.426,9.375 -70.676,14.395 -108.098,14.395 -26.441,0 -52.145,-2.578 -77.203,-7.364 52.215,163.008 203.75,281.649 383.304,284.946 -140.429,110.062 -317.351,175.66 -509.5972,175.66 -33.1211,0 -65.7851,-1.949 -97.8828,-5.738 181.586,116.4176 397.27,184.359 628.988,184.359 754.732,0 1167.462,-625.238 1167.462,-1167.47 0,-17.79 -0.41,-35.48 -1.2,-53.08 80.1799,-57.86 149.7399,-130.12 204.7499,-212.41"/></svg>';
				break;

			case 'action-back':
				$output .= '<svg width="20px" height="17px" viewBox="47 -1 20 17" version="1.1" xmlns="http://www.w3.org/2000/svg"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" transform="translate(47.000000, -0.000000)"><path d="M14.96,8.00183051 C14.96,7.66491525 14.7151523,7.39166102 14.4132615,7.39166102 L0.796738526,7.39166102 C0.494756613,7.39166102 0.25,7.66491525 0.25,8.00183051 C0.25,8.33874576 0.494756613,8.612 0.796738526,8.612 L14.4132615,8.612 C14.7151523,8.612 14.96,8.33874576 14.96,8.00183051 L14.96,8.00183051 Z" fill="#778BA2"></path><path d="M11.8494237,14.3838983 C11.6110508,14.6221695 11.6110508,15.0085085 11.8494237,15.2467797 C11.9685085,15.3658644 12.1247119,15.4254576 12.2808136,15.4254576 C12.4369153,15.4254576 12.5931186,15.3658644 12.7122034,15.2467797 L19.5257627,8.43322034 C19.7641356,8.19494915 19.7641356,7.80861017 19.5257627,7.57033898 L12.7122034,0.756779661 C12.4740339,0.518508475 12.0874915,0.518508475 11.8494237,0.756779661 C11.6110508,0.995050847 11.6110508,1.38138983 11.8494237,1.61966102 L18.2314915,8.00172881 L11.8494237,14.3838983 L11.8494237,14.3838983 Z" fill="#778BA2"></path></g></svg>';
				break;

			case 'action-search':
				$output .= '<svg width="13px" height="13px" viewBox="0 0 13 13" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M12.8023435,11.8409402 L9.59762114,8.62300319 C10.4216116,7.67731629 10.8730808,6.48744865 10.8730808,5.24874487 C10.8730808,2.35463259 8.4342015,0 5.4365404,0 C2.4388793,0 0,2.35463259 0,5.24874487 C0,8.14285714 2.4388793,10.4974897 5.4365404,10.4974897 C6.56190426,10.4974897 7.63432095,10.1697855 8.5512053,9.54769512 L11.7802739,12.7900502 C11.915242,12.9253765 12.0967751,13 12.2913087,13 C12.475442,13 12.6501204,12.9322227 12.7827247,12.8089913 C13.0644793,12.5472387 13.0734614,12.1131903 12.8023435,11.8409402 L12.8023435,11.8409402 Z M5.4365404,1.36923779 C7.65228517,1.36923779 9.45485286,3.10953902 9.45485286,5.24874487 C9.45485286,7.38795071 7.65228517,9.12825194 5.4365404,9.12825194 C3.22079563,9.12825194 1.41822793,7.38795071 1.41822793,5.24874487 C1.41822793,3.10953902 3.22079563,1.36923779 5.4365404,1.36923779 L5.4365404,1.36923779 Z" stroke="none" fill="#778BA2" fill-rule="evenodd"></path></svg>';
				break;

			case 'action-up':
				$output .= '<svg width="17px" height="20px" viewBox="-1 0 17 20" version="1.1" xmlns="http://www.w3.org/2000/svg"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" transform="translate(8.000000, 10.000000) rotate(-90.000000) translate(-8.000000, -10.000000) translate(-2.000000, 2.000000)"><path d="M14.96,8.00183051 C14.96,7.66491525 14.7151523,7.39166102 14.4132615,7.39166102 L0.796738526,7.39166102 C0.494756613,7.39166102 0.25,7.66491525 0.25,8.00183051 C0.25,8.33874576 0.494756613,8.612 0.796738526,8.612 L14.4132615,8.612 C14.7151523,8.612 14.96,8.33874576 14.96,8.00183051 L14.96,8.00183051 Z" fill="#778BA2"></path><path d="M11.8494237,14.3838983 C11.6110508,14.6221695 11.6110508,15.0085085 11.8494237,15.2467797 C11.9685085,15.3658644 12.1247119,15.4254576 12.2808136,15.4254576 C12.4369153,15.4254576 12.5931186,15.3658644 12.7122034,15.2467797 L19.5257627,8.43322034 C19.7641356,8.19494915 19.7641356,7.80861017 19.5257627,7.57033898 L12.7122034,0.756779661 C12.4740339,0.518508475 12.0874915,0.518508475 11.8494237,0.756779661 C11.6110508,0.995050847 11.6110508,1.38138983 11.8494237,1.61966102 L18.2314915,8.00172881 L11.8494237,14.3838983 L11.8494237,14.3838983 Z" fill="#778BA2"></path></g></svg>';
				break;

			case 'scroll-circle':
				$output .= '<svg xmlns="http://www.w3.org/2000/svg" width="39" height="38" viewBox="0 0 39 38" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><g transform="translate(0.000000, -2.000000)" fill="#FFFFFF"><g transform="translate(-7.000000, -7.000000)"><path d="M44.1 21.1C42.4 16.4 39 12.6 34.4 10.5 29.9 8.3 24.8 8.1 20.1 9.8 15.4 11.4 11.6 14.9 9.5 19.4 7.3 23.9 7.1 29 8.8 33.7 8.9 34.1 9.3 34.3 9.7 34.2 10.1 34 10.3 33.6 10.2 33.2 8.7 28.9 8.9 24.2 10.9 20 12.8 15.9 16.3 12.7 20.6 11.2 25 9.7 29.6 9.9 33.8 11.9 37.9 13.8 41.1 17.3 42.6 21.6 44.2 26 43.9 30.6 42 34.8 40 38.9 36.5 42.1 32.2 43.6 27.3 45.4 22 44.8 17.6 42.2 17.2 42 16.8 42.1 16.5 42.5 16.3 42.8 16.4 43.3 16.8 43.5 19.8 45.3 23.1 46.2 26.4 46.2 28.5 46.2 30.7 45.8 32.7 45.1 37.4 43.4 41.2 40 43.3 35.4 45.5 30.9 45.7 25.8 44.1 21.1L44.1 21.1Z" transform="translate(26.413854, 27.413566) scale(-1, 1) rotate(-230.000000) translate(-26.413854, -27.413566) "/></g></g></g></svg>';
				break;

			case 'scroll-arrow':
				$output .= '<svg xmlns="http://www.w3.org/2000/svg" width="19" height="25" viewBox="0 0 19 25" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><g transform="translate(-1.000000, -1.000000)" fill="#FFFFFF"><g transform="translate(10.500000, 13.500000) rotate(-270.000000) translate(-10.500000, -13.500000) translate(-2.000000, 4.000000)"><path d="M18.5 9.5C18.5 9.1 18.1 8.7 17.8 8.7L0.7 8.7C0.4 8.7 0.1 9.1 0.1 9.5 0.1 9.9 0.4 10.3 0.7 10.3L17.8 10.3C18.1 10.3 18.5 9.9 18.5 9.5L18.5 9.5ZM14.6 17.5C14.3 17.8 14.3 18.3 14.6 18.6 14.7 18.7 14.9 18.8 15.1 18.8 15.3 18.8 15.5 18.7 15.6 18.6L24.2 10C24.5 9.7 24.5 9.3 24.2 9L15.6 0.4C15.3 0.1 14.9 0.1 14.6 0.4 14.3 0.7 14.3 1.2 14.6 1.5L22.5 9.5 14.6 17.5 14.6 17.5Z"/></g></g></g></svg>';
				break;

			case 'star':
				$output .= '<svg xmlns="http://www.w3.org/2000/svg" height="17px" width="18px" version="1.1" viewBox="119 0 18 17"><polygon fill-rule="evenodd" points="128 12.8 123 15.4 124 9.81 120 5.87 126 5.06 128 0 131 5.06 136 5.87 132 9.81 133 15.4" fill="#A5A5A5"/>/svg>';
				break;

			case 'eye':
				$output .= '<svg xmlns="http://www.w3.org/2000/svg" height="19px" width="33px" version="1.1" viewBox="13 21 33 19"><g fill-rule="evenodd" transform="translate(14 21)"><path d="m31.7 8.77c-4.8-5.8-10-8.74-15.5-8.74-2.2-0.0034-4.3 0.468-6.52 1.39-1.7 0.74-3.39 1.75-5.02 3.02-2.75 2.15-4.37 4.29-4.43 4.38-0.317 0.42-0.304 0.99 0.029 1.38 4.83 5.8 10 8.8 15.5 8.8 2.2 0 4.3-0.5 6.5-1.4 1.7-0.8 3.4-1.8 5-3 2.8-2.2 4.4-4.3 4.5-4.4 0.3-0.44 0.3-1.02-0.1-1.43zm-5.4 4.23c-2.4 1.8-6.1 4-10.5 4-4.8 0-9.4-2.5-13.8-7.49 0.69-0.79 1.97-2.12 3.67-3.44 2.39-1.84 6.13-4.04 10.5-4.04 4.8 0 9.4 2.52 13.8 7.51-0.7 0.76-2 2.16-3.7 3.46z"/><path d="m19 8.5c-0.4 0-0.8 0.38-0.8 0.84 0 1.26-1.1 2.26-2.4 2.26s-2.3-1-2.3-2.26c0-1.25 1-2.27 2.3-2.27 0.5 0 0.9-0.38 0.9-0.84 0-0.47-0.4-0.85-0.9-0.85-2.2 0-4 1.78-4 3.96 0 2.16 1.8 3.96 4 3.96 2.3 0 4.1-1.8 4.1-3.96 0-0.46-0.4-0.84-0.9-0.84z"/></g></svg>';
				break;

			case 'cross':
				$output .= '<svg xmlns="http://www.w3.org/2000/svg" height="29px" width="22px" version="1.1" viewBox="19 16 22 29"><g fill-rule="evenodd" transform="translate(19 16)"><path d="m22 24.4l-1.6-18c0-0.38-0.3-0.65-0.7-0.65h-3.3c0-3.01-2.4-5.45-5.4-5.45-2.97 0.001-5.39 2.44-5.39 5.45h-3.34c-0.35 0-0.65 0.27-0.69 0.63l-1.58 18 1.78e-15 0.1c0 2 1.83 3.6 4.08 3.6h13.8c2.3 0 4.1-1.6 4.1-3.6v-0.1zm-11-22.7c2.2 0 4 1.83 4 4.07h-8.02c0-2.24 1.8-4.07 4.02-4.07zm6.9 25.1h-13.8c-1.51 0-2.72-1-2.73-2.3l1.53-17.4 2.71 0.03v2.43c0 0.38 0.31 0.64 0.68 0.64 0.38 0 0.69-0.26 0.69-0.64v-2.43h8.02v2.43c0 0.38 0.3 0.64 0.7 0.64s0.7-0.26 0.7-0.64v-2.43h2.7l1.5 17.4c0 1.3-1.2 2.3-2.7 2.3z"/><path d="m14.4 17.6h-2.7v-2.7c0-0.4-0.3-0.7-0.7-0.7s-0.7 0.3-0.7 0.7v2.7h-2.68c-0.37 0-0.67 0.3-0.67 0.7s0.3 0.7 0.67 0.7h2.68v2.7c0 0.3 0.3 0.6 0.7 0.6s0.7-0.3 0.7-0.6v-2.7h2.7c0.3 0 0.7-0.3 0.7-0.7s-0.4-0.7-0.7-0.7z"/></g></svg>';
				break;

			case 'check':
				$output .= '<svg xmlns="http://www.w3.org/2000/svg" height="26px" width="25px" version="1.1"  viewBox="18 18 25 26"><g fill-rule="evenodd" transform="translate(18 18.3)" fill="none"><g fill="#000"><path d="m12.5 25c-6.9 0-12.5-5.6-12.5-12.5s5.6-12.5 12.5-12.5c2.3 0 4.6 0.647 6.6 1.87 0.3 0.22 0.4 0.67 0.2 1.01-0.2 0.35-0.7 0.46-1 0.24-1.7-1.08-3.8-1.65-5.8-1.65-6.09 0-11 4.94-11 11-0.03 6.1 4.91 11 11 11 6.1 0 11-4.9 11-11 0-1.2-0.2-2.4-0.6-3.58-0.1-0.38 0.1-0.8 0.5-0.93s0.8 0.08 0.9 0.46c0.5 1.3 0.7 2.65 0.7 4.05 0 6.9-5.6 12.5-12.5 12.5z"/><path d="m12.5 16.7c-0.2 0-0.4 0-0.5-0.2l-5.89-5.5c-0.3-0.3-0.31-0.7-0.03-1.03 0.27-0.3 0.74-0.31 1.03-0.04l5.29 4.97 9.7-11.4c0.2-0.34 0.7-0.38 1-0.12s0.4 0.72 0.1 1.03l-10.2 12.1c-0.1 0.1-0.3 0.2-0.5 0.2z"/></g></g></svg>';
				break;

			case 'loading':
				$output .= '<svg width="120" xmlns="http://www.w3.org/2000/svg" fill="#fff" viewBox="0 0 120 30" height="30"><circle cy="15" cx="15" r="15"><animate begin="0s" from="15" calcMode="linear" repeatCount="indefinite" attributeName="r" to="15" values="15;9;15" dur="0.8s"/><animate begin="0s" from="1" calcMode="linear" repeatCount="indefinite" attributeName="fill-opacity" to="1" values="1;.5;1" dur="0.8s"/></circle><circle cy="15" cx="60" r="9" fill-opacity=".3"><animate begin="0s" from="9" calcMode="linear" repeatCount="indefinite" attributeName="r" to="9" values="9;15;9" dur="0.8s"/><animate begin="0s" from="0.5" calcMode="linear" repeatCount="indefinite" attributeName="fill-opacity" to="0.5" values=".5;1;.5" dur="0.8s"/></circle><circle cy="15" cx="105" r="15"><animate begin="0s" from="15" calcMode="linear" repeatCount="indefinite" attributeName="r" to="15" values="15;9;15" dur="0.8s"/><animate begin="0s" from="1" calcMode="linear" repeatCount="indefinite" attributeName="fill-opacity" to="1" values="1;.5;1" dur="0.8s"/></circle></svg>';
				break;

			case 'face':
				$output .= '<svg width="289px" height="289px" viewBox="0 0 289 289" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M246.661809,42.320863 C219.370803,15.0298565 183.086141,0 144.491336,0 C105.896531,0 69.6112505,15.0298565 42.320863,42.320863 C15.0304754,69.6118694 0,105.895912 0,144.490717 C0,183.085522 15.0298565,219.370803 42.3202441,246.661809 C69.6106317,273.952816 105.895912,288.982672 144.490717,288.982672 C183.085522,288.982672 219.370803,273.952816 246.661809,246.661809 C273.952816,219.370803 288.982054,183.086141 288.982054,144.490717 C288.982054,105.895293 273.952816,69.6112505 246.661809,42.320863 L246.661809,42.320863 Z M62.8819443,255.413497 C69.9955525,243.09727 79.9094283,232.443257 91.7033512,224.455223 L102.929176,220.126411 L116.783229,225.46827 L130.637283,220.126411 L144.491336,225.46827 L158.34539,220.126411 L172.199443,225.46827 L186.053497,220.126411 L197.04973,224.366109 C208.929672,232.373328 218.914096,243.06509 226.073499,255.4333 C202.570435,272.793103 174.252767,282.174773 144.491955,282.174773 C114.718767,282.175392 86.3899593,272.786296 62.8819443,255.413497 L62.8819443,255.413497 Z M78.6513191,132.246895 L74.8553319,60.9895203 L214.12734,60.9895203 L210.330734,132.246895 C209.684043,144.378088 209.45012,156.688745 209.634535,168.837884 L210.321452,214.156426 L199.906931,218.172103 L186.052878,212.830244 L172.198824,218.172103 L158.344771,212.830244 L144.490717,218.172103 L130.636664,212.830244 L116.78261,218.172103 L102.928557,212.830244 L89.0745032,218.172103 L78.659364,214.156426 L79.3468994,168.837884 C79.5325525,156.688745 79.2980107,144.378088 78.6513191,132.246895 L78.6513191,132.246895 Z M241.848443,241.848443 C238.529585,245.167302 235.070248,248.293081 231.485287,251.225163 C225.046837,240.337227 216.56249,230.691929 206.584255,222.89388 L217.199899,218.800848 L216.440578,168.735775 C216.258638,156.740728 216.490086,144.586638 217.128113,132.610156 L221.306546,54.1828587 L67.6755075,54.1828587 L71.85394,132.610156 C72.4919679,144.586638 72.7234154,156.740728 72.5414754,168.735775 L71.7821542,218.800848 L82.3359143,222.869745 C72.3706745,230.6647 63.8962291,240.313092 57.4695375,251.202884 C53.8950964,248.276991 50.444424,245.158019 47.1342291,241.848443 C21.1291799,215.842775 6.80728051,181.26736 6.80728051,144.490717 C6.80728051,107.714075 21.1291799,73.1386595 47.1342291,47.1342291 C73.1392784,21.1291799 107.714694,6.80728051 144.491336,6.80728051 C181.267979,6.80728051 215.843394,21.1291799 241.848443,47.1342291 C267.853493,73.1386595 282.175392,107.714694 282.175392,144.490717 C282.175392,181.266741 267.853493,215.843394 241.848443,241.848443 L241.848443,241.848443 Z" stroke="none" fill="#000000" fill-rule="evenodd"></path><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" transform="translate(95.301927, 139.858672)"><path d="M10.6595824,20.6402934 C16.2322698,20.6402934 20.7665375,16.1066445 20.7665375,10.5339572 C20.7665375,4.96126981 16.2328887,0.427620985 10.6595824,0.427620985 C5.08689507,0.427620985 0.553246253,4.96126981 0.553246253,10.5339572 C0.553246253,16.1066445 5.08689507,20.6402934 10.6595824,20.6402934 L10.6595824,20.6402934 Z M10.6595824,7.23428266 C12.4789829,7.23428266 13.959257,8.71455675 13.959257,10.5333383 C13.959257,12.3521199 12.4789829,13.832394 10.6595824,13.832394 C8.84080086,13.832394 7.36052677,12.3521199 7.36052677,10.5333383 C7.36052677,8.71455675 8.84080086,7.23428266 10.6595824,7.23428266 L10.6595824,7.23428266 Z" fill="#000000"></path><path d="M87.7186167,20.6402934 C93.2913041,20.6402934 97.8249529,16.1066445 97.8249529,10.5339572 C97.8249529,4.96126981 93.2913041,0.427620985 87.7186167,0.427620985 C82.1459293,0.427620985 77.6122805,4.96126981 77.6122805,10.5339572 C77.6122805,16.1066445 82.1459293,20.6402934 87.7186167,20.6402934 L87.7186167,20.6402934 Z M87.7186167,7.23428266 C89.5373983,7.23428266 91.0176724,8.71455675 91.0176724,10.5333383 C91.0176724,12.3521199 89.5373983,13.832394 87.7186167,13.832394 C85.8998351,13.832394 84.419561,12.3521199 84.419561,10.5333383 C84.419561,8.71455675 85.8998351,7.23428266 87.7186167,7.23428266 L87.7186167,7.23428266 Z" fill="#000000"></path></g></svg>';
				break;

			case 'plus-circle':
				$output .= '<svg width="31px" height="31px" viewBox="18 668 31 31" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M48.0923193,678.299418 C46.7027711,674.401197 43.8785929,671.277449 40.1399589,669.503591 C36.40143,667.729627 32.1957951,667.518064 28.2980614,668.907785 C24.4003277,670.297507 21.2768654,673.122039 19.5032289,676.86114 C17.7296975,680.600241 17.51816,684.806297 18.9076032,688.704623 C19.0245636,689.032742 19.3854279,689.203632 19.7132952,689.086867 C20.0413728,688.969892 20.2124523,688.609193 20.0954919,688.281075 C18.8190159,684.700147 19.0133194,680.836398 20.6425681,677.401663 C22.2718168,673.966928 25.1409717,671.372248 28.7214517,670.095718 C32.3019317,668.819187 36.1653024,669.01362 39.5995031,670.642967 C43.033914,672.27242 45.6281647,675.141933 46.9046407,678.722861 C48.1810116,682.303788 47.9867082,686.167537 46.3574595,689.602272 C44.7282108,693.037007 41.8590559,695.631687 38.2785759,696.908218 C34.265458,698.338928 29.8631028,697.905921 26.2005508,695.720181 C25.9012667,695.541618 25.5144463,695.639465 25.3360108,695.938576 C25.1575752,696.237687 25.2553049,696.624766 25.5543788,696.803224 C27.9931027,698.258633 30.7325818,699.000105 33.4926578,699 C35.2448568,699 37.0056728,698.700994 38.7019661,698.096255 C42.599805,696.706533 45.7230571,693.882002 47.4966935,690.142901 C49.27033,686.403694 49.4818675,682.197639 48.0923193,678.299418 L48.0923193,678.299418 Z" stroke="none" fill="#FFFFFF" fill-rule="evenodd"></path><polygon stroke="none" fill="#FFFFFF" fill-rule="evenodd" points="37.8536 684.95568 34.1472 684.95568 34.1472 688.77056 32.7912 688.77056 32.7912 684.95568 29.06672 684.95568 29.06672 683.59968 32.7912 683.59968 32.7912 679.80288 34.1472 679.80288 34.1472 683.59968 37.8536 683.59968"></polygon></svg>';
				break;

			case 'close-circle':
				$output .= '<svg width="31px" height="31px" viewBox="18 668 31 31" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M48.0923193,678.299418 C46.7027711,674.401197 43.8785929,671.277449 40.1399589,669.503591 C36.40143,667.729627 32.1957951,667.518064 28.2980614,668.907785 C24.4003277,670.297507 21.2768654,673.122039 19.5032289,676.86114 C17.7296975,680.600241 17.51816,684.806297 18.9076032,688.704623 C19.0245636,689.032742 19.3854279,689.203632 19.7132952,689.086867 C20.0413728,688.969892 20.2124523,688.609193 20.0954919,688.281075 C18.8190159,684.700147 19.0133194,680.836398 20.6425681,677.401663 C22.2718168,673.966928 25.1409717,671.372248 28.7214517,670.095718 C32.3019317,668.819187 36.1653024,669.01362 39.5995031,670.642967 C43.033914,672.27242 45.6281647,675.141933 46.9046407,678.722861 C48.1810116,682.303788 47.9867082,686.167537 46.3574595,689.602272 C44.7282108,693.037007 41.8590559,695.631687 38.2785759,696.908218 C34.265458,698.338928 29.8631028,697.905921 26.2005508,695.720181 C25.9012667,695.541618 25.5144463,695.639465 25.3360108,695.938576 C25.1575752,696.237687 25.2553049,696.624766 25.5543788,696.803224 C27.9931027,698.258633 30.7325818,699.000105 33.4926578,699 C35.2448568,699 37.0056728,698.700994 38.7019661,698.096255 C42.599805,696.706533 45.7230571,693.882002 47.4966935,690.142901 C49.27033,686.403694 49.4818675,682.197639 48.0923193,678.299418 L48.0923193,678.299418 Z" stroke="none" fill="#FFFFFF" fill-rule="evenodd"></path><polygon stroke="none" fill="#FFFFFF" fill-rule="evenodd" transform="translate(34.460160, 684.286720) rotate(-315.000000) translate(-34.460160, -684.286720) " points="38.8536 684.95568 35.1472 684.95568 35.1472 688.77056 33.7912 688.77056 33.7912 684.95568 30.06672 684.95568 30.06672 683.59968 33.7912 683.59968 33.7912 679.80288 35.1472 679.80288 35.1472 683.59968 38.8536 683.59968"></polygon></svg>';
				break;

			case 'login':
				$output .= '<svg width="20px" height="21px" viewBox="0 0 20 21" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M14.5409238,12.8881054 C16.2497079,11.5663867 17.3509875,9.52090631 17.3509875,7.21874599 C17.3509875,3.23202333 14.0597635,0 10.0000163,0 C5.94026919,0 2.64904515,3.23202333 2.64904515,7.21874599 C2.64904515,9.52087421 3.75035745,11.5663867 5.45910889,12.8881054 C2.39508218,14.4217343 0.238570278,17.4510261 0,21 L1.33854266,21 C1.59649269,17.6768004 3.79643746,14.8916723 6.8243845,13.7215289 C7.7867051,14.1756451 8.86128446,14.4375562 10.0000163,14.4375562 C11.1394345,14.4375562 12.2133276,14.1756772 13.1756155,13.7215289 C16.2035625,14.8916723 18.4035073,17.6768004 18.6614573,21 L20,21 C19.762116,17.4510261 17.6049178,14.4217343 14.5409238,12.8881054 L14.5409238,12.8881054 Z M10.0000163,13.1250481 C6.67803961,13.1250481 3.9855616,10.4810009 3.9855616,7.21874599 C3.9855616,3.95652313 6.67803961,1.31250802 10.0000163,1.31250802 C13.3219931,1.31250802 16.0144711,3.95652313 16.0144711,7.21874599 C16.0144384,10.4810009 13.3219931,13.1250481 10.0000163,13.1250481 L10.0000163,13.1250481 Z" stroke="none" fill="#000000" fill-rule="evenodd"></path></svg>';
				break;

			case 'register':
				$output .= '<svg width="26px" height="23px" viewBox="0 0 26 23" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M14.5409238,14.8881054 C16.2497079,13.5663867 17.3509875,11.5209063 17.3509875,9.21874599 C17.3509875,5.23202333 14.0597635,2 10.0000163,2 C5.94026919,2 2.64904515,5.23202333 2.64904515,9.21874599 C2.64904515,11.5208742 3.75035745,13.5663867 5.45910889,14.8881054 C2.39508218,16.4217343 0.238570278,19.4510261 0,23 L1.33854266,23 C1.59649269,19.6768004 3.79643746,16.8916723 6.8243845,15.7215289 C7.7867051,16.1756451 8.86128446,16.4375562 10.0000163,16.4375562 C11.1394345,16.4375562 12.2133276,16.1756772 13.1756155,15.7215289 C16.2035625,16.8916723 18.4035073,19.6768004 18.6614573,23 L20,23 C19.762116,19.4510261 17.6049178,16.4217343 14.5409238,14.8881054 L14.5409238,14.8881054 Z M10.0000163,15.1250481 C6.67803961,15.1250481 3.9855616,12.4810009 3.9855616,9.21874599 C3.9855616,5.95652313 6.67803961,3.31250802 10.0000163,3.31250802 C13.3219931,3.31250802 16.0144711,5.95652313 16.0144711,9.21874599 C16.0144384,12.4810009 13.3219931,15.1250481 10.0000163,15.1250481 L10.0000163,15.1250481 Z" stroke="none" fill="#FFFFFF" fill-rule="evenodd"></path><polygon stroke="none" fill="#FFFFFF" fill-rule="evenodd" points="25.178 4.03 23.077 4.03 23.077 6.307 21.834 6.307 21.834 4.03 19.722 4.03 19.722 2.886 21.834 2.886 21.834 0.62 23.077 0.62 23.077 2.886 25.178 2.886"></polygon></svg>';
				break;

			case 'krown':
				$output .= '<svg width="12px" height="14px" viewBox="12 12 12 14" version="1.1" xmlns="http://www.w3.org/2000/svg"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" transform="translate(12.000000, 12.000000)" opacity="0.5"><path d="M12,10.4634172 L1.95399252e-14,10.4634172 L0,0.0252206584 C1.38777878e-17,0.0252206584 3.55697561,3.74115586 3.55697561,3.74115586 C3.55697561,3.74115586 5.89229268,1.33672022e-05 6.0157561,1.33672022e-05 C6.13921951,1.33672022e-05 8.47258537,3.73983472 8.47258537,3.73983472 L12,0.0252206584 L12,10.4634172 Z" fill="#000000"></path><rect fill="#000000" x="0" y="13" width="12" height="1"></rect></g></svg>';
				break;

			case 'bag':
				$output .= '<svg width="17px" height="22px" viewBox="0 0 17 22" version="1.1" xmlns="http://www.w3.org/2000/svg"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><path d="M17,18.5329798 L15.7756477,4.83623797 C15.7536269,4.5651885 15.5246114,4.35971551 15.2471503,4.35971551 L12.6663212,4.35971551 C12.6619171,2.08202559 10.7945596,0.228396947 8.5,0.228396947 C6.20544041,0.228396947 4.3380829,2.08202559 4.33367876,4.35971551 L1.75284974,4.35971551 C1.47979275,4.35971551 1.2507772,4.5651885 1.22435233,4.83623797 L1.77635684e-15,18.5329798 L1.77635684e-15,18.5810693 C1.77635684e-15,20.1068155 1.41373057,21.3483969 3.14896373,21.3483969 L13.8510363,21.3483969 C15.5862694,21.3483969 17,20.1068155 17,18.5810693 L17,18.5329798 L17,18.5329798 Z M8.5,1.27762071 C10.2132124,1.27762071 11.6049223,2.65909866 11.6093264,4.35971551 L5.39067358,4.35971551 C5.39507772,2.65909866 6.78678756,1.27762071 8.5,1.27762071 L8.5,1.27762071 Z M13.8510363,20.2948014 L3.14896373,20.2948014 C2.00388601,20.2948014 1.07020725,19.538486 1.05699482,18.5985563 L2.2373057,5.40893928 L4.33367876,5.40893928 L4.33367876,7.24945263 C4.33367876,7.53798916 4.57150259,7.77406451 4.86217617,7.77406451 C5.15284974,7.77406451 5.39067358,7.53798916 5.39067358,7.24945263 L5.39067358,5.40893928 L11.6093264,5.40893928 L11.6093264,7.24945263 C11.6093264,7.53798916 11.8471503,7.77406451 12.1378238,7.77406451 C12.4284974,7.77406451 12.6663212,7.53798916 12.6663212,7.24945263 L12.6663212,5.40893928 L14.7626943,5.40893928 L15.9430052,18.6029281 C15.9297927,19.538486 14.996114,20.2948014 13.8510363,20.2948014 L13.8510363,20.2948014 Z" fill="#000000"></path></g></svg>';
        break;

      case 'tag':
      	$output .= '<svg width="16px" height="20px" viewBox="0 0 16 20" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M15.2346361,19.9999809 C15.0132833,19.9999809 14.7975654,19.9057113 14.6491597,19.7333241 L8,12.0047801 L1.35084026,19.7333241 C1.14357463,19.974342 0.804746775,20.062427 0.502851893,19.9544673 C0.200895762,19.8462675 0,19.5646596 0,19.249487 L0,0.750553944 C0,0.336068034 0.342809019,0 0.76560885,0 L15.2343911,0 C15.6571297,0 16,0.336068034 16,0.750553944 L16,19.2493669 C16,19.5645395 15.7991042,19.8461474 15.4971481,19.9543472 C15.4112774,19.9850899 15.3224668,19.9999809 15.2346361,19.9999809 L15.2346361,19.9999809 Z M8,10.0900269 C8.22564024,10.0900269 8.43976572,10.1875989 8.58523141,10.3566837 L14.4688435,17.1953109 L14.4688435,1.50110789 L1.5312177,1.50110789 L1.5312177,17.1953109 L7.41476859,10.3566837 C7.56023428,10.1875989 7.77435976,10.0900269 8,10.0900269 L8,10.0900269 Z" stroke="none" fill="#000000" fill-rule="evenodd"></path></svg>';
      	break;

      case 'lock':
      	$output .= '<svg xmlns="http://www.w3.org/2000/svg" height="250px" width="176px" version="1.1" viewBox="906 414 176 250"><g opacity="0.05" fill-rule="evenodd" transform="translate(906 414)" fill="none"><circle stroke-width="7" cy="176" stroke="#000" cx="87.5" r="18.5"/><path fill="#000" d="m156 104h-3v-2-36.8c0-36-29-65.2-65.1-65.2-36 0-65.3 29.2-65.3 65.2v38.8h-2.6c-11 0-20 9-20 20v106c0 11 8.96 20 20 20h136c11 0 20-9 20-20v-106c0-11-9-20-20-20zm-125-38.8c0-31.6 25.7-57.2 57.3-57.2 31.1-0.02 57.1 25.6 57.1 57.2v36.8 2h-93.1v-38.8c0-19.8 16.2-35.9 36-35.9 20.1 0 36.1 16.1 36.1 35.9v26.6c0 2.2 2 3.9 4 3.9s4-1.7 4-3.9v-26.6c0-24.2-20-43.9-44.1-43.9-24.3 0-44 19.7-44 43.9v38.8h-13.3v-38.8zm137 165c0 7-6 12-12 12h-136c-6.6 0-12-5-12-12l-0.01-106c0-7 5.41-12 12-12h136c6 0 12 5 12 12v106z"/></g></svg>';
      	break;

      case 'social_twitter':
      	$output .= '<svg xmlns="http://www.w3.org/2000/svg" height="20px" width="24px" version="1.1" viewBox="0 6 24 20"><g fill-rule="evenodd" transform="translate(0 6)" fill="none"><path fill="#000" d="m8.16 19.4c-2.45 0-4.94-0.7-7.4-2.1-0.213-0.1-0.309-0.3-0.235-0.5 0.074-0.3 0.298-0.4 0.535-0.4 1.85 0.2 3.81-0.2 5.27-1.1-1.69-0.4-3.06-1.5-3.79-3.1-0.08-0.2-0.04-0.4 0.08-0.5 0.14-0.2 0.34-0.2 0.53-0.2 0.21 0.1 0.43 0.2 0.64 0.2-1.29-0.8-2.67-2.25-2.67-4.45 0-0.2 0.12-0.37 0.29-0.45 0.17-0.09 0.38-0.07 0.53 0.06 0.16 0.12 0.33 0.24 0.51 0.32-0.37-0.5-0.69-1.12-0.87-1.81-0.33-1.29-0.14-2.59 0.56-3.76 0.08-0.15 0.23-0.23 0.39-0.24 0.16-0.02 0.32 0.05 0.43 0.18 1.47 1.84 4.08 4.07 8.24 4.47 0-1.33 0.4-3.51 2.2-4.58 2.3-1.32 4.5-1.15 6.3 0.48 0.8-0.18 2.2-0.75 2.4-0.938 0.2-0.121 0.4-0.12 0.6-0.001s0.2 0.339 0.2 0.539c-0.1 0.47-0.4 0.99-0.8 1.46 0.3-0.08 0.5-0.16 0.7-0.23 0.2-0.1 0.4-0.06 0.6 0.11 0.1 0.16 0.1 0.41 0 0.6-0.6 0.93-1.5 1.8-2.2 2.27 0.3 3.12-1 6.57-3.4 9.27-2.5 2.9-6 4.4-9.64 4.4zm-5.01-2c1.68 0.7 3.36 1 5.01 1 3.34 0 6.54-1.4 8.94-4.1 2.3-2.6 3.5-5.84 3.1-8.76 0-0.19 0.1-0.37 0.2-0.48 0.3-0.18 0.7-0.5 1.1-0.9-0.4 0.09-0.8 0.14-1 0.15-0.3 0-0.5-0.17-0.5-0.41-0.1-0.23 0-0.47 0.3-0.56 0.3-0.11 0.6-0.45 1-0.87-0.6 0.22-1.2 0.41-1.7 0.48-0.1 0.02-0.3-0.03-0.4-0.13-1.6-1.49-3.4-1.66-5.3-0.53-1.7 1.03-1.8 3.4-1.6 4.15 0.1 0.15 0 0.32-0.1 0.44s-0.2 0.19-0.4 0.18c-4.47-0.24-7.37-2.35-9.12-4.29-0.36 0.93-0.28 1.77-0.13 2.34 0.29 1.14 1.03 2.01 1.59 2.33 0.18 0.11 0.28 0.31 0.25 0.52-0.04 0.2-0.19 0.36-0.4 0.4-0.57 0.12-1.18 0.05-1.75-0.18 0.52 2.12 2.69 3.02 3.3 3.12 0.2 0 0.36 0.2 0.42 0.4s0 0.4-0.15 0.5c-0.44 0.4-1.08 0.5-1.83 0.5 0.83 1.1 2.13 1.8 3.68 1.8 0.2 0 0.38 0.1 0.46 0.3 0.07 0.2 0.01 0.4-0.14 0.6-1.2 1-2.98 1.8-4.83 2z"/></g></svg>';
      	break;

      case 'social_facebook':
      	$output .= '<svg xmlns="http://www.w3.org/2000/svg" height="24px" width="14px" version="1.1" viewBox="94 1 14 24"><g fill-rule="evenodd" transform="translate(94 1)" fill="none"><path fill="#000" d="m8 24h-3c-0.28 0-0.5-0.2-0.5-0.5v-9.5h-3.5c-0.275 0-0.5-0.2-0.5-0.5v-4c0-0.28 0.225-0.5 0.5-0.5h3.5v-3.96c0-2.68 2.6-5.04 5.6-5.04h2.9c0.3 0 0.5 0.225 0.5 0.5v3c0 0.28-0.2 0.5-0.5 0.5h-1.8c-1.1 0-2.7 1-2.7 1.91v3.09h4.4c0.2 0 0.3 0.07 0.4 0.2 0.1 0.12 0.1 0.29 0.1 0.44l-1.1 3.96c-0.1 0.3-0.3 0.4-0.5 0.4h-3.3v9.5c0 0.3-0.22 0.5-0.5 0.5zm-2.5-1h2v-9.5c0-0.3 0.22-0.5 0.5-0.5h3.4l0.9-3h-4.3c-0.28 0-0.5-0.22-0.5-0.5v-3.59c0-1.61 2.24-2.91 3.7-2.91h1.3v-2h-2.4c-2.2 0-4.6 1.66-4.6 4.04v4.46c0 0.28-0.22 0.5-0.5 0.5h-3.5v3h3.5c0.28 0 0.5 0.2 0.5 0.5v9.5z"/></g></svg>';
      	break;

      case 'social_dribbble':
      	$output .= '<svg xmlns="http://www.w3.org/2000/svg" height="24px" width="24px" version="1.1" viewBox="177 1 24 24"><g fill-rule="evenodd" transform="translate(177 1)" fill="none"><g fill="#000"><path d="m12 1c6.1 0 11 4.94 11 11 0 6.1-4.9 11-11 11-6.06 0-11-4.9-11-11 0-6.06 4.94-11 11-11zm0-1c-6.63 0-12 5.37-12 12 0 6.6 5.37 12 12 12 6.6 0 12-5.4 12-12 0-6.63-5.4-12-12-12z"/><path d="m17 22.5c-0.3 0-0.5-0.2-0.5-0.5-0.5-7.3-3.9-14.9-9.31-20.2-0.2-0.22-0.2-0.54 0-0.74 0.19-0.191 0.51-0.191 0.71 0 5.5 5.55 9.1 13.3 9.6 20.9 0 0.2-0.2 0.5-0.5 0.5z"/><path d="m1 11.1c-0.276 0-0.5-0.3-0.5-0.5 0-0.3 0.224-0.5 0.5-0.5 6.74 0 15.4-1.13 18.6-6.35 0.1-0.24 0.4-0.32 0.7-0.18 0.2 0.15 0.3 0.45 0.1 0.69-3.3 5.62-12.4 6.84-19.4 6.84z"/><path d="m4.69 21h-0.25c-0.24-0.2-0.32-0.5-0.19-0.7 4.23-7.4 13-9.8 19-7.8 0.2 0.1 0.4 0.4 0.3 0.7-0.1 0.2-0.4 0.4-0.7 0.3-5.5-1.9-13.7 0.3-17.7 7.3-0.07 0.2-0.24 0.2-0.41 0.2z"/></g></g></svg>';
     		break;

     	case 'social_behance':
     		$output .= '<svg xmlns="http://www.w3.org/2000/svg" height="16px" width="24px" version="1.1" viewBox="270 9 24 16"><g fill-rule="evenodd" transform="translate(270 9)" fill="none"><g fill="#000"><path d="m7 8.5c-0.28 0-0.5-0.22-0.5-0.5s0.22-0.5 0.5-0.5c1.68 0 3-1.35 3-3s-1.32-3-3-3c-0.28 0-0.5-0.22-0.5-0.5 0-0.275 0.22-0.5 0.5-0.5 2.23 0 4 1.79 4 4s-1.77 4-4 4z"/><path d="m7 15.5c-0.28 0-0.5-0.2-0.5-0.5s0.22-0.5 0.5-0.5c1.92 0 4-0.8 4-3 0-2.06-2.09-3-4-3-0.28 0-0.5-0.22-0.5-0.5s0.22-0.5 0.5-0.5c2.92 0 5 1.64 5 4 0 2.4-2 4-5 4z"/><path d="m7 8.5h-6c-0.276 0-0.5-0.22-0.5-0.5s0.224-0.5 0.5-0.5h6c0.28 0 0.5 0.22 0.5 0.5s-0.22 0.5-0.5 0.5z"/><path d="m19 15.5c-3.1 0-5.5-2.4-5.5-5.5 0-3.01 2.2-5.46 5-5.46 3.4 0 5.5 2.09 5.5 5.46 0 0.3-0.2 0.5-0.5 0.5s-0.5-0.2-0.5-0.5c0-1.34-0.4-4.46-4.5-4.46-2.2 0-4 2-4 4.46 0 2.6 1.9 4.5 4.5 4.5 1.3 0 2.9-0.7 3.6-1.6 0.2-0.3 0.5-0.3 0.7-0.1 0.2 0.1 0.3 0.4 0.1 0.7-1 1.3-3 2-4.4 2z"/><path d="m23 10.5h-9c-0.3 0-0.5-0.2-0.5-0.5 0-0.28 0.2-0.5 0.5-0.5h9c0.3 0 0.5 0.22 0.5 0.5 0 0.3-0.2 0.5-0.5 0.5z"/><path d="m21 2.5h-5c-0.3 0-0.5-0.22-0.5-0.5s0.2-0.5 0.5-0.5h5c0.3 0 0.5 0.22 0.5 0.5s-0.2 0.5-0.5 0.5z"/><path d="m7 15.5h-6.5c-0.276 0-0.5-0.2-0.5-0.5v-14c0-0.275 0.224-0.5 0.5-0.5h6.5c0.28 0 0.5 0.225 0.5 0.5 0 0.28-0.22 0.5-0.5 0.5h-6v13h6c0.28 0 0.5 0.2 0.5 0.5s-0.22 0.5-0.5 0.5z"/></g></g></svg>';
     		break;

     	case 'social_instagram':
     		$output .= '
					<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
					    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					        <g transform="translate(-363.000000, -71.000000)">
					            <g transform="translate(363.000000, 71.000000)">
					                <g>
					                    <path d="M20.5,24 L3.5,24 C1.57,24 0,22.43 0,20.5 L0,3.5 C0,1.57 1.57,0 3.5,0 L20.5,0 C22.43,0 24,1.57 24,3.5 L24,20.5 C24,22.43 22.43,24 20.5,24 Z M3.5,1 C2.122,1 1,2.121 1,3.5 L1,20.5 C1,21.879 2.122,23 3.5,23 L20.5,23 C21.878,23 23,21.879 23,20.5 L23,3.5 C23,2.121 21.878,1 20.5,1 L3.5,1 Z" fill="#000000"></path>
					                    <path d="M19,7 C17.8972308,7 17,6.10276923 17,5 C17,3.89723077 17.8972308,3 19,3 C20.1027692,3 21,3.89723077 21,5 C21,6.10276923 20.1027692,7 19,7 Z M19,3.61538462 C18.2363077,3.61538462 17.6153846,4.23692308 17.6153846,5 C17.6153846,5.76307692 18.2363077,6.38461538 19,6.38461538 C19.7636923,6.38461538 20.3846154,5.76307692 20.3846154,5 C20.3846154,4.23692308 19.7636923,3.61538462 19,3.61538462 Z" fill="#000000"></path>
					                    <circle style="fill: none;" stroke-width="0.849999964" cx="12" cy="12" r="4"></circle>
					                </g>
					            </g>
					        </g>
					    </g>
					</svg>';
     		break;

     	case 'social_linkedin':
     		$output .= '<svg xmlns="http://www.w3.org/2000/svg" height="26px" width="25px" version="1.1" viewBox="455 0 25 26"><g fill-rule="evenodd" transform="translate(455)" fill="none"><g fill="#000"><path d="m6.02 9.02h-5c-0.275 0-0.499 0.22-0.499 0.5v15c0 0.3 0.224 0.5 0.499 0.5h5c0.28 0 0.5-0.2 0.5-0.5v-15c0-0.26-0.22-0.48-0.5-0.48zm-0.5 15h-4v-14h4v14z"/><path d="m3.73 0.985c-1.77 0-3.21 1.46-3.21 3.24 0.001 1.8 1.44 3.26 3.21 3.26s3.2-1.46 3.2-3.25-1.43-3.24-3.2-3.24zm0 5.5c-1.22 0-2.21-1.01-2.21-2.25s0.99-2.24 2.21-2.24c1.21 0 2.2 1 2.2 2.24s-0.99 2.25-2.2 2.25z"/><path d="m18.5 8.91c-2.4 0-4.1 0.6-5 1.05v-0.44c0-0.28-0.2-0.5-0.5-0.5h-3.98c-0.28 0-0.5 0.22-0.5 0.5v15c0 0.3 0.22 0.5 0.5 0.5h3.98c0.3 0 0.5-0.2 0.5-0.5v-8.2c0-1.3 1.3-2.3 2.5-2.3s2.5 1 2.5 2.3v8.2c0 0.3 0.2 0.5 0.5 0.5h5c0.3 0 0.5-0.2 0.5-0.5v-9.6c0-3.3-2.7-5.99-6-5.99zm5 15.1h-4v-7.7c0-1.8-1.6-3.3-3.5-3.3-1.8 0-3.5 1.5-3.5 3.3v7.7h-2.98v-14h2.98v0.8c0 0.2 0.1 0.4 0.3 0.5s0.4 0.1 0.5-0.1c0 0 1.8-1.29 5.2-1.29 2.8 0 5 2.19 5 4.99v9.1z"/></g></g></svg>';
     		break;

     	case 'social_pinterest':
     		$output .= '<svg xmlns="http://www.w3.org/2000/svg" height="26px" width="26px" version="1.1" viewBox="549 0 26 26"><g fill-rule="evenodd" transform="translate(549)" fill="none"><g fill="#000"><path d="m13 1.96c6.1 0 11 4.95 11 11 0 6.1-4.9 11-11 11-6.09 0-11-4.9-11-11-0.04-6.09 4.91-11 11-11v-0.04zm0-1c-6.65 0-12 5.39-12 12-0.042 6.6 5.35 12 12 12 6.6 0 12-5.4 12-12 0-6.65-5.4-12-12-12v-0.042z"/><path d="m9.05 24.1h-0.14c-0.27-0.1-0.42-0.3-0.34-0.6l1.93-6.3c-0.56-0.9-0.84-2.2-0.84-3.5 0-1.8 0.54-3.71 1.74-3.71 0.6 0 1 0.31 1.1 0.61 0.8 1 0.1 3.1-0.1 3.5l-0.8 2.9c0.4 0.6 1 1 1.9 1 2.5 0 5.5-1.4 5.5-5.5 0-3.23-1.9-6.51-5.5-6.51-2.6 0-6.54 1.47-6.54 5.51 0 1.8 0.6 3.1 1.66 3.5 0.26 0.2 0.37 0.5 0.25 0.7-0.11 0.3-0.41 0.4-0.66 0.3-1.43-0.7-2.25-2.3-2.25-4.5 0-4.78 4.54-6.51 7.54-6.51 4.3 0 6.5 3.79 6.5 7.51 0 4.5-3.3 6.5-6.5 6.5-0.9 0-1.7-0.3-2.3-0.8l-1.67 5.6c-0.06 0.2-0.26 0.3-0.48 0.3zm2.35-13.1c-0.3 0-0.9 1.4-0.7 3.4 0 0.2 0.1 0.7 0.2 1.3l0.6-1.9c0.3-0.8 0.6-2.2 0.2-2.7 0 0-0.1-0.1-0.3-0.1z"/></g></g></svg>';
     		break;

     	case 'social_soundcloud':
     		$output .= '<svg width="30px" height="14px" viewBox="644 12 30 14" version="1.1" xmlns="http://www.w3.org/2000/svg"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" transform="translate(644.000000, 12.000000)"><g fill="#000000"><path d="M24.736,13.25 L17.162,13.25 C16.887,13.25 16.662,13.025 16.662,12.75 L16.662,1.57 C16.662,1.343 16.662,0.75 18.891,0.75 C22.043,0.75 24.549,2.937 24.803,5.813 C25.082,5.745 25.366,5.709 25.649,5.709 C27.684,5.709 29.338,7.397 29.338,9.477 C29.338,11.52 27.649,13.247 25.649,13.247 L24.736,13.25 Z M17.662,12.25 L25.65,12.244 C27.107,12.244 28.338,10.974 28.338,9.474 C28.338,7.974 27.108,6.705 25.65,6.705 C25.267,6.705 24.89,6.791 24.525,6.961 C24.365,7.033 24.181,7.022 24.037,6.924 C23.892,6.826 23.808,6.662 23.814,6.486 L23.822,6.382 C23.826,3.696 21.705,1.742 18.892,1.742 C18.398,1.742 17.92,1.798 17.662,1.852 L17.662,12.25 L17.662,12.25 Z"></path><path d="M15.163,12.75 C14.887,12.75 14.663,12.525 14.663,12.25 L14.663,1.25 C14.663,0.975 14.887,0.75 15.163,0.75 C15.439,0.75 15.663,0.975 15.663,1.25 L15.663,12.25 C15.662,12.525 15.438,12.75 15.163,12.75 Z"></path><path d="M13.163,12.75 C12.887,12.75 12.663,12.525 12.663,12.25 L12.663,2.25 C12.663,1.975 12.887,1.75 13.163,1.75 C13.439,1.75 13.663,1.975 13.663,2.25 L13.663,12.25 C13.663,12.525 13.438,12.75 13.163,12.75 Z"></path><path d="M11.163,12.75 C10.887,12.75 10.663,12.525 10.663,12.25 L10.663,3.25 C10.663,2.975 10.887,2.75 11.163,2.75 C11.439,2.75 11.663,2.975 11.663,3.25 L11.663,12.25 C11.663,12.525 11.438,12.75 11.163,12.75 Z"></path><path d="M9.163,12.75 C8.887,12.75 8.663,12.525 8.663,12.25 L8.663,3.25 C8.663,2.975 8.887,2.75 9.163,2.75 C9.439,2.75 9.663,2.975 9.663,3.25 L9.663,12.25 C9.663,12.525 9.438,12.75 9.163,12.75 Z"></path><path d="M7.163,12.75 C6.887,12.75 6.663,12.525 6.663,12.25 L6.663,2.25 C6.663,1.975 6.887,1.75 7.163,1.75 C7.439,1.75 7.663,1.975 7.663,2.25 L7.663,12.25 C7.663,12.525 7.438,12.75 7.163,12.75 Z"></path><path d="M5.163,12.75 C4.887,12.75 4.663,12.525 4.663,12.25 L4.663,3.25 C4.663,2.975 4.887,2.75 5.163,2.75 C5.439,2.75 5.663,2.975 5.663,3.25 L5.663,12.25 C5.663,12.525 5.438,12.75 5.163,12.75 Z"></path><path d="M3.163,11.75 C2.887,11.75 2.663,11.525 2.663,11.25 L2.663,4.25 C2.663,3.975 2.887,3.75 3.163,3.75 C3.439,3.75 3.663,3.975 3.663,4.25 L3.663,11.25 C3.663,11.525 3.438,11.75 3.163,11.75 Z"></path><path d="M1.163,10.75 C0.887,10.75 0.663,10.525 0.663,10.25 L0.663,6.25 C0.663,5.975 0.887,5.75 1.163,5.75 C1.439,5.75 1.663,5.975 1.663,6.25 L1.663,10.25 C1.663,10.525 1.437,10.75 1.163,10.75 Z"></path></g></g></svg>';
     		break;

     	case 'social_500px':
     		$output .= '<svg width="15px" height="20px" viewBox="0 0 15 20" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><g transform="translate(-872.000000, -189.000000)" fill="#000000"><g transform="translate(126.000000, 184.000000)"><g transform="translate(746.000000, 5.000000)"><g><path d="M8.42947059,17.6919626 C11.8785882,17.6919626 14.6846471,14.7198131 14.6846471,11.0665421 C14.6846471,7.41327103 11.8785882,4.4411215 8.42947059,4.4411215 C6.70870588,4.4411215 5.09382353,5.18747664 3.93088235,6.46186916 L3.93088235,1.12149533 L12.5350588,1.12149533 C12.8274706,1.12149533 13.0644706,0.87046729 13.0644706,0.560747664 C13.0644706,0.251028037 12.8274706,0 12.5350588,0 L3.40147059,0 C3.10905882,0 2.87205882,0.251028037 2.87205882,0.560747664 L2.87205882,8.01252336 L2.86588235,8.14915888 C2.85441176,8.41028037 3.01464706,8.64542056 3.25217647,8.71570093 C3.49058824,8.78616822 3.74205882,8.6728972 3.85976471,8.44336449 C4.77123529,6.66635514 6.52217647,5.56242991 8.42947059,5.56242991 C11.2946471,5.56242991 13.6258235,8.03140187 13.6258235,11.0663551 C13.6258235,14.1013084 11.2946471,16.5702804 8.42947059,16.5702804 C7.46611765,16.5702804 6.55129412,16.2831776 5.76317647,15.7828037 L5.76317647,11.0665421 C5.76317647,9.50915888 6.95929412,8.24224299 8.42947059,8.24224299 C9.89964706,8.24224299 11.0957647,9.50915888 11.0957647,11.0665421 C11.0957647,12.6239252 9.89964706,13.8908411 8.42947059,13.8908411 C8.07352941,13.8908411 7.72817647,13.8179439 7.40294118,13.6740187 C7.13417647,13.5547664 6.82323529,13.6895327 6.71047059,13.975514 C6.59788235,14.2613084 6.72529412,14.5897196 6.99511765,14.708972 C7.45023529,14.9102804 7.93270588,15.0123364 8.42947059,15.0123364 C10.4835882,15.0123364 12.1545882,13.242243 12.1545882,11.0665421 C12.1545882,8.89084112 10.4834118,7.12074766 8.42947059,7.12074766 C6.37552941,7.12074766 4.70435294,8.89084112 4.70435294,11.0665421 L4.70435294,14.8986916 C4.10823529,14.2508411 3.657,13.4454206 3.41947059,12.5327103 C3.34182353,12.2342056 3.05047059,12.0586916 2.76847059,12.1411215 C2.48647059,12.2233645 2.32111765,12.5321495 2.39858824,12.8306542 C3.14347059,15.6930841 5.62323529,17.6919626 8.42947059,17.6919626 Z"></path><path d="M5.24805882,2.83308411 C4.98088235,2.95869159 4.86052941,3.29009346 4.97911765,3.57308411 C5.09770588,3.85588785 5.41023529,3.98392523 5.67794118,3.85794393 C7.33711765,3.07757009 10.5974118,2.26224299 13.7844706,5.57252336 C13.8875294,5.67962617 14.0214706,5.7328972 14.1552353,5.7328972 C14.2923529,5.7328972 14.4296471,5.67682243 14.5332353,5.56485981 C14.7379412,5.34373832 14.7347647,4.98859813 14.526,4.7717757 C10.7564118,0.856635514 6.78176471,2.11158879 5.24805882,2.83308411 Z"></path><path d="M14.7139412,16.1306542 C14.4931765,15.9276636 14.1587647,15.9521495 13.9671176,16.1859813 C12.5721176,17.8854206 10.5536471,18.8601869 8.42947059,18.8601869 C4.69764706,18.8601869 1.56476471,15.9033645 1.14211765,11.982243 C1.10894118,11.6745794 0.846,11.4528972 0.556235294,11.488785 C0.265764706,11.5239252 0.057,11.8016822 0.0901764706,12.1095327 C0.573705882,16.5973832 4.15888235,19.9818692 8.42947059,19.9818692 C10.8601765,19.9818692 13.1698235,18.8665421 14.766,16.9220561 C14.9578235,16.6880374 14.9345294,16.3338318 14.7139412,16.1306542 Z"></path><path d="M7.08229412,12.4259813 C7.18588235,12.5371963 7.32247059,12.5930841 7.45923529,12.5930841 C7.59352941,12.5930841 7.72782353,12.5392523 7.83088235,12.4315888 L8.37458824,11.8637383 L8.91070588,12.4394393 C9.01429412,12.5506542 9.15088235,12.6065421 9.28764706,12.6065421 C9.42194118,12.6065421 9.55623529,12.5527103 9.65929412,12.4450467 C9.86752941,12.2274766 9.86982353,11.8725234 9.66441176,11.6519626 L9.12847059,11.0762617 L9.65241176,10.5291589 C9.86064706,10.3115888 9.86294118,9.95663551 9.65752941,9.73607477 C9.45211765,9.51551402 9.11682353,9.51308411 8.90894118,9.73046729 L8.385,10.277757 L7.86829412,9.72280374 C7.66288235,9.50224299 7.32758824,9.49981308 7.11970588,9.71719626 C6.91147059,9.93476636 6.90917647,10.2897196 7.11458824,10.5102804 L7.63111765,11.0650467 L7.08758824,11.6328972 C6.87935294,11.8504673 6.87688235,12.2054206 7.08229412,12.4259813 Z"></path></g></g></g></g></g></svg>';
     		break;

     	case 'social_youtube':
     		$output .= '
					<svg version="1.1" viewBox="0 0 25 18" xmlns="http://www.w3.org/2000/svg">
					<g fill="none" fill-rule="evenodd">
					<g transform="translate(-1 -31)">
					<g transform="translate(1 27)" fill="#000" fill-rule="nonzero">
					<path d="m12.648 21.743c-2.2978 0-4.641-0.087512-8.0856-0.30412-1.7816-0.11177-3.4387-1.7216-3.6197-3.5187-0.39321-3.951-0.39237-5.8789 0.001684-9.8256 0.18019-1.7953 1.8372-3.406 3.618-3.5187 6.8883-0.43063 9.2812-0.43063 16.17 0 1.7808 0.11264 3.437 1.7234 3.618 3.5187 0.39573 3.9562 0.39658 5.8849 0.003368 9.8273-0.18103 1.7944-1.8389 3.4078-3.6214 3.5195-3.4437 0.21228-5.787 0.30153-8.0848 0.30153zm0-16.605c-2.2801 0-4.6074 0.088378-8.0342 0.30239-1.3708 0.086645-2.6944 1.3681-2.8316 2.7423-0.38731 3.8756-0.38816 5.7697-8.4198e-4 9.6488 0.13809 1.3751 1.4617 2.6557 2.8333 2.7423 6.8521 0.42976 9.2139 0.42976 16.068 0 1.3716-0.086645 2.696-1.3673 2.8341-2.7423 0.38563-3.8704 0.38563-5.7654-0.0025259-9.6497-0.13809-1.3742-1.4617-2.6557-2.8324-2.7423-3.4252-0.21315-5.7525-0.30153-8.0334-0.30153z"/>
					<path d="m10.626 15.866c-0.0832 0-0.16553-0.0234-0.2366-0.0702-0.1222-0.0806-0.19673-0.21667-0.19673-0.36313v-5.8145c0-0.14647 0.073667-0.28253 0.19673-0.36313 0.12307-0.079733 0.27733-0.091867 0.41167-0.0338l6.6213 2.9068c0.1586 0.068467 0.26 0.22447 0.26 0.39693 0 0.17247-0.1014 0.3276-0.26 0.39693l-6.6213 2.9077c-0.056333 0.024267-0.11613 0.0364-0.17507 0.0364zm0.43333-5.5839v4.4876l5.1107-2.2438-5.1107-2.2438z"/>
					</g>
					</g>
					</g>
					</svg>';
				break;
			
		}

		$output .= '</span>';

		return $output;

	}

endif;