<?php

/** Improve WP gallery shortcode
 *
 * @since 1.0.0
*/

if ( ! function_exists( 'calafate_gallery_shortcode' ) ) :

	function calafate_gallery_shortcode( $attr, $content ) {

		global $post;

		$post = get_post();

		static $instance = 0;
		$instance++;

		if ( ! empty( $attr['ids'] ) ) {
	    if ( empty( $attr['orderby'] ) ) {
	      $attr['orderby'] = 'post__in';
	    }
	    $attr['include'] = $attr['ids'];
		}

		$html = apply_filters( 'post_gallery', '', $attr );
		if ( $html != '' ) {
	    return $html;
		}

		if ( isset( $attr['orderby'] ) ) {
	    $attr['orderby'] = sanitize_sql_orderby( $attr['orderby'] );
	    if ( !$attr['orderby'] ) {
	      unset( $attr['orderby'] );
	    }
		}

		extract( shortcode_atts( array(
	    'order'          => 'ASC',
	    'orderby'        => 'menu_order ID',
	    'id'             => $post->ID,
	    'include'        => '',
	    'exclude'        => '',
	    'type'           => 'thumbs',
	    'columns'        => '3',
	    'link'					 => 'none',
	    'size'					 => 'full',
	    'css_class'			 => ''
		), $attr ) );

		$id = intval( $id );
		if ( 'RAND' == $order ) {
	    $orderby = 'none';
		}

		if ( ! empty( $include ) ) {

	    $_attachments = get_posts( array('include' => $include, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );

	    $attachments = array();

	    foreach ( $_attachments as $key => $val ) {
	      $attachments[$val->ID] = $_attachments[$key];
	    }

		} else if ( ! empty( $exclude ) ) {
	    $attachments = get_children( array('post_parent' => $id, 'exclude' => $exclude, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );
		} else {
	    $attachments = get_children( array('post_parent' => $id, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );
		}

		if ( empty( $attachments ) ) {
	    return '';
		}

		if ( is_feed() ) {
	    $html = "\n";
	    foreach ( $attachments as $att_id => $attachment ) {
	      $html .= wp_get_attachment_link( $att_id, $size, true ) . "\n";
	    }
	    return $html;
		}

		$output = '';

		foreach ( $attachments as $id => $attachment ) {

	    $img_url = isset( $attr['link'] ) && 'file' == $attr['link'] ? wp_get_attachment_image_src( $id, 'full', false, false ) : wp_get_attachment_image_src( $id, 'full', true, false );

	    $img = wp_get_attachment_image_src( $id, $size, true, false );

	    $caption = get_post( $id )->post_excerpt;
	    $title = get_post( $id )->post_title;
	  	$alt = get_post_meta( $id, '_wp_attachment_image_alt', true );

	    if ( $type == 'slider' ) {

	    	$output .= '<div class="carousel-cell">';

		    	if ( $link !== 'none' ) {
		    		$output .= '<a class="fancybox fancybox-thumb" data-fancybox-group="gallery-' . $instance . '" data-fancybox-title="' . $caption . '" href="' . esc_url( $img_url[0] ) . '">';
		    	}

		    		$output .= '<img src="' . esc_url( $img[0] ) . '" title="' . esc_attr( $title ) . '" alt="' . esc_attr( $alt ) . '" />';
			    	
		        if ( isset( $caption ) && $caption != '' ) {
	            $output .= '<p class="caption">'. $caption . '</p>';
		        }

		    	if ( $link !== 'none' ) {
		    		$output .= '</a>';
		    	}

		    $output .= '</div>';

	    } else {

	    	$output .= '<div class="calafate-gallery--item">';

		    	if ( $link !== 'none' ) {
		    		$output .= '<a class="fancybox fancybox-thumb" data-fancybox-group="gallery-' . $instance . '" data-fancybox-title="' . $caption . '" href="' . esc_url( $img_url[0] ) . '">';
		    	}

		    		$output .= '<img src="' . esc_url( $img[0] ) . '" title="' . esc_attr( $title ) . '" alt="' . esc_attr( $alt ) . '" />';

		    	if ( $link !== 'none' ) {
		    		$output .= '</a>';
		    	}

		    $output .= '</div>';

		    }

		}

		if ( $type == 'slider' ) {

	    $html = '<div class="carousel calafate-slider ' . $css_class . '">' . $output . '</div>';

		} else {

	    $html = '<div class="calafate-gallery columns-' . $columns . ' ' . $css_class . '">' . $output . '</div>';

		}

		return $html;

	}

endif;

remove_shortcode( 'gallery', 'gallery_shortcode' );
add_shortcode( 'gallery', 'calafate_gallery_shortcode' );
