<?php
/**
 * Template part for displaying grid article list in index.php.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Calafate
 */

global $blog_cols;

$columns = $blog_cols;
$project_size = calafate_get_field( 'post_feature' ) ? calafate_get_field( 'post_feature' ) : 1;
$portfolio_type = 'Flexible';
$portfolio_aspect_ratio = array(1, 1);

?>

	<?php if ( $project_size === 'banner' ) : ?>

		<?php calafate_post_stamp( $post->ID ); ?>

	<?php else : ?>

		<article id="post-<?php the_ID(); ?>" <?php post_class( 'entry-portfolio uninit' ); ?> data-size="<?php echo $project_size; ?>" itemscope itemtype="http://schema.org/Article">

			<a class="ajax-link button" href="<?php the_permalink(); ?>" itemprop="url">

				<figure class="entry-thumbnail <?php echo ! has_post_thumbnail() ? 'no-image' : ''; ?>">

					<?php 

						$image = wp_get_attachment_url( get_post_thumbnail_id() );
						$img = calafate_portfolio_images( $portfolio_type, $portfolio_aspect_ratio, $project_size, $columns, $image );

					?>

					<div class="entry-thumbnail-holder" style="padding-top: <?php echo floatval( $img[2] ); ?>%" data-padding="<?php echo floatval( $img[2] ); ?>">
						
						<img class="lazyload" data-srcset="<?php echo esc_attr( $img[0] ); ?>" srcset="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7" src="<?php echo esc_url( $img[1] ); ?>" itemprop="image" alt="<?php the_title_attribute(); ?>" title="<?php the_title_attribute(); ?>" data-sizes="auto" />

					</div>
					
				</figure>

				<header class="entry-caption">

					<div class="entry-neta">

						<time class="entry-grid__time" datetime="<?php the_time( 'c' ); ?>">
							<?php the_time( get_option( 'date_format' ) ); 	?>
						</time>

						<span class="entry-grid__category">
							<?php calafate_categories( $post->ID, 'category' ); ?>
						</span>
				
					</div>
				
						<h3 class="entry-sitle poppins" itemprop="name"><?php the_title(); ?></h3>

					</header>

			</a>

		</article><!-- #post-## -->

	<?php endif; ?>
