<?php
/**
 * Template part for displaying portfolio items.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Calafate
 */

global $columns, $gap, $portfolio_type, $portfolio_aspect_ratio, $portfolio_style;

$project_size = calafate_get_field( 'project-size' ) ? calafate_get_field( 'project-size' ) : 1;
if ( $project_size > $columns )
	$project_size = $columns;
if ( $portfolio_type != 'Flexible' ) 
	$project_size = 1;

$project_class = 'ajax-link';
$project_href = get_the_permalink();

// Since 1.0.2

$project_lightbox = calafate_get_field( 'portfolio-lightbox-type' );

$project_target = '';

if ( $project_lightbox ) {

	if ( $project_lightbox === 'img' ) {
		$project_class = 'fancybox fancybox-group';
		$project_href = calafate_get_field( 'portfolio-lightbox-url' );
	} else if ( $project_lightbox === 'iframe' ) {
		$project_class = 'fancybox fancybox-group';
		$project_href = calafate_get_field( 'portfolio-lightbox-url' );
	} else if ( $project_lightbox === 'url' ) {
		$project_class = 'no-ajax-link';
		$project_href = calafate_get_field( 'portfolio-lightbox-url' );
		$project_target = ' target="_self"';
	}

}

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'entry-portfolio uninit ' . calafate_categories( $post->ID, 'portfolio_category', ' ', 'slug', false ) . ' ' . $portfolio_style ); ?> data-size="<?php echo $project_size; ?>" itemscope itemtype="http://schema.org/CreativeWork">

	<a class="<?php echo $project_class; ?>" href="<?php echo esc_url( $project_href ); ?>" itemprop="url"<?php echo $project_target; ?>>

		<figure class="entry-thumbnail">

			<?php 
				
	 			if ( has_post_thumbnail() ) {
					$image = wp_get_attachment_url( get_post_thumbnail_id() );
					$img = calafate_portfolio_images( $portfolio_type, $portfolio_aspect_ratio, $project_size, $columns, $image );
	 			} else {
	 				$image = get_template_directory_uri() . '/images/blank-product.jpg';
					$img = calafate_portfolio_images( $portfolio_type, $portfolio_aspect_ratio, $project_size, $columns, $image, 1600, 1600 );
	 			}

			?>

			<div class="entry-thumbnail-holder" style="padding-top: <?php echo floatval( $img[2] ); ?>%" data-padding="<?php echo floatval( $img[2] ); ?>">
					
				<img class="primary lazyload" data-srcset="<?php echo esc_attr( $img[0] ); ?>" srcset="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7" src="<?php echo esc_url( $img[1] ); ?>" itemprop="image" alt="<?php the_title_attribute(); ?>" title="<?php the_title_attribute(); ?>" data-sizes="auto" />

				<?php 

					$image = wp_get_attachment_url( get_post_meta( $post->ID, 'portfolio_featured-thumbnail-secondary_thumbnail_id', true ) );

					if ( isset( $image ) && $image != '' ) :

						$img = calafate_portfolio_images( $portfolio_type, $portfolio_aspect_ratio, $project_size, $columns, $image );

					?>

						<img class="secondary lazyload" data-srcset="<?php echo esc_attr( $img[0] ); ?>" srcset="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7" src="<?php echo esc_url( $img[1] ); ?>" itemprop="image" alt="<?php the_title_attribute(); ?>" title="<?php the_title_attribute(); ?>" data-sizes="auto" />

					<?php endif; 

				?>

			</div>
			
		</figure>

		<header class="entry-caption <?php echo esc_attr( $portfolio_style ); ?>">
			<div class="display--table">
				<div class="entry-caption-content display--table-cell">
					<div class="entry-caption-text">
						<span class="entry-meta"><?php calafate_categories( $post->ID, 'portfolio_category' ); ?></span>
						<h3 class="entry-title poppins" itemprop="name"><?php the_title(); ?></h3>
					</div>
				</div>
			</div>
		</header>

		<?php echo calafate_output_hero_header_image_for_preload( $post->ID ); ?>

	</a>

</article><!-- #post-## -->