<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

new \Kirki\Field\Radio_Buttonset(
	array(
		'settings'  => 'footer_container',
		'label'     => esc_html__( 'Container', 'cassio' ),
		'section'   => 'footer_options',
		'default'   => 'container-fluid',
		'priority'  => $priority++,
		'choices'   => array(
			'container-fluid' => esc_html__( 'Fullwidth', 'cassio' ),
			'container'       => esc_html__( 'Boxed', 'cassio' ),
		),
		'transport' => 'postMessage',
	)
);

new \Kirki\Field\Select(
	array(
		'settings'  => 'footer_theme',
		'label'     => esc_html__( 'Color Theme', 'cassio' ),
		'section'   => 'footer_options',
		'default'   => 'bg-light',
		'priority'  => $priority++,
		'choices'   => ARTS_THEME_COLORS_ARRAY,
		'transport' => 'postMessage',
		'tooltip'   => esc_html__( 'This option may be overriden for the current page from Elementor document settings.', 'cassio' ),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'  => 'footer_logo',
		'label'     => esc_html__( 'Logo to Display', 'cassio' ),
		'section'   => 'footer_options',
		'default'   => 'primary',
		'priority'  => $priority++,
		'choices'   => array(
			'primary'   => esc_html__( 'Primary', 'cassio' ),
			'secondary' => esc_html__( 'Secondary', 'cassio' ),
		),
		'transport' => 'postMessage',
		'tooltip'   => esc_html__( 'This option may be overriden for the current page from Elementor document settings.', 'cassio' ),
	)
);

new \Kirki\Field\Checkbox_Switch(
	array(
		'settings'  => 'enable_footer_border_primary',
		'label'     => esc_html__( 'Enable Upper Section Divider', 'cassio' ),
		'section'   => 'footer_options',
		'default'   => false,
		'priority'  => $priority++,
		'transport' => 'postMessage',
		'tooltip'   => esc_html__( 'This option may be overriden for the current page from Elementor document settings.', 'cassio' ),
	)
);

new \Kirki\Field\Checkbox_Switch(
	array(
		'settings'  => 'enable_footer_border_secondary',
		'label'     => esc_html__( 'Enable Lower Section Divider', 'cassio' ),
		'section'   => 'footer_options',
		'default'   => true,
		'priority'  => $priority++,
		'transport' => 'postMessage',
		'tooltip'   => esc_html__( 'This option may be overriden for the current page from Elementor document settings.', 'cassio' ),
	)
);
