<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority    = 1;
$max_columns = 4;
$suffix      = '_lower';

/**
 * Footer Layout
 */
new \Kirki\Field\Slider(
	array(
		'settings'    => 'footer_columns' . $suffix,
		'label'       => esc_html__( 'Number of Columns', 'cassio' ),
		'description' => sprintf(
			'%1$s <a href="javascript:wp.customize.panel(\'widgets\').focus();">%2$s</a>',
			esc_html__( 'This setting creates a widget area per each column. You can edit your widgets from', 'cassio' ),
			esc_html__( 'Widgets panel.', 'cassio' )
		),
		'section'     => 'section_footer' . $suffix,
		'default'     => 4,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 1,
			'max'  => $max_columns,
			'step' => 1,
		),
		'transport'   => 'refresh',
	)
);

/**
 * Mobile Ordering Info
 */
new \Kirki\Field\Custom(
	array(
		'settings'        => 'footer_columns_info' . $suffix,
		'label'           => esc_html__( 'Mobile Columns Stack Order', 'cassio' ),
		'description'     => esc_html__( 'You can control how your columns stack on mobile screens. For example, you can place copyright column very first on desktop and reorder it as very last on mobile.', 'cassio' ),
		'section'         => 'section_footer' . $suffix,
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => 'footer_columns' . $suffix,
				'operator' => '>',
				'value'    => 1,
			),
		),
	)
);

/**
 * Mobile Column Order
 */

for ( $i = 1; $i <= $max_columns; $i++ ) {
	$descr = sprintf( '%1$s (%2$s %3$s)', esc_html__( 'Mobile Order', 'cassio' ), esc_html__( 'Column', 'cassio' ), $i );

	new \Kirki\Field\Slider(
		array(
			'settings'        => 'order_column_' . $i . $suffix,
			'description'     => $descr,
			'section'         => 'section_footer' . $suffix,
			'default'         => 1,
			'priority'        => $priority++,
			'choices'         => array(
				'min'  => 1,
				'max'  => $max_columns,
				'step' => 1,
			),
			'active_callback' => array(
				array(
					'setting'  => 'footer_columns' . $suffix,
					'operator' => '>=',
					'value'    => $i,
				),
				array(
					'setting'  => 'footer_columns' . $suffix,
					'operator' => '!=',
					'value'    => 1,
				),
			),
		)
	);

}
