<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

/**
 * On-scroll
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'On-scroll', 'cassio' ),
		'settings' => 'animation_generic_heading' . $priority,
		'section'  => 'animation',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Number(
	array(
		'settings'    => 'smc_trigger_hook',
		'description' => esc_html__( 'Trigger hook', 'cassio' ),
		'tooltip'     => esc_html__( 'A float value between 0.0 and 1.0 defining the position of the trigger hook in relation to the viewport.', 'cassio' ),
		'section'     => 'animation',
		'default'     => 0.85,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 1,
			'step' => 0.01,
		),
	)
);

new \Kirki\Field\Number(
	array(
		'settings'    => 'animation_on_scroll_reveal_timescale',
		'description' => esc_html__( 'Reveal transition timescale (speed multiplier)', 'cassio' ),
		'tooltip'     => esc_html__( 'A float value - speed multiplier. 1.0 = default speed. 0.5 = half speed. 2.0 = double speed', 'cassio' ),
		'section'     => 'animation',
		'default'     => 1.0,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0.5,
			'max'  => 3.0,
			'step' => 0.01,
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'settings' => 'animation_generic_divider' . $priority,
		'section'  => 'animation',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'hr',
		),
	)
);

/**
 * AJAX Transitions
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'AJAX Transitions', 'cassio' ),
		'settings' => 'animation_generic_heading' . $priority,
		'section'  => 'animation',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Number(
	array(
		'settings'    => 'animation_flying_headings_stagger',
		'description' => esc_html__( 'Flying headings stagger', 'cassio' ),
		'tooltip'     => esc_html__( 'A float value between 0.0 and 1.0 defining the micro delay between letters animation.', 'cassio' ),
		'section'     => 'animation',
		'default'     => 0.15,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 0.5,
			'step' => 0.01,
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'settings' => 'animation_generic_divider' . $priority,
		'section'  => 'animation',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'hr',
		),
	)
);

/**
 * Overlay Menu
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'Overlay Menu', 'cassio' ),
		'settings' => 'animation_generic_heading' . $priority,
		'section'  => 'animation',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Number(
	array(
		'settings'    => 'animation_overlay_menu_open_timescale',
		'description' => esc_html__( 'Open transition timescale', 'cassio' ),
		'tooltip'     => esc_html__( 'A float value - speed multiplier. 1.0 = default speed. 0.5 = half speed. 2.0 = double speed', 'cassio' ),
		'section'     => 'animation',
		'default'     => 1.0,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0.5,
			'max'  => 3.0,
			'step' => 0.01,
		),
	)
);

new \Kirki\Field\Number(
	array(
		'settings'    => 'animation_overlay_menu_close_timescale',
		'description' => esc_html__( 'Close transition timescale', 'cassio' ),
		'tooltip'     => esc_html__( 'A float value - speed multiplier. 1.0 = default speed. 0.5 = half speed. 2.0 = double speed', 'cassio' ),
		'section'     => 'animation',
		'default'     => 1.5,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0.5,
			'max'  => 3.0,
			'step' => 0.01,
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'settings' => 'animation_generic_divider' . $priority,
		'section'  => 'animation',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'hr',
		),
	)
);

/**
 * Preloader
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'Preloader', 'cassio' ),
		'settings' => 'animation_generic_heading' . $priority,
		'section'  => 'animation',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Number(
	array(
		'settings'    => 'animation_preloader_timescale',
		'description' => esc_html__( 'Transition timescale', 'cassio' ),
		'tooltip'     => esc_html__( 'A float value - speed multiplier. 1.0 = default speed. 0.5 = half speed. 2.0 = double speed', 'cassio' ),
		'section'     => 'animation',
		'default'     => 0.9,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0.5,
			'max'  => 3.0,
			'step' => 0.01,
		),
	)
);
