<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

/**
 * Primary Accents
 */
new \Kirki\Field\Color(
	array(
		'section'     => 'colors',
		'description' => esc_html__( 'Primary Accent 1', 'cassio' ),
		'default'     => '#c69f73',
		'settings'    => 'color_accent_primary_1',
		'priority'    => $priority ++,
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--color-accent-primary-1',
			),
		),
	)
);

new \Kirki\Field\Color(
	array(
		'section'     => 'colors',
		'description' => esc_html__( 'Primary Accent 2', 'cassio' ),
		'default'     => '#ebe6dd',
		'settings'    => 'color_accent_primary_2',
		'priority'    => $priority ++,
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--color-accent-primary-2',
			),
		),
	)
);

new \Kirki\Field\Color(
	array(
		'section'     => 'colors',
		'description' => esc_html__( 'Primary Accent 3', 'cassio' ),
		'default'     => '#c9bcae',
		'settings'    => 'color_accent_primary_3',
		'priority'    => $priority ++,
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--color-accent-primary-3',
			),
		),
	)
);

new \Kirki\Field\Color(
	array(
		'section'     => 'colors',
		'description' => esc_html__( 'Primary Accent 4', 'cassio' ),
		'default'     => '#837567',
		'settings'    => 'color_accent_primary_4',
		'priority'    => $priority ++,
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--color-accent-primary-4',
			),
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'settings' => 'colors_generic_divider' . $priority,
		'section'  => 'colors',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'hr',
		),
	)
);

/**
 * Secondary Accents
 */
new \Kirki\Field\Color(
	array(
		'section'     => 'colors',
		'description' => esc_html__( 'Secondary Accent 1', 'cassio' ),
		'default'     => '#628ab2',
		'settings'    => 'color_accent_secondary_1',
		'priority'    => $priority ++,
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--color-accent-secondary-1',
			),
		),
	)
);

new \Kirki\Field\Color(
	array(
		'section'     => 'colors',
		'description' => esc_html__( 'Secondary Accent 2', 'cassio' ),
		'default'     => '#3c556e',
		'settings'    => 'color_accent_secondary_2',
		'priority'    => $priority ++,
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--color-accent-secondary-2',
			),
		),
	)
);

new \Kirki\Field\Color(
	array(
		'section'     => 'colors',
		'description' => esc_html__( 'Secondary Accent 3', 'cassio' ),
		'default'     => '#283847',
		'settings'    => 'color_accent_secondary_3',
		'priority'    => $priority ++,
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--color-accent-secondary-3',
			),
		),
	)
);

new \Kirki\Field\Color(
	array(
		'section'     => 'colors',
		'description' => esc_html__( 'Secondary Accent 4', 'cassio' ),
		'default'     => '#162330',
		'settings'    => 'color_accent_secondary_4',
		'priority'    => $priority ++,
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--color-accent-secondary-4',
			),
		),
	)
);
