<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

new \Kirki\Field\Repeater(
	array(
		'label'        => esc_html__( 'Social Media', 'cassio' ),
		'section'      => 'social',
		'priority'     => $priority++,
		'row_label'    => array(
			'type'  => 'field',
			'value' => esc_html__( 'Social Media', 'cassio' ),
			'field' => 'social_icon',
		),
		'button_label' => esc_html__( 'Add new Social Media ', 'cassio' ),
		'settings'     => 'social_links',
		'fields'       => array(
			'social_icon' => array(
				'type'    => 'select',
				'label'   => esc_html__( 'Social Icon', 'cassio' ),
				'default' => 'fa fa-facebook-f fa-fw',
				'choices' => apply_filters(
					'arts/customizer/social_links/icons',
					array(
						'fa fa-facebook-f fa-fw'  => esc_html__( 'Facebook', 'cassio' ),
						'fa fa-twitter fa-fw'     => esc_html__( 'Twitter', 'cassio' ),
						'fa fa-instagram fa-fw'   => esc_html__( 'Instagram', 'cassio' ),
						'fa fa-linkedin fa-fw'    => esc_html__( 'LinkedIn', 'cassio' ),
						'fa fa-google-plus fa-fw' => esc_html__( 'Google Plus', 'cassio' ),
						'fa fa-vk fa-fw'          => esc_html__( 'VK', 'cassio' ),
						'fa fa-youtube fa-fw'     => esc_html__( 'YouTube', 'cassio' ),
						'fa fa-vimeo fa-fw'       => esc_html__( 'Vimeo', 'cassio' ),
						'fa fa-dribbble fa-fw'    => esc_html__( 'Dribbble', 'cassio' ),
						'fa fa-pinterest fa-fw'   => esc_html__( 'Pinterest', 'cassio' ),
						'fa fa-behance fa-fw'     => esc_html__( 'Behance', 'cassio' ),
						'fa fa-flickr fa-fw'      => esc_html__( 'Flickr', 'cassio' ),
						'fa fa-tumblr fa-fw'      => esc_html__( 'Tumblr', 'cassio' ),
						'fa fa-vine fa-fw'        => esc_html__( 'Vine', 'cassio' ),
						'fa fa-github fa-fw'      => esc_html__( 'Github', 'cassio' ),
						'fa fa-soundcloud fa-fw'  => esc_html__( 'SoundCloud', 'cassio' ),
						'fa fa-telegram fa-fw'    => esc_html__( 'Telegram', 'cassio' ),
						'fa fa-medium fa-fw'      => esc_html__( 'Medium', 'cassio' ),
						'fa fa-skype fa-fw'       => esc_html__( 'Skype', 'cassio' ),
						'fa fa-whatsapp fa-fw'    => esc_html__( 'WhatsApp', 'cassio' ),
						'fa fa-slack fa-fw'       => esc_html__( 'Slack', 'cassio' ),
						'fa fa-tiktok fa-fw'      => esc_html__( 'TikTok', 'cassio' ),
					)
				),
			),
			'social_url'  => array(
				'type'  => 'link',
				'label' => esc_html__( 'Social URL', 'cassio' ),
			),
		),
	)
);
