<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

/**
 * 404 Preview Link
 */
new \Kirki\Field\Generic(
	array(
		'settings' => '404_preview_link',
		'label'    => esc_html__( 'Preview', 'cassio' ),
		'section'  => '404',
		'priority' => $priority++,
		'default'  => esc_html__( 'Load Page', 'cassio' ),
		'choices'  => array(
			'element' => 'input',
			'type'    => 'button',
			'class'   => 'button button-secondary',
			'onclick' => 'javascript:wp.customize.previewer.previewUrl.set( "../not-found-" + String( Math.random() ) + "/" );',
		),
	)
);

new \Kirki\Field\Radio_Buttonset(
	array(
		'settings'  => '404_background',
		'label'     => esc_html__( 'Background', 'cassio' ),
		'section'   => '404',
		'default'   => 'bg-ornament',
		'priority'  => $priority++,
		'choices'   => array(
			''            => esc_html__( 'None', 'cassio' ),
			'bg-ornament' => esc_html__( 'Ornament', 'cassio' ),
		),
		'transport' => 'postMessage',
	)
);

new \Kirki\Field\Select(
	array(
		'settings'  => '404_theme',
		'label'     => esc_html__( 'Color Theme', 'cassio' ),
		'section'   => '404',
		'default'   => 'bg-light',
		'priority'  => $priority++,
		'transport' => 'postMessage',
		'choices'   => ARTS_THEME_COLORS_ARRAY,
	)
);

/**
 * 404 Title
 */
new \Kirki\Field\Text(
	array(
		'settings'  => '404_title',
		'label'     => esc_html__( 'Title', 'cassio' ),
		'section'   => '404',
		'default'   => esc_html__( 'Page not Found', 'cassio' ),
		'priority'  => $priority++,
		'transport' => 'postMessage',
	)
);

/**
 * 404 Message
 */
new \Kirki\Field\Textarea(
	array(
		'settings'  => '404_message',
		'label'     => esc_html__( 'Message', 'cassio' ),
		'section'   => '404',
		'default'   => esc_html__( 'It looks like nothing found here. Try to navigate the menu or return to the home page.', 'cassio' ),
		'priority'  => $priority++,
		'transport' => 'postMessage',
	)
);

/**
 * 404 Button
 */
new \Kirki\Field\Text(
	array(
		'settings'  => '404_button',
		'label'     => esc_html__( 'Button Text', 'cassio' ),
		'section'   => '404',
		'default'   => esc_html__( 'Back to home page', 'cassio' ),
		'priority'  => $priority++,
		'transport' => 'postMessage',
	)
);

/**
 * 404 Button Theme
 */
new \Kirki\Field\Select(
	array(
		'settings'  => '404_button_theme',
		'label'     => esc_html__( 'Button Color Theme', 'cassio' ),
		'section'   => '404',
		'default'   => 'bg-accent-primary-3',
		'priority'  => $priority++,
		'transport' => 'postMessage',
		'choices'   => ARTS_THEME_COLORS_ARRAY,
	)
);
