<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use \Arts\Utilities\Utilities;

$priority = 1;

new \Kirki\Field\Checkbox_Switch(
	array(
		'settings' => 'enable_ajax',
		'label'    => esc_html__( 'Enable Seamless AJAX Transitions', 'cassio' ),
		'section'  => 'ajax_transitions',
		'default'  => false,
		'priority' => $priority++,
	)
);

/**
 * AJAX Loading Spinner
 */
new \Kirki\Field\Generic(
	array(
		'label'           => esc_html__( 'AJAX Loading Spinner', 'cassio' ),
		'settings'        => 'ajax_generic_heading' . $priority,
		'section'         => 'ajax_transitions',
		'priority'        => $priority++,
		'choices'         => array(
			'element' => 'span',
		),
		'active_callback' => array(
			array(
				'setting'  => 'enable_ajax',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Checkbox(
	array(
		'settings'        => 'enable_spinner_desktop',
		'label'           => esc_html__( 'Enable on desktops', 'cassio' ),
		'section'         => 'ajax_transitions',
		'default'         => false,
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => 'enable_ajax',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Checkbox(
	array(
		'settings'        => 'enable_spinner_mobile',
		'label'           => esc_html__( 'Enable on mobiles', 'cassio' ),
		'section'         => 'ajax_transitions',
		'default'         => true,
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => 'enable_ajax',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'settings' => 'ajax_transitions_generic_divider' . $priority,
		'section'  => 'ajax_transitions',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'hr',
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'        => 'ajax_curtain_color',
		'label'           => esc_html__( 'Curtain Color', 'cassio' ),
		'section'         => 'ajax_transitions',
		'default'         => 'bg-off-white',
		'priority'        => $priority++,
		'choices'         => ARTS_THEME_COLORS_ARRAY,
		'tooltip'         => esc_html__( 'This option may be overriden for the current page from Elementor document settings.', 'cassio' ),
		'active_callback' => array(
			array(
				'setting'  => 'enable_ajax',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'settings' => 'ajax_transitions_generic_divider' . $priority,
		'section'  => 'ajax_transitions',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'hr',
		),
	)
);

new \Kirki\Field\Textarea(
	array(
		'settings'        => 'ajax_prevent_rules',
		'label'           => esc_html__( 'Prevent elements from being AJAX triggered', 'cassio' ),
		'description'     => esc_html__( 'jQuery selectors separated by comma. Example: [data-elementor-open-lightbox], .myPreventClass', 'cassio' ),
		'section'         => 'ajax_transitions',
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => 'enable_ajax',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

if ( class_exists( 'woocommerce' ) ) {
	new \Kirki\Field\Checkbox(
		array(
			'settings'        => 'ajax_prevent_woocommerce_pages',
			'label'           => esc_html__( 'Prevent WooCommerce Pages', 'cassio' ),
			'section'         => 'ajax_transitions',
			'default'         => false,
			'priority'        => $priority++,
			'active_callback' => array(
				array(
					'setting'  => 'enable_ajax',
					'operator' => '==',
					'value'    => true,
				),
			),
		)
	);

	new \Kirki\Field\Generic(
		array(
			'description'     => sprintf(
				'%1s:<br><br><strong>%2s</strong>',
				esc_html__( 'WooCommerce pages with the following URL base will be excluded from AJAX transitions', 'cassio' ),
				implode( '<br>', Utilities::get_woocommerce_urls() )
			),
			'settings'        => 'ajax_transitions_generic_heading' . $priority,
			'section'         => 'ajax_transitions',
			'priority'        => $priority++,
			'choices'         => array(
				'element' => 'span',
			),
			'active_callback' => array(
				array(
					'setting'  => 'enable_ajax',
					'operator' => '==',
					'value'    => true,
				),
				array(
					'setting'  => 'ajax_prevent_woocommerce_pages',
					'operator' => '==',
					'value'    => true,
				),
			),
		)
	);
}

new \Kirki\Field\Generic(
	array(
		'settings'        => 'ajax_transitions_generic_divider' . $priority,
		'section'         => 'ajax_transitions',
		'priority'        => $priority++,
		'choices'         => array(
			'element' => 'hr',
		),
		'active_callback' => array(
			array(
				'setting'  => 'enable_ajax',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Code(
	array(
		'settings'        => 'custom_js_init',
		'label'           => esc_html__( 'Eval Custom JavaScript', 'cassio' ),
		'description'     => esc_html__( 'The code inserted below will be executed after each AJAX transition.', 'cassio' ),
		'tooltip'         => esc_html__( 'Useful for adding the frontend compatibility with 3rd party scripts. Please check theme documentation to learn more.', 'cassio' ),
		'section'         => 'ajax_transitions',
		'priority'        => $priority++,
		'choices'         => array(
			'language' => 'js',
		),
		'active_callback' => array(
			array(
				'setting'  => 'enable_ajax',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Textarea(
	array(
		'settings'        => 'ajax_update_script_nodes',
		'label'           => esc_html__( 'Update Page Script Nodes', 'cassio' ),
		'description'     => esc_html__( 'jQuery selectors separated by comma. Only exact ID selectors are supported. Example: script[id="theplus-front-js-js"]', 'cassio' ),
		'tooltip'         => esc_html__( 'Useful for adding the frontend compatibility with 3rd party scripts which require a page reload to function properly.', 'cassio' ),
		'section'         => 'ajax_transitions',
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => 'enable_ajax',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Checkbox(
	array(
		'settings'        => 'ajax_load_missing_scripts',
		'label'           => esc_html__( 'Load Missing Scripts from the Next Page', 'cassio' ),
		'tooltip'         => esc_html__( 'Pontentially this may bring AJAX compatibility to the plugins which place their JS assets on-demand (only when the certain plugin\'s functionality or widget is used)', 'cassio' ),
		'section'         => 'ajax_transitions',
		'default'         => false,
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => 'enable_ajax',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Checkbox(
	array(
		'settings'        => 'ajax_eval_inline_container_scripts',
		'label'           => esc_html__( 'Eval Inline JavaScript in Content Area', 'cassio' ),
		'tooltip'         => esc_html__( 'Pontentially this may bring AJAX compatibility to the plugins which inject their JavaScript code right into HTML of the content area. E.g. Slider Revolution plugin.', 'cassio' ),
		'section'         => 'ajax_transitions',
		'default'         => false,
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => 'enable_ajax',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'settings'        => 'ajax_transitions_generic_divider' . $priority,
		'section'         => 'ajax_transitions',
		'priority'        => $priority++,
		'choices'         => array(
			'element' => 'hr',
		),
		'active_callback' => array(
			array(
				'setting'  => 'enable_ajax',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Textarea(
	array(
		'settings'        => 'custom_js_head_nodes',
		'label'           => esc_html__( 'Update Page Head Nodes', 'cassio' ),
		'description'     => esc_html__( 'jQuery selectors separated by comma. Example: link[id*="eael"], style[id*="theplus-"]', 'cassio' ),
		'tooltip'         => esc_html__( 'Useful for adding the frontend compatibility with 3rd party styles. Please check theme documentation to learn more.', 'cassio' ),
		'section'         => 'ajax_transitions',
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => 'enable_ajax',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Checkbox(
	array(
		'settings'        => 'ajax_load_missing_styles',
		'label'           => esc_html__( 'Load Missing Styles from the Next Page', 'cassio' ),
		'tooltip'         => esc_html__( 'Pontentially this may bring AJAX compatibility to the plugins which place their CSS assets on-demand (only when the certain plugin\'s functionality or widget is used)', 'cassio' ),
		'section'         => 'ajax_transitions',
		'default'         => false,
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => 'enable_ajax',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);
