<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

new \Kirki\Field\Checkbox_Switch(
	array(
		'settings' => 'enable_master_audio_background',
		'label'    => esc_html__( 'Enable Audio Background', 'cassio' ),
		'section'  => 'audio_background',
		'default'  => false,
		'priority' => $priority++,
	)
);

new \Kirki\Field\Upload(
	array(
		'settings'        => 'master_audio_background',
		'label'           => esc_html__( 'Global Audio Background', 'cassio' ),
		'description'     => esc_html__( 'Upload *.mp3, *.wav, *.ogg audio file', 'cassio' ),
		'section'         => 'audio_background',
		'default'         => '',
		'priority'        => $priority++,
		'choices'         => array(
			'save_as' => 'url',
		),
		'active_callback' => array(
			array(
				'setting'  => 'enable_master_audio_background',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Checkbox(
	array(
		'settings'        => 'enable_master_audio_background_loop',
		'label'           => esc_html__( 'Enable Loop', 'cassio' ),
		'section'         => 'audio_background',
		'default'         => true,
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => 'enable_master_audio_background',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Checkbox(
	array(
		'settings'        => 'enable_master_audio_background_autoplay',
		'label'           => esc_html__( 'Enable Autoplay', 'cassio' ),
		'section'         => 'audio_background',
		'default'         => true,
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => 'enable_master_audio_background',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'label'           => esc_html__( 'Volume', 'cassio' ),
		'settings'        => 'master_audio_background_volume',
		'section'         => 'audio_background',
		'transport'       => 'postMessage',
		'default'         => 50,
		'priority'        => $priority++,
		'choices'         => array(
			'min'  => 0,
			'max'  => 100,
			'step' => 1,
		),
		'active_callback' => array(
			array(
				'setting'  => 'enable_master_audio_background',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'settings'        => 'audio_background_generic_divider' . $priority,
		'section'         => 'audio_background',
		'priority'        => $priority++,
		'choices'         => array(
			'element' => 'hr',
		),
		'active_callback' => array(
			array(
				'setting'  => 'enable_master_audio_background',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'label'           => esc_html__( 'Player', 'cassio' ),
		'settings'        => 'audio_background_generic_heading' . $priority,
		'section'         => 'audio_background',
		'priority'        => $priority++,
		'choices'         => array(
			'element' => 'span',
		),
		'active_callback' => array(
			array(
				'setting'  => 'enable_master_audio_background',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Radio_Buttonset(
	array(
		'settings'        => 'master_audio_player_position',
		'description'     => esc_html__( 'Position', 'cassio' ),
		'section'         => 'audio_background',
		'default'         => 'header',
		'priority'        => $priority++,
		'choices'         => array(
			'off'    => esc_html__( 'Hidden', 'cassio' ),
			'header' => esc_html__( 'Page Header', 'cassio' ),
		),
		'active_callback' => array(
			array(
				'setting'  => 'enable_master_audio_background',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'description'     => esc_html__( 'Please note that the visitors won\'t be able to control background music on the website!', 'cassio' ),
		'settings'        => 'audio_background_generic_heading' . $priority,
		'section'         => 'audio_background',
		'priority'        => $priority++,
		'choices'         => array(
			'element' => 'span',
		),
		'active_callback' => array(
			array(
				'setting'  => 'enable_master_audio_background',
				'operator' => '==',
				'value'    => true,
			),
			array(
				'setting'  => 'master_audio_player_position',
				'operator' => '==',
				'value'    => 'off',
			),
		),
	)
);

new \Kirki\Field\Text(
	array(
		'settings'        => 'master_audio_player_label_playing',
		'description'     => esc_html__( 'Playing Label', 'cassio' ),
		'section'         => 'audio_background',
		'default'         => esc_html__( 'Sound on', 'cassio' ),
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => 'enable_master_audio_background',
				'operator' => '==',
				'value'    => true,
			),
			array(
				'setting'  => 'master_audio_player_position',
				'operator' => '!=',
				'value'    => 'off',
			),
		),
	)
);

new \Kirki\Field\Text(
	array(
		'settings'        => 'master_audio_player_icon_playing',
		'description'     => sprintf(
			'%1s <a href="https://material.io/resources/icons/" target="_blank">%2s</a>',
			esc_html__( 'Playing icon from', 'cassio' ),
			esc_html__( 'Material Icons', 'cassio' )
		),
		'section'         => 'audio_background',
		'default'         => 'pause',
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => 'enable_master_audio_background',
				'operator' => '==',
				'value'    => true,
			),
			array(
				'setting'  => 'master_audio_player_position',
				'operator' => '!=',
				'value'    => 'off',
			),
		),
	)
);

new \Kirki\Field\Text(
	array(
		'settings'        => 'master_audio_player_label_paused',
		'description'     => esc_html__( 'Paused Label', 'cassio' ),
		'section'         => 'audio_background',
		'default'         => esc_html__( 'Sound off', 'cassio' ),
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => 'enable_master_audio_background',
				'operator' => '==',
				'value'    => true,
			),
			array(
				'setting'  => 'master_audio_player_position',
				'operator' => '!=',
				'value'    => 'off',
			),
		),
	)
);

new \Kirki\Field\Text(
	array(
		'settings'        => 'master_audio_player_icon_paused',
		'description'     => sprintf(
			'%1s <a href="https://material.io/resources/icons/" target="_blank">%2s</a>',
			esc_html__( 'Paused icon from', 'cassio' ),
			esc_html__( 'Material Icons', 'cassio' )
		),
		'section'         => 'audio_background',
		'default'         => 'play_arrow',
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => 'enable_master_audio_background',
				'operator' => '==',
				'value'    => true,
			),
			array(
				'setting'  => 'master_audio_player_position',
				'operator' => '!=',
				'value'    => 'off',
			),
		),
	)
);
