<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

new \Kirki\Field\Checkbox_Switch(
	array(
		'settings'    => 'full_size_images_enabled',
		'label'       => esc_html__( 'Force Load Full Size Images', 'cassio' ),
		'description' => esc_html__( 'Always use the original images uploaded to media library and don\'t use the sets of WordPress generated thumbnails.', 'cassio' ),
		'section'     => 'lazy_images',
		'default'     => false,
		'priority'    => $priority++,
	)
);

new \Kirki\Field\Radio_Buttonset(
	array(
		'settings'    => 'lazy_placeholder_type',
		'label'       => esc_html__( 'Lazy Placeholder', 'cassio' ),
		'description' => esc_html__( 'Temporary lightweight image that appears before a lazy image is fully loaded.', 'cassio' ),
		'section'     => 'lazy_images',
		'default'     => 'inline',
		'priority'    => $priority++,
		'choices'     => array(
			'inline'       => esc_html__( 'Inline Source', 'cassio' ),
			'custom_image' => esc_html__( 'Custom Image', 'cassio' ),
		),
	)
);

new \Kirki\Field\Textarea(
	array(
		'settings'        => 'lazy_placeholder_inline',
		'description'     => esc_html__( 'Base64 encoded image or external URL that will be appended to <img src="..."> attribute.', 'cassio' ),
		'section'         => 'lazy_images',
		'default'         => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAHCGzyUAAAABGdBTUEAALGPC/xhBQAAADhlWElmTU0AKgAAAAgAAYdpAAQAAAABAAAAGgAAAAAAAqACAAQAAAABAAAAAaADAAQAAAABAAAAAQAAAADa6r/EAAAAC0lEQVQI12NolQQAASYAn89qhTcAAAAASUVORK5CYII=',
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting' => 'lazy_placeholder_type',
				'value'   => 'inline',
			),
		),
	)
);

new \Kirki\Field\Image(
	array(
		'settings'        => 'lazy_placeholder_image_url',
		'section'         => 'lazy_images',
		'default'         => '',
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting' => 'lazy_placeholder_type',
				'value'   => 'custom_image',
			),
		),
	)
);
