<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

$lg = intval( get_option( 'elementor_viewport_lg', 992 ) );

/**
 * Buttons
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'Buttons', 'cassio' ),
		'settings' => 'buttons_generic_heading' . $priority,
		'section'  => 'buttons_typography',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'button_max_font_size',
		'description' => esc_html__( 'Desktop font size (px)', 'cassio' ),
		'section'     => 'buttons_typography',
		'default'     => 13,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 50,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--button-max-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'button_min_font_size',
		'description' => esc_html__( 'Mobile font size (px)', 'cassio' ),
		'section'     => 'buttons_typography',
		'default'     => 13,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 50,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--button-min-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'button_icon_max_font_size',
		'description' => esc_html__( 'Icon desktop size (px)', 'cassio' ),
		'section'     => 'buttons_typography',
		'default'     => 24,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 50,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--button-icon-max-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'button_icon_min_font_size',
		'description' => esc_html__( 'Icon mobile size (px)', 'cassio' ),
		'section'     => 'buttons_typography',
		'default'     => 20,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 50,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--button-icon-min-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'button_line_height',
		'description' => esc_html__( 'Line height (ratio)', 'cassio' ),
		'section'     => 'buttons_typography',
		'default'     => 1.8,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 10,
			'step' => 0.1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--button-line-height',
			),
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'    => 'button_font_weight',
		'description' => esc_html__( 'Font Weight', 'cassio' ),
		'section'     => 'buttons_typography',
		'default'     => 'bold',
		'priority'    => $priority++,
		'choices'     => array(
			'normal' => esc_html__( 'Normal', 'cassio' ),
			'bold'   => esc_html__( 'Bold', 'cassio' ),
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--button-font-weight',
			),
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'settings' => 'buttons_typography_generic_divider' . $priority,
		'section'  => 'buttons_typography',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'hr',
		),
	)
);

/**
 * Links
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'Links', 'cassio' ),
		'settings' => 'buttons_generic_heading' . $priority,
		'section'  => 'buttons_typography',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'link_max_font_size',
		'description' => esc_html__( 'Desktop font size (px)', 'cassio' ),
		'section'     => 'buttons_typography',
		'default'     => 13,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 50,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--link-max-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'link_min_font_size',
		'description' => esc_html__( 'Mobile font size (px)', 'cassio' ),
		'section'     => 'buttons_typography',
		'default'     => 13,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 50,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--link-min-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'link_icon_max_font_size',
		'description' => esc_html__( 'Icon desktop size (px)', 'cassio' ),
		'section'     => 'buttons_typography',
		'default'     => 20,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 50,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--link-icon-max-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'link_icon_min_font_size',
		'description' => esc_html__( 'Icon mobile size (px)', 'cassio' ),
		'section'     => 'buttons_typography',
		'default'     => 20,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 50,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--link-icon-min-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'link_line_height',
		'description' => esc_html__( 'Line height (ratio)', 'cassio' ),
		'section'     => 'buttons_typography',
		'default'     => 1.8,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 10,
			'step' => 0.1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--link-line-height',
			),
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'    => 'link_font_weight',
		'description' => esc_html__( 'Font Weight', 'cassio' ),
		'section'     => 'buttons_typography',
		'default'     => 'bold',
		'priority'    => $priority++,
		'choices'     => array(
			'normal' => esc_html__( 'Normal', 'cassio' ),
			'bold'   => esc_html__( 'Bold', 'cassio' ),
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--link-font-weight',
			),
		),
	)
);
