<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

/**
 * Menu Items
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'Menu Items', 'cassio' ),
		'settings' => 'menu_classic_generic_heading' . $priority,
		'section'  => 'menu_classic_typography',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'menu_classic_max_font_size',
		'description' => esc_html__( 'Desktop font size (px)', 'cassio' ),
		'section'     => 'menu_classic_typography',
		'default'     => 13,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 50,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--menu-classic-max-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'menu_classic_min_font_size',
		'description' => esc_html__( 'Mobile font size (px)', 'cassio' ),
		'section'     => 'menu_classic_typography',
		'default'     => 13,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 50,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--menu-classic-min-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'menu_classic_line_height',
		'description' => esc_html__( 'Line height (ratio)', 'cassio' ),
		'section'     => 'menu_classic_typography',
		'default'     => 1.8,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 10,
			'step' => 0.1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--menu-classic-line-height',
			),
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'    => 'menu_classic_font_weight',
		'description' => esc_html__( 'Font Weight', 'cassio' ),
		'section'     => 'menu_classic_typography',
		'default'     => 'normal',
		'priority'    => $priority++,
		'choices'     => array(
			'normal' => esc_html__( 'Normal', 'cassio' ),
			'bold'   => esc_html__( 'Bold', 'cassio' ),
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--menu-classic-font-weight',
			),
		),
	)
);
