<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

/**
 * Top Menu Items
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'Top Menu Items', 'cassio' ),
		'settings' => 'menu_overlay_generic_heading' . $priority,
		'section'  => 'menu_overlay_typography',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'menu_overlay_top_max_font_size',
		'description' => esc_html__( 'Desktop font size (px)', 'cassio' ),
		'section'     => 'menu_overlay_typography',
		'default'     => 42,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--menu-overlay-top-max-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'menu_overlay_top_min_font_size',
		'description' => esc_html__( 'Mobile font size (px)', 'cassio' ),
		'section'     => 'menu_overlay_typography',
		'default'     => 28,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--menu-overlay-top-min-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'menu_overlay_top_line_height',
		'description' => esc_html__( 'Line height (ratio)', 'cassio' ),
		'section'     => 'menu_overlay_typography',
		'default'     => 1.8,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 10,
			'step' => 0.1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--menu-overlay-top-line-height',
			),
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'    => 'menu_overlay_top_font_weight',
		'description' => esc_html__( 'Font Weight', 'cassio' ),
		'section'     => 'menu_overlay_typography',
		'default'     => 'bold',
		'priority'    => $priority++,
		'choices'     => array(
			'normal' => esc_html__( 'Normal', 'cassio' ),
			'bold'   => esc_html__( 'Bold', 'cassio' ),
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--menu-overlay-top-font-weight',
			),
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'settings' => 'menu_overlay_typography_generic_divider' . $priority,
		'section'  => 'menu_overlay_typography',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'hr',
		),
	)
);

/**
 * Sub Menu Items
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'Sub Menu Items', 'cassio' ),
		'settings' => 'menu_overlay_generic_heading' . $priority,
		'section'  => 'menu_overlay_typography',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'menu_overlay_sub_max_font_size',
		'description' => esc_html__( 'Desktop font size (px)', 'cassio' ),
		'section'     => 'menu_overlay_typography',
		'default'     => 26,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--menu-overlay-sub-max-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'menu_overlay_sub_min_font_size',
		'description' => esc_html__( 'Mobile font size (px)', 'cassio' ),
		'section'     => 'menu_overlay_typography',
		'default'     => 20,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--menu-overlay-sub-min-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'menu_overlay_sub_line_height',
		'description' => esc_html__( 'Line height (ratio)', 'cassio' ),
		'section'     => 'menu_overlay_typography',
		'default'     => 1.2,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 10,
			'step' => 0.1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--menu-overlay-sub-line-height',
			),
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'    => 'menu_overlay_sub_font_weight',
		'description' => esc_html__( 'Font Weight', 'cassio' ),
		'section'     => 'menu_overlay_typography',
		'default'     => 'bold',
		'priority'    => $priority++,
		'choices'     => array(
			'normal' => esc_html__( 'Normal', 'cassio' ),
			'bold'   => esc_html__( 'Bold', 'cassio' ),
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--menu-overlay-sub-font-weight',
			),
		),
	)
);
