<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

new \Kirki\Field\Slider(
	array(
		'settings'    => 'portfolio_nav_max_font_size',
		'description' => esc_html__( 'Desktop font size (px)', 'cassio' ),
		'section'     => 'prev_next_portfolio_nav',
		'default'     => 52,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--portfolio-prev-next-max-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'portfolio_nav_min_font_size',
		'description' => esc_html__( 'Mobile font size (px)', 'cassio' ),
		'section'     => 'prev_next_portfolio_nav',
		'default'     => 34,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--portfolio-prev-next-min-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'portfolio_nav_line_height',
		'description' => esc_html__( 'Line height (ratio)', 'cassio' ),
		'section'     => 'prev_next_portfolio_nav',
		'default'     => 1.3,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 10,
			'step' => 0.1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--portfolio-prev-next-line-height',
			),
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'    => 'portfolio_nav_font_weight',
		'description' => esc_html__( 'Font Weight', 'cassio' ),
		'section'     => 'prev_next_portfolio_nav',
		'default'     => 'bold',
		'priority'    => $priority++,
		'choices'     => array(
			'normal' => esc_html__( 'Normal', 'cassio' ),
			'bold'   => esc_html__( 'Bold', 'cassio' ),
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--portfolio-prev-next-font-weight',
			),
		),
	)
);
