<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use \Arts\Utilities\Utilities;

/**
 * Register theme locations for Elementor Theme Builder API
 */
add_action( 'elementor/theme/register_locations', 'arts_register_elementor_locations' );
if ( ! function_exists( 'arts_register_elementor_locations' ) ) {
	function arts_register_elementor_locations( $elementor_theme_manager ) {
		$elementor_theme_manager->register_location( 'header' );
		$elementor_theme_manager->register_location( 'footer' );
		$elementor_theme_manager->register_location( 'popup' );
		$elementor_theme_manager->register_location( 'single-post' );
		$elementor_theme_manager->register_location( 'single-page' );
	}
}

/**
 * Elementor Pro AJAX compatibility
 * Enforce widgets assets to load on all the pages
 */
add_action( 'elementor_pro/init', 'arts_enqueue_elementor_pro_widgets_assets' );
if ( ! function_exists( 'arts_enqueue_elementor_pro_widgets_assets' ) ) {
	function arts_enqueue_elementor_pro_widgets_assets() {
		$enable_ajax               = get_theme_mod( 'enable_ajax', false );
		$ajax_load_missing_scripts = get_theme_mod( 'ajax_load_missing_scripts', false );
		$ajax_load_missing_styles  = get_theme_mod( 'ajax_load_missing_styles', false );

		if ( $enable_ajax ) {

			// JS assets
			if ( ! $ajax_load_missing_scripts ) {
				add_action(
					'elementor/frontend/before_enqueue_scripts',
					function() {
						wp_enqueue_script( 'elementor-gallery' ); // Elementor Gallery
						wp_enqueue_script( 'lottie' ); // Elementor Lottie animations
					}
				);
			}

			// CSS assets
			if ( ! $ajax_load_missing_styles ) {
				add_action(
					'elementor/frontend/before_enqueue_styles',
					function() {
						wp_enqueue_style( 'elementor-gallery' ); // Elementor Gallery
					}
				);
			}
		}
	}
}

/**
 * BEFORE: Extra markup for Elementor Canvas template
 */
add_action( 'elementor/page_templates/canvas/before_content', 'arts_elementor_canvas_template_before' );
if ( ! function_exists( 'arts_elementor_canvas_template_before') ) {
	function arts_elementor_canvas_template_before() {
		$arts_page_header_settings     = Utilities::get_document_option( 'page_header_settings' );
		$arts_page_transition_settings = Utilities::get_document_option( 'page_transition_settings' );
		$arts_is_elementor_page        = Utilities::is_built_with_elementor();
		$arts_class_page               = '';
		$arts_attrs_page               = '';
		$arts_class_burger_col         = '';

		/**
		 * Use Individual Page Transition Settings from Elementor
		 * Or Use Global Settings from Customizer
		 */
		if ( $arts_page_transition_settings ) {
			$arts_ajax_curtain_color = Utilities::get_document_option( 'page_ajax_curtain_color' );
		} else {
			$arts_ajax_curtain_color = get_theme_mod( 'ajax_curtain_color', 'bg-off-white' );
		}

		$arts_enable_smooth_scroll                           = get_theme_mod( 'enable_smooth_scroll', false );
		$arts_enable_smooth_scroll_mobile                    = get_theme_mod( 'enable_smooth_scroll_mobile', false );
		$arts_enable_smooth_scroll_elementor_canvas_template = get_theme_mod( 'enable_smooth_scroll_elementor_canvas_template', true );
		$arts_enable_ajax                                    = get_theme_mod( 'enable_ajax', false );
		$arts_enable_master_audio_background                 = get_theme_mod( 'enable_master_audio_background', false );
		$arts_master_audio_player_position                   = get_theme_mod( 'master_audio_player_position', 'header' );
		$arts_enable_preloader                               = arts_is_preloader_enabled();
		$arts_enable_cursor                                  = get_theme_mod( 'enable_cursor', false );
		$arts_enable_spinner_desktop                         = get_theme_mod( 'enable_spinner_desktop', false );
		$arts_enable_spinner_mobile                          = get_theme_mod( 'enable_spinner_mobile', true );
		$arts_outdated_browsers_enabled                      = get_theme_mod( 'outdated_browsers_enabled', true );

		if ( $arts_enable_smooth_scroll === true && $arts_enable_smooth_scroll_elementor_canvas_template === true ) {
			$arts_class_page .= ' js-smooth-scroll';

			if ( $arts_enable_smooth_scroll_mobile == true ) {
				$arts_class_page .= ' js-smooth-scroll_enable-mobile';
			}
		}

		if ( $arts_enable_ajax ) {
			$attrs_wrapper   = 'data-barba=wrapper';
			$arts_attrs_page = 'data-barba=container';
		}
		?>
		<?php if ( $arts_outdated_browsers_enabled ) : ?>
			<div id="outdated"></div>
		<?php endif; ?>
		<?php if ( $arts_enable_ajax ) : ?>
			<div <?php echo esc_attr( $attrs_wrapper ); ?>>
				<?php if ( $arts_enable_spinner_desktop || $arts_enable_spinner_mobile ) : ?>
					<!-- Loading Spinner -->
					<?php get_template_part( 'template-parts/svg/spinner' ); ?>
					<!-- - Loading Spinner -->
				<?php endif; ?>
		<?php endif; ?>
			<?php if ( $arts_enable_cursor ) : ?>
				<!-- CURSOR FOLLOWER-->
				<?php get_template_part( 'template-parts/cursor/cursor' ); ?>
				<!-- - CURSOR FOLLOWER-->
			<?php endif; ?>
			<?php if ( $arts_enable_preloader ) : ?>
				<!-- PAGE PRELOADER -->
				<?php get_template_part( 'template-parts/preloader/preloader' ); ?>
				<!-- - PAGE PRELOADER -->
			<?php endif; ?>
			<?php if ( $arts_enable_ajax ) : ?>
				<!-- TRANSITION CURTAIN -->
				<div class="transition-curtain <?php echo esc_attr( $arts_ajax_curtain_color ); ?>"></div>
				<!-- - TRANSITION CURTAIN -->
			<?php endif; ?>
			<?php if ( $arts_enable_master_audio_background ) : ?>
				<!-- Audio Background -->
				<?php get_template_part( 'template-parts/audio/audio' ); ?>
				<!-- - Audio Background -->
			<?php endif; ?>
			<!-- PAGE HEADER -->
			<?php get_template_part( 'template-parts/header/header' ); // since 2.0.0 ?>
			<!-- - PAGE HEADER -->
			<!-- PAGE MAIN -->
			<div class="page-wrapper <?php echo esc_attr( $arts_class_page ); ?>" <?php echo esc_attr( $arts_attrs_page ); ?>>
				<main class="page-wrapper__content">
		<?php
	}
}

/**
 * AFTER: Extra markup for Elementor Canvas template
 */
add_action( 'elementor/page_templates/canvas/after_content', 'arts_elementor_canvas_template_after' );
if ( ! function_exists( 'arts_elementor_canvas_template_after' ) ) {
	function arts_elementor_canvas_template_after() {
		$arts_enable_ajax = get_theme_mod( 'enable_ajax', true );
		?>
		</main>
		<?php if ( $arts_enable_ajax ) : ?>
			</div>
			<!-- - Barba Wrapper-->
		<?php endif; ?>
		<?php
	}
}
