<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use \Arts\Utilities\Utilities;

if ( ! function_exists( 'arts_get_document_option' ) ) {
	/**
	 * Retrieve a specific document option for a given post.
	 *
	 * @param string   $option_name    The name of the option to retrieve.
	 * @param int|null $post_id        The ID of the post. Defaults to null.
	 * @param mixed    $option_default The value to return if the option is not found. Defaults to an empty string.
	 *
	 * @return mixed The value of the option, or the fallback value if not found.
	 *
	 * @deprecated 3.6.0 Use `\Arts\Utilities\Utilities::get_document_option()` method instead.
	 */
	function arts_get_document_option( $option, $post_id = null, $option_default = false ) {
		if ( did_action( 'elementor/loaded' ) ) {
			return Utilities::get_document_option( $option, $post_id, $option_default );
		} else {
			return $option_default;
		}
	}
}

if ( ! function_exists( 'arts_is_built_with_elementor' ) ) {
	/**
	 * Check if a post is built with Elementor.
	 *
	 * @param int|null $post_id The ID of the post to check. Defaults to null.
	 *
	 * @return bool True if the post is built with Elementor, false otherwise.
	 * @deprecated 3.6.0 Use `\Arts\Utilities\Utilities::is_built_with_elementor()` method instead.
	 */
	function arts_is_built_with_elementor( $post_id = null ) {
		return Utilities::is_built_with_elementor( $post_id );
	}
}

if ( ! function_exists( 'arts_is_elementor_editor_active' ) ) {
	/**
	 * Checks if the Elementor editor is active and in preview mode.
	 *
	 * @return bool True if Elementor editor is active and in preview mode, false otherwise.
	 * @deprecated 3.6.0 Use `\Arts\Utilities\Utilities::is_elementor_editor_active()` method instead.
	 */
	function arts_is_elementor_editor_active() {
		return Utilities::is_elementor_editor_active();
	}
}

if ( ! function_exists( 'arts_is_elementor_feature_active' ) ) {
	/**
	 * Check if Elementor's experimental feature
	 * is supported and active
	 *
	 * @return bool
	 * @deprecated 3.6.0 Use `\Arts\Utilities\Utilities::is_elementor_feature_active()` method instead.
	 */
	function arts_is_elementor_feature_active( $feature_name ) {
		return Utilities::is_elementor_feature_active( $feature_name );
	}
}
