<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

add_action( 'after_setup_theme', 'arts_after_setup_theme' );
if ( ! function_exists( 'arts_after_setup_theme' ) ) {
	/**
	 * Set up theme defaults and registers support for various WordPress features.
	 *
	 * @return void
	 */
	function arts_after_setup_theme() {
		global $content_width;

		if ( ! isset( $content_width ) ) {
			$content_width = 800;
		}

		load_theme_textdomain( 'cassio', ARTS_THEME_PATH . '/languages' );

		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'post-thumbnails' );
		add_theme_support(
			'html5',
			array(
				'comment-list',
				'comment-form',
				'search-form',
				'gallery',
				'caption',
			)
		);
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 80,
				'width'       => 80,
				'flex-height' => true,
				'flex-width'  => true,
				'header-text' => array( 'logo__text' ),
			)
		);
		add_theme_support( 'customize-selective-refresh-widgets' );
		add_theme_support(
			'post-formats',
			array(
				'aside',
				'gallery',
				'link',
				'image',
				'quote',
				'status',
				'video',
				'audio',
				'chat',
			)
		);
		add_theme_support( 'title-tag' );
		add_image_size( 'cassio-600x600-crop', 600, 600, true );
		add_image_size( 'cassio-1920x1200-crop', 1920, 1200, true );
		add_image_size( 'cassio-800x1200-crop', 800, 1200, true );
	}
}
