<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

add_action( 'widgets_init', 'arts_register_widget_areas' );
if ( ! function_exists( 'arts_register_widget_areas' ) ) {
	/**
	 * Register Widget Areas
	 *
	 * @return void
	 */
	function arts_register_widget_areas() {
		$footer_columns_upper = get_theme_mod( 'footer_columns_upper', 3 );
		$footer_columns_lower = get_theme_mod( 'footer_columns_lower', 2 );

		register_sidebar(
			array(
				'name'          => esc_html__( 'Blog Sidebar', 'cassio' ),
				'id'            => 'blog-sidebar',
				'description'   => esc_html__( 'Appears in blog.', 'cassio' ),
				'before_widget' => '<section class="widget %2$s">',
				'after_widget'  => '</section>',
			)
		);

		for ( $i = 1; $i <= $footer_columns_upper; $i++ ) {
			register_sidebar(
				array(
					'name'          => sprintf( esc_html__( 'Footer Upper: %s Column', 'cassio' ), $i ),
					'id'            => 'footer-sidebar-upper' . $i,
					'description'   => esc_html__( 'Appears in Page Footer Upper Section.', 'cassio' ),
					'before_widget' => '<section id="%1$s" class="widget %2$s">',
					'after_widget'  => '</section>',
				)
			);
		}

		for ( $i = 1; $i <= $footer_columns_lower; $i++ ) {
			register_sidebar(
				array(
					'name'          => sprintf( esc_html__( 'Footer Lower: %s Column', 'cassio' ), $i ),
					'id'            => 'footer-sidebar-lower' . $i,
					'description'   => esc_html__( 'Appears in Page Footer Lower Section.', 'cassio' ),
					'before_widget' => '<section id="%1$s" class="widget %2$s">',
					'after_widget'  => '</section>',
				)
			);
		}

		if ( class_exists( 'SitePress' ) || class_exists( 'Polylang' ) || class_exists( 'TRP_Translate_Press' ) ) {
			register_sidebar(
				array(
					'name'          => esc_html__( 'Language Switcher Area', 'cassio' ),
					'id'            => 'lang-switcher-sidebar',
					'description'   => esc_html__( 'Appears in the top menu.', 'cassio' ),
					'before_widget' => '<section class="widget %2$s">',
					'after_widget'  => '</section>',
				)
			);
		}
	}
}
