<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use \Arts\Utilities\Utilities;

$arts_is_elementor_page = Utilities::is_built_with_elementor();
$arts_enable_gutters    = get_theme_mod( 'enable_static_page_gutters', true );

get_header();
get_template_part( 'template-parts/masthead/masthead' );
the_post();

?>

<?php if ( ! $arts_is_elementor_page && ! empty( get_the_content() ) ) : ?>
	<?php if ( $arts_enable_gutters ) : ?>
		<div class="container-fluid container_xs-no-padding">
	<?php endif; ?>
		<!-- section BLOG -->
		<section class="section section-blog section_mt-small section_pt-small section_pb-small bg-white">
			<div class="container">
				<div class="row justify-content-center">
					<div class="col-lg-8">
						<div class="post">
							<div class="post__content clearfix">
								<?php the_content(); ?>
							</div>
							<?php
								wp_link_pages(
									array(
										'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'cassio' ),
										'after'       => '</div>',
										'link_before' => '<span class="page-number">',
										'link_after'  => '</span>',
									)
								);
							?>
							<!-- .post__content -->
							<?php if ( comments_open() || get_comments_number() ) : ?>
								<div class="post__comments">
									<?php comments_template(); ?>
								</div>
								<!-- .post__comments -->
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</section>
		<!-- - section BLOG -->
	<?php if ( $arts_enable_gutters ) : ?>
		</div>
	<?php endif; ?>
<?php else : ?>
	<?php if ( ! function_exists( 'elementor_theme_do_location' ) || ! elementor_theme_do_location( 'single-page' ) ) : // Elementor "page" location ?>
		<?php the_content(); ?>
	<?php endif; ?>
<?php endif; ?>

<?php
	get_footer();
