<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use \Arts\Utilities\Utilities;

$arts_master_audio_background                 = get_theme_mod( 'master_audio_background', '#' );
$arts_master_audio_background_volume          = get_theme_mod( 'master_audio_background_volume', 50 );
$arts_enable_master_audio_background_loop     = get_theme_mod( 'enable_master_audio_background_loop', true );
$arts_enable_master_audio_background_autoplay = get_theme_mod( 'enable_master_audio_background_autoplay', true );
$arts_page_audio_background                   = Utilities::acf_get_field( 'audio_file' );
$arts_page_ajax_options                       = Utilities::acf_get_field( 'audio_ajax_options' );

$arts_attrs = 'data-volume=' . $arts_master_audio_background_volume;

if ( $arts_enable_master_audio_background_loop ) {
	$arts_attrs .= ' loop';
}

if ( $arts_enable_master_audio_background_autoplay ) {
	$arts_attrs .= ' autoplay';
}

if ( ! $arts_page_ajax_options ) {
	$arts_page_ajax_options = 'play_global';
}

switch ( $arts_page_ajax_options ) {
	// music is off on the current page
	// so don't put any souce to src audio
	case 'music_off':
		$arts_page_audio_background = '';
		break;
	// individual audio background should be playing on this page
	// set src to the audio file source from this page
	case 'play':
		$arts_page_audio_background = $arts_page_audio_background;
		break;
	case 'play_global':
		// set src to global audio background
		$arts_page_audio_background = empty( $arts_master_audio_background ) ? '' : $arts_master_audio_background;
		$arts_page_ajax_options     = 'play';
		break;
}

?>

<audio id="js-audio-background" src="<?php echo esc_url( $arts_page_audio_background ); ?>" <?php echo esc_attr( $arts_attrs ); ?> muted volume="0">
	<div id="js-audio-background__options" class="d-none" data-options="<?php echo esc_attr( $arts_page_ajax_options ); ?>"></div>
</audio>
