<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use \Arts\Utilities\Utilities;

global $post;

$arts_is_elementor_page = Utilities::is_built_with_elementor();
$arts_titles            = Utilities::get_page_titles();
$arts_page_title        = $arts_titles['title'];
$arts_page_subtitle     = $arts_titles['subtitle'];

$arts_thumbnail                  = '';
$arts_classes_section            = '';
$arts_classes_inner              = '';
$arts_classes_section_image      = '';
$arts_attrs_section              = '';
$arts_attrs_section_image        = '';
$arts_image_position             = false;
$arts_content_background         = '';
$arts_class_heading              = '';
$arts_class_subheading           = '';
$arts_tag_subheading             = 'h4';
$arts_enable_headline            = true;
$arts_enable_subtitle            = true;
$arts_content_background_enabled = true;
$arts_enable_scroll_down         = false;
$arts_style                      = 'normal';
$arts_enable_video               = '';
$arts_split_classes              = '';
$arts_fly_classes                = '';
$arts_content_container          = 'container';

$arts_classes_section = 'section_pt-large text-center';

if ( $arts_is_elementor_page ) {

	$arts_thumbnail                        = get_the_post_thumbnail_url();
	$arts_thumbnail_id                     = get_post_thumbnail_id();
	$arts_style                            = Utilities::get_document_option( 'page_masthead_style' );
	$arts_content_alignment                = Utilities::get_document_option( 'page_masthead_content_alignment' );
	$arts_content_position                 = Utilities::get_document_option( 'page_masthead_content_position' );
	$arts_content_background               = Utilities::get_document_option( 'page_masthead_content_background' );
	$arts_content_background_enabled       = Utilities::get_document_option( 'page_masthead_content_enable_background' );
	$arts_content_container                = Utilities::get_document_option( 'page_masthead_content_container' );
	$arts_image_position                   = Utilities::get_document_option( 'page_masthead_image_position' );
	$arts_image_alignment                  = Utilities::get_document_option( 'page_masthead_image_alignment' );
	$arts_image_parallax                   = Utilities::get_document_option( 'page_masthead_image_parallax' );
	$arts_image_parallax_speed             = Utilities::get_document_option( 'page_masthead_image_parallax_speed' )['size'];
	$arts_class_heading                    = Utilities::get_document_option( 'page_masthead_heading_size' );
	$arts_class_heading                   .= ' ' . Utilities::get_document_option( 'page_masthead_heading_weight' );
	$arts_class_subheading                 = Utilities::get_document_option( 'page_masthead_subheading_size' );
	$arts_class_subheading                .= ' ' . Utilities::get_document_option( 'page_masthead_subheading_weight' );
	$arts_tag_subheading                   = Utilities::get_document_option( 'page_masthead_subheading_tag' );
	$arts_enable_headline                  = Utilities::get_document_option( 'page_masthead_headline' );
	$arts_enable_subtitle                  = Utilities::get_document_option( 'page_masthead_category' );
	$arts_enable_scroll_down               = Utilities::get_document_option( 'page_masthead_scroll_down' );
	$arts_enable_video                     = Utilities::get_document_option( 'page_masthead_enable_video' );
	$arts_page_transition_settings         = Utilities::get_document_option( 'page_transition_settings' );
	$arts_enable_flying_heading_transition = Utilities::get_document_option( 'page_ajax_flying_heading_enabled' );
	$arts_video_bg                         = Utilities::acf_get_field( 'video' );

	$arts_classes_section       = $arts_content_background . ' ' . $arts_content_alignment;
	$arts_classes_section_image = $arts_image_alignment;

	$arts_attrs_section = 'data-os-animation';
	$arts_split_classes = 'split-text js-split-text';
	$arts_fly_classes   = 'js-text-to-fly';

	/**
	 * Disable Flying Heading Transition
	 */
	if ( $arts_page_transition_settings && ! $arts_enable_flying_heading_transition ) {
		$arts_fly_classes = '';
	}

	if ( $arts_style == 'normal' ) {

		if ( $arts_image_parallax ) {
			$arts_attrs_section_image .= ' data-art-parallax=background';
			$arts_attrs_section_image .= " data-art-parallax-factor={$arts_image_parallax_speed} ";
		}

		if ( $arts_image_position == 'fullscreen' ) {
			$arts_classes_section_image = 'section-masthead__background section-masthead__background_fullscreen';
			$arts_classes_section      .= ' section-fullheight';
			$arts_classes_inner        .= ' section-fullheight__inner';
			if ( $arts_content_background_enabled ) {
				$arts_classes_inner .= ' section-masthead__inner_background';
			}
			if ( $arts_content_position !== '' && $arts_content_background_enabled ) {
				$arts_classes_inner .= ' ' . $arts_content_position;
			}
		} else {
			$arts_classes_section       .= ' ' . Utilities::get_document_option( 'page_masthead_pt' );
			$arts_classes_section       .= ' ' . Utilities::get_document_option( 'page_masthead_pb' );
			$arts_classes_section       .= ' ' . Utilities::get_document_option( 'page_masthead_mt' );
			$arts_classes_section       .= ' ' . Utilities::get_document_option( 'page_masthead_mb' );
			$arts_classes_section_image .= ' section_mt-small';
		}
	} else {
		$arts_classes_section .= ' section-masthead_big-heading section-fullheight';
	}
}

$arts_classes_inner .= ' ' . $arts_content_container;

$categories       = array();
$categories_names = array();

if ( $post ) {
	$categories = Utilities::get_taxonomy_term_names( $post->ID, 'arts_portfolio_category' );
}

foreach ( $categories as $item ) {
	array_push( $categories_names, $item['name'] );
}

$arts_page_subtitle = implode( '&nbsp;&nbsp;/&nbsp;&nbsp;', $categories_names );

?>

<div class="<?php echo esc_attr( $arts_content_background ); ?>">
	<section class="section section-masthead <?php echo esc_attr( $arts_classes_section ); ?>" <?php echo esc_attr( $arts_attrs_section ); ?>>
		<?php if ( $arts_style == 'normal' ) : ?>
			<div class="section-masthead__inner <?php echo esc_attr( $arts_classes_inner ); ?>">
				<header class="row section-masthead__header justify-content-center">
					<div class="col">
						<?php if ( is_singular( 'post' ) ) : ?>
							<div class="section-masthead__meta">
								<?php get_template_part( 'template-parts/post/partials/post_info' ); ?>
							</div>
							<div class="w-100"></div>
						<?php endif; ?>
						<?php if ( $arts_page_subtitle && $arts_enable_subtitle ) : ?>
							<div class="subheading section-masthead__subheading <?php echo esc_attr( $arts_split_classes ); ?>" data-split-text-type="lines, words, chars" data-split-text-set="chars">
								<?php echo esc_html( $arts_page_subtitle ); ?>
							</div>
							<div class="w-100"></div>
						<?php endif; ?>
						<?php if ( $arts_page_title ) : ?>
							<h1 class="entry-title section-masthead__heading <?php echo esc_attr( $arts_fly_classes ); ?> <?php echo esc_attr( $arts_split_classes ); ?> <?php echo esc_attr( $arts_class_heading ); ?>" data-split-text-type="lines, words, chars" data-split-text-set="chars"><?php echo esc_html( $arts_page_title ); ?></h1>
							<div class="w-100"></div>
						<?php endif; ?>
						<?php if ( Utilities::acf_get_field( 'subheading' ) ) : ?>
							<<?php echo esc_attr( $arts_tag_subheading ); ?> class="section-masthead__text <?php echo esc_attr( $arts_split_classes ); ?> <?php echo esc_attr( $arts_class_subheading ); ?>" data-split-text-type="lines" data-split-text-set="lines"><?php echo Utilities::acf_get_field( 'subheading' ); ?></<?php echo esc_attr( $arts_tag_subheading ); ?>>
							<div class="w-100"></div>
						<?php endif; ?>
						<?php if ( $arts_enable_headline ) : ?>
							<div class="section__headline section-masthead__headline"></div>
						<?php endif; ?>
					</div>
					<?php if ( $arts_enable_scroll_down && $arts_image_position == 'fullscreen' ) : ?>
						<div class="section-masthead__wrapper-scroll-down">
							<div class="scroll-down js-scroll-down">
								<div class="scroll-down__circle-1"></div>
								<div class="scroll-down__line"></div>
								<div class="scroll-down__circle-2"></div>
							</div>
						</div>
					<?php endif; ?>
				</header>
				<?php if ( $arts_content_background_enabled ) : ?>
					<div class="section-masthead__curtain <?php echo esc_attr( $arts_content_background ); ?>"></div>
				<?php endif; ?>
			</div>
			<?php if ( $arts_thumbnail && $arts_image_position !== 'none' ) : ?>
				<div class="section-image <?php echo esc_attr( $arts_classes_section_image ); ?>">
					<div class="section-image__wrapper" <?php echo esc_attr( $arts_attrs_section_image ); ?>>
						<div class="art-parallax__wrapper">
							<?php if ( $arts_enable_video && $arts_video_bg ) : ?>
								<video class="art-parallax__bg of-cover" src="<?php echo esc_url( $arts_video_bg ); ?>" poster="<?php echo esc_url( $arts_thumbnail ); ?>" playsinline loop muted autoplay></video>
							<?php else : ?>
								<?php
									arts_the_lazy_image(
										array(
											'id'    => $arts_thumbnail_id,
											'class' => array(
												'image' => array( 'art-parallax__bg' ),
											),
										)
									);
								?>
							<?php endif; ?>
						</div>
						<?php if ( $arts_image_position === 'fullscreen' ) : ?>
							<div class="overlay overlay_dark section-masthead__overlay"></div>
						<?php endif; ?>
					</div>
				</div>
			<?php endif; ?>
		<?php else : ?>
			<div class="section-fullheight__inner <?php echo esc_attr( $arts_classes_inner ); ?>">
				<div class="row">
					<div class="col">
						<?php if ( $arts_page_title ) : ?>
							<h1 class="js-text-to-fly split-text js-split-text section-masthead__heading section-masthead__heading-big <?php echo esc_attr( $arts_class_heading ); ?>" data-split-text-type="lines, words, chars" data-split-text-set="chars"><?php echo esc_html( $arts_page_title ); ?></h1>
						<?php endif; ?>
					</div>
				</div>
			</div>
		<?php endif; ?>
	</section>
</div>
