<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use \Arts\Utilities\Utilities;

$arts_next_post  = get_previous_post();
$arts_prev_post  = get_next_post();
$arts_current_id = get_the_ID();
$arts_next_link;
$arts_next_title;
$arts_prev_link;
$arts_prev_title;
$arts_enable_portfolio_loop         = get_theme_mod( 'enable_portfolio_loop', true );
$arts_class_link                    = 'col';
$arts_page_portfolio_nav_theme      = Utilities::get_document_option( 'page_portfolio_nav_theme' );
$arts_enable_portfolio_archive_link = get_theme_mod( 'enable_portfolio_archive_link', true );
$arts_portfolio_archive_link        = get_theme_mod( 'portfolio_archive_link', '' );
$arts_portfolio_nav_hover_effect    = get_theme_mod( 'portfolio_nav_hover_effect', 'reveal' );
$arts_has_split_text                = $arts_portfolio_nav_hover_effect === 'reveal' || $arts_portfolio_nav_hover_effect === 'none';

$arts_posts = get_posts(
	array(
		'post_type'      => 'arts_portfolio_item',
		'posts_per_page' => -1,
	)
);

$arts_first_post = current( $arts_posts );
$arts_last_post  = end( $arts_posts );

if ( $arts_next_post ) {
	$arts_next_link  = get_permalink( $arts_next_post );
	$arts_next_title = $arts_next_post->post_title;
}

if ( ! $arts_next_post && $arts_enable_portfolio_loop ) {
	$arts_next_post  = $arts_first_post;
	$arts_next_link  = get_permalink( $arts_next_post );
	$arts_next_title = $arts_next_post->post_title;
}

if ( $arts_prev_post ) {
	$arts_prev_link  = get_permalink( $arts_prev_post );
	$arts_prev_title = $arts_prev_post->post_title;
}

if ( ! $arts_prev_post && $arts_enable_portfolio_loop ) {
	$arts_prev_post  = $arts_last_post;
	$arts_prev_link  = get_permalink( $arts_prev_post );
	$arts_prev_title = $arts_prev_post->post_title;
}

if ( $arts_next_post && $arts_prev_post && $arts_enable_portfolio_archive_link && ! empty( $arts_portfolio_archive_link ) ) {
	$arts_class_link = 'col-md-5';
}

if ( $arts_next_post && $arts_prev_post && ( ! $arts_enable_portfolio_archive_link || empty( $arts_portfolio_archive_link ) ) ) {
	$arts_class_link = 'col-md-6';
}

if ( ! $arts_page_portfolio_nav_theme ) {
	$arts_page_portfolio_nav_theme = 'bg-white';
}

?>

<?php if ( $arts_next_post || $arts_prev_post ) : ?>
	<div class="section-nav-projects section-nav-projects_<?php echo esc_attr( $arts_portfolio_nav_hover_effect ); ?> <?php echo esc_attr( $arts_page_portfolio_nav_theme ); ?>">
		<div class="row no-gutters">
			<a href="<?php echo esc_url( $arts_prev_link ); ?>" class="section-nav-projects__inner section-nav-projects__inner_prev <?php echo esc_attr( $arts_class_link ); ?>" <?php if ( $arts_has_split_text ) : ?>data-pjax-link="flyingHeading"<?php endif; ?>>
				<div class="section-nav-projects__wrapper-heading section-nav-projects__wrapper-heading_prev">
					<div class="section-nav-projects__heading section-nav-projects__heading_prev <?php if ( $arts_has_split_text ) : ?>split-text js-split-text js-text-to-fly<?php endif; ?>" data-split-text-type="lines, words, chars" data-split-text-set="chars"><?php echo esc_html( $arts_prev_title ); ?></div>
				</div>
				<div class="section-nav-projects__arrow section-nav-projects__arrow_prev material-icons">keyboard_arrow_left</div>
			</a>
			<?php if ( $arts_enable_portfolio_archive_link && ! empty( $arts_portfolio_archive_link ) ) : ?>
				<a href="<?php echo get_permalink( $arts_portfolio_archive_link ); ?>" class="col-md-2 section-nav-projects__inner section-nav-projects__inner_all" aria-label="<?php echo esc_attr( 'View All Projects', 'cassio' ); ?>">
					<div class="button-circles">
						<div class="button-circles__circle">
							<?php get_template_part( 'template-parts/svg/circle' ); ?>
						</div>
						<div class="button-circles__circle">
							<?php get_template_part( 'template-parts/svg/circle' ); ?>
						</div>
						<div class="button-circles__circle">
							<?php get_template_part( 'template-parts/svg/circle' ); ?>
						</div>
						<div class="button-circles__circle">
							<?php get_template_part( 'template-parts/svg/circle' ); ?>
						</div>
					</div>
				</a>
			<?php endif; ?>
			<a href="<?php echo esc_url( $arts_next_link ); ?>" class="section-nav-projects__inner section-nav-projects__inner_next <?php echo esc_attr( $arts_class_link ); ?>" <?php if ( $arts_has_split_text ) : ?>data-pjax-link="flyingHeading"<?php endif; ?>>
				<div class="section-nav-projects__wrapper-heading section-nav-projects__wrapper-heading_next">
					<div class="section-nav-projects__heading section-nav-projects__heading_next <?php if ( $arts_has_split_text ) : ?>split-text js-split-text js-text-to-fly<?php endif; ?>" data-split-text-type="lines, words, chars" data-split-text-set="chars"><?php echo esc_html( $arts_next_title ); ?></div>
				</div>
				<div class="section-nav-projects__arrow section-nav-projects__arrow_next material-icons">keyboard_arrow_right</div>
			</a>
		</div>
	</div>
<?php endif; ?>
