<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$arts_preloader_bg_outer_theme = get_theme_mod( 'preloader_bg_outer_theme', 'bg-dark' );
$arts_preloader_bg_inner_theme = get_theme_mod( 'preloader_bg_inner_theme', 'bg-accent-primary-1' );
$arts_enable_preloader_logo    = get_theme_mod( 'enable_preloader_logo', true );
$arts_preloader_logo           = get_theme_mod( 'preloader_logo', 'primary' );
$arts_preloader_style          = get_theme_mod( 'preloader_style', 'counter' );
$arts_preloader_text           = get_theme_mod( 'preloader_text', esc_html__( 'Loading', 'cassio' ) );
$arts_preloader_image_url      = get_theme_mod( 'preloader_image_url', '' );

?>

<div class="preloader js-preloader <?php echo esc_attr( $arts_preloader_bg_outer_theme ); ?>" data-logo="<?php echo esc_attr( $arts_preloader_logo ); ?>">
	<div class="preloader__curtain preloader__curtain_outer <?php echo esc_attr( $arts_preloader_bg_outer_theme ); ?>"></div>
	<div class="preloader__curtain preloader__curtain_inner <?php echo esc_attr( $arts_preloader_bg_inner_theme ); ?>"></div>
	<div class="preloader__content">
		<?php if ( $arts_enable_preloader_logo ) : ?>
			<div class="preloader__wrapper-logo">
				<?php if ( $arts_preloader_style == 'logo' ) : ?>
					<?php get_template_part( 'template-parts/logo/logo' ); ?>
				<?php elseif ( $arts_preloader_style == 'counter' ) : ?>
					<div class="counter js-counter">
						<div class="counter__number preloader__counter js-counter__number">00</div>
					</div>
				<?php elseif ( $arts_preloader_style == 'custom_image' ) : ?>
					<?php if ( ! empty( $arts_preloader_image_url ) ) : ?>
						<img src="<?php echo esc_attr( $arts_preloader_image_url ); ?>" alt />
					<?php endif; ?>
				<?php endif; ?>
				<?php if ( ! empty( $arts_preloader_text ) ) : ?>
					<div class="preloader__loading-label"><?php echo esc_html( $arts_preloader_text ); ?></div>
				<?php endif; ?>
				<?php get_template_part( 'template-parts/svg/circle' ); ?>
			</div>
		<?php endif; ?>
	</div>
</div>
