<?php
/**
 * Plugin Name: Cassio Core
 * Description: Core Plugin for Cassio WordPress Theme
 * Plugin URI: https://artemsemkin.com/
 * Version: 2.2.1
 * Requires at least: 6.4
 * Requires PHP: 7.0
 * Author: Artem Semkin
 * Update URI: artemsemkin.com
 * Tested up to: 6
 * Text Domain: cassio
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

require_once __DIR__ . '/vendor/autoload.php';

use \Arts\Utilities\Utilities;

$theme_version  = Utilities::get_parent_theme_version();
$plugin_version = Utilities::get_plugin_version( __FILE__ );

define( 'ARTS_CASSIO_CORE_THEME_VERSION', $theme_version );
define( 'ARTS_CASSIO_CORE_PLUGIN_VERSION', $plugin_version );
define( 'ARTS_CASSIO_CORE_PLUGIN_PATH', untrailingslashit( plugin_dir_path( __FILE__ ) ) );
define( 'ARTS_CASSIO_CORE_PLUGIN_URL', untrailingslashit( plugin_dir_url( __FILE__ ) ) );

require_once __DIR__ . '/elementor/cassio_elementor_extension.php';
require_once __DIR__ . '/elementor/document/page_header.php';
require_once __DIR__ . '/elementor/document/page_masthead.php';
require_once __DIR__ . '/elementor/document/page_transition.php';
require_once __DIR__ . '/elementor/document/page_portfolio_nav.php';
require_once __DIR__ . '/elementor/document/page_footer.php';
require_once __DIR__ . '/elementor/extensions/section_settings.php';
require_once __DIR__ . '/inc/add_custom_mime_types.php';
require_once __DIR__ . '/inc/cpt.php';
require_once __DIR__ . '/inc/helper_functions.php';
require_once __DIR__ . '/inc/shortcodes.php';
require_once __DIR__ . '/inc/taxonomies.php';
require_once __DIR__ . '/inc/widgets.php';

/**
 * Plugins Updater
 */
new \Arts\PluginsUpdater\Plugin(
	array(
		'theme_id'        => 'cassio',
		'current_plugin'  => array(
			'update_uri' => 'artemsemkin.com',
			'plugin_id'  => plugin_basename( __FILE__ ),
			'endpoint'   => esc_url( 'https://artemsemkin.com/wp-json/edd/v1/update/cassio/core-plugin' ),
			'method'     => 'POST',
			'icons'      => array(
				'svg' => esc_url( trailingslashit( ARTS_CASSIO_CORE_PLUGIN_URL ) . 'assets/icon.svg' ),
				'1x'  => esc_url( trailingslashit( ARTS_CASSIO_CORE_PLUGIN_URL ) . 'assets/icon-128x128.jpg' ),
				'2x'  => esc_url( trailingslashit( ARTS_CASSIO_CORE_PLUGIN_URL ) . 'assets/icon-256x256.jpg' ),
			),
			'banners'    => array(
				'low'  => esc_url( trailingslashit( ARTS_CASSIO_CORE_PLUGIN_URL ) . 'assets/banner-772x250.jpg' ),
				'high' => esc_url( trailingslashit( ARTS_CASSIO_CORE_PLUGIN_URL ) . 'assets/banner-1544x500.jpg' ),
			),
		),
		'bundled_plugins' => array(
			'acf_pro' => array(
				'plugin_id' => 'advanced-custom-fields-pro/acf.php',
				'endpoint'  => esc_url( 'https://artemsemkin.com/wp-json/edd/v1/update/acf-pro/plugin' ),
				'method'    => 'POST',
			),
		),
	),
	array(
		'error-json-decode'         => 'Failed to decode JSON response.',
		'error-fetch'               => 'Failed to fetch remote data.',
		'license-page-url'          => admin_url( 'admin.php?page=cassio-license' ),
		'license-page-text'         => 'Theme License',
		'license-purchase-url-text' => 'Envato Market',
	)
);

add_action( 'init', 'arts_load_textdomain' );
function arts_load_textdomain() {
	load_plugin_textdomain( 'cassio' );
}
