<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Page Footer in Elementor Document Settings
 */
add_action( 'elementor/element/wp-page/document_settings/after_section_end', 'arts_add_elementor_document_settings_page_footer' );
add_action( 'elementor/element/wp-post/document_settings/after_section_end', 'arts_add_elementor_document_settings_page_footer' );
function arts_add_elementor_document_settings_page_footer( \Elementor\Core\DocumentTypes\PageBase $page ) {
	$post_id           = get_the_ID();
	$post_type         = get_post_type( $post_id );
	$is_portfolio_item = $post_type == 'arts_portfolio_item';

	$page->start_controls_section(
		'page_footer_section',
		array(
			'label' => esc_html__( 'Page Footer', 'cassio' ),
			'tab'   => \Elementor\Controls_Manager::TAB_SETTINGS,
		)
	);

	$page->add_control(
		'page_footer_settings',
		array(
			'label'       => esc_html__( 'Override Page Footer Settings', 'Elementor Widget Section', 'cassio' ),
			'description' => esc_html__( 'Use custom footer settings for this page instead of global customizer settings', 'Elementor Widget Section', 'cassio' ),
			'type'        => \Elementor\Controls_Manager::SWITCHER,
			'default'     => $is_portfolio_item ? 'yes' : '',
		)
	);

	$page->add_control(
		'page_footer_hide',
		array(
			'label'     => esc_html__( 'Remove Footer from this Page', 'Elementor Widget Section', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::SWITCHER,
			'default'   => $is_portfolio_item ? 'yes' : '',
			'condition' => array(
				'page_footer_settings' => 'yes',
			),
		)
	);

	$page->add_control(
		'page_footer_theme',
		array(
			'label'     => esc_html__( 'Color Theme', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'options'   => array(
				'bg-white'              => esc_html__( 'White', 'cassio' ),
				'bg-off-white'          => esc_html__( 'Off white', 'cassio' ),
				'bg-light'              => esc_html__( 'Light', 'cassio' ),
				'bg-black'              => esc_html__( 'Black', 'cassio' ),
				'bg-dark'               => esc_html__( 'Dark', 'cassio' ),
				'bg-dark-2'             => esc_html__( 'Dark 2', 'cassio' ),
				'bg-dark-3'             => esc_html__( 'Dark 3', 'cassio' ),
				'bg-accent-primary-1'   => esc_html__( 'Accent Primary 1', 'cassio' ),
				'bg-accent-primary-2'   => esc_html__( 'Accent Primary 2', 'cassio' ),
				'bg-accent-primary-3'   => esc_html__( 'Accent Primary 3', 'cassio' ),
				'bg-accent-primary-4'   => esc_html__( 'Accent Primary 4', 'cassio' ),
				'bg-accent-secondary-1' => esc_html__( 'Accent Secondary 1', 'cassio' ),
				'bg-accent-secondary-2' => esc_html__( 'Accent Secondary 2', 'cassio' ),
				'bg-accent-secondary-3' => esc_html__( 'Accent Secondary 3', 'cassio' ),
				'bg-accent-secondary-4' => esc_html__( 'Accent Secondary 4', 'cassio' ),
			),
			'default'   => esc_html( get_theme_mod( 'footer_theme', 'bg-light' ) ),
			'condition' => array(
				'page_footer_settings' => 'yes',
				'page_footer_hide!'    => 'yes',
			),
		)
	);

	$page->add_control(
		'page_footer_logo',
		array(
			'label'     => esc_html__( 'Logo to Display', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'options'   => array(
				'primary'   => esc_html__( 'Primary', 'cassio' ),
				'secondary' => esc_html__( 'Secondary', 'cassio' ),
			),
			'default'   => esc_html( get_theme_mod( 'footer_logo', 'primary' ) ),
			'condition' => array(
				'page_footer_settings' => 'yes',
				'page_footer_hide!'    => 'yes',
			),
		)
	);

	$page->add_control(
		'page_enable_footer_border_primary',
		array(
			'label'     => esc_html__( 'Enable Upper Section Divider', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::SWITCHER,
			'default'   => esc_html( get_theme_mod( 'enable_footer_border_primary', true ) ? 'yes' : '' ),
			'condition' => array(
				'page_footer_settings' => 'yes',
				'page_footer_hide!'    => 'yes',
			),
		)
	);

	$page->add_control(
		'page_enable_footer_border_secondary',
		array(
			'label'     => esc_html__( 'Enable Lower Section Divider', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::SWITCHER,
			'default'   => esc_html( get_theme_mod( 'enable_footer_border_secondary', true ) ? 'yes' : '' ),
			'condition' => array(
				'page_footer_settings' => 'yes',
				'page_footer_hide!'    => 'yes',
			),
		)
	);

	$page->end_controls_section();
}
