<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Page Masthead in Elementor Document Settings
 */
add_action( 'elementor/element/wp-page/document_settings/after_section_end', 'arts_add_elementor_document_settings_page_masthead' );
add_action( 'elementor/element/wp-post/document_settings/after_section_end', 'arts_add_elementor_document_settings_page_masthead' );
function arts_add_elementor_document_settings_page_masthead( \Elementor\Core\DocumentTypes\PageBase $page ) {
	$page->start_controls_section(
		'page_masthead_section',
		array(
			'label' => esc_html__( 'Page Masthead', 'cassio' ),
			'tab'   => \Elementor\Controls_Manager::TAB_SETTINGS,
		)
	);

	$page->add_control(
		'page_masthead_style',
		array(
			'label'   => esc_html__( 'Masthead Style', 'cassio' ),
			'type'    => \Elementor\Controls_Manager::SELECT,
			'options' => array(
				'normal'       => esc_html__( 'Normal', 'cassio' ),
				'disappearing' => esc_html__( 'Disappearing Heading', 'cassio' ),
			),
			'default' => 'normal',
		)
	);

	$page->add_control(
		'heading_content',
		array(
			'label'     => esc_html__( 'Content', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::HEADING,
			'separator' => 'before',
		)
	);

	$page->add_control(
		'page_masthead_content_alignment',
		array(
			'label'   => esc_html__( 'Alignment', 'cassio' ),
			'type'    => \Elementor\Controls_Manager::CHOOSE,
			'options' => array(
				'text-left'   => array(
					'title' => esc_html__( 'Left', 'cassio' ),
					'icon'  => 'eicon-text-align-left',
				),
				'text-center' => array(
					'title' => esc_html__( 'Center', 'cassio' ),
					'icon'  => 'eicon-text-align-center',
				),
				'text-right'  => array(
					'title' => esc_html__( 'Right', 'cassio' ),
					'icon'  => 'eicon-text-align-right',
				),
			),
			'default' => 'text-left',
			'toggle'  => false,
		)
	);

	$page->add_control(
		'page_masthead_content_enable_background',
		array(
			'label'     => esc_html__( 'Enable Background', 'Elementor Widget', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::SWITCHER,
			'default'   => 'yes',
			'condition' => array(
				'page_masthead_style'          => 'normal',
				'page_masthead_image_position' => 'fullscreen',
			),
		)
	);

	$page->add_control(
		'page_masthead_content_container',
		array(
			'label'      => esc_html__( 'Container', 'cassio' ),
			'type'       => \Elementor\Controls_Manager::SELECT,
			'options'    => array(
				'container'       => esc_html__( 'Boxed', 'cassio' ),
				'container-fluid' => esc_html__( 'Fullwidth', 'cassio' ),
			),
			'default'    => 'container-fluid',
			'conditions' => array(
				'relation' => 'or',
				'terms'    => array(
					array(
						'name'     => 'page_masthead_image_position',
						'operator' => '!=',
						'value'    => 'yes',
					),
					array(
						'name'     => 'page_masthead_style',
						'operator' => '==',
						'value'    => 'disappearing',
					),
				),
			),
		)
	);

	$page->add_control(
		'page_masthead_content_position',
		array(
			'label'     => esc_html__( 'Position', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::CHOOSE,
			'options'   => array(
				'section-masthead__inner_background-left'  => array(
					'title' => esc_html__( 'Left', 'cassio' ),
					'icon'  => 'eicon-h-align-left',
				),
				''                                         => array(
					'title' => esc_html__( 'Center', 'cassio' ),
					'icon'  => 'eicon-h-align-center',
				),
				'section-masthead__inner_background-right' => array(
					'title' => esc_html__( 'Right', 'cassio' ),
					'icon'  => 'eicon-h-align-right',
				),
			),
			'default'   => 'section-masthead__inner_background-left',
			'toggle'    => false,
			'condition' => array(
				'page_masthead_style'                     => 'normal',
				'page_masthead_content_enable_background' => 'yes',
				'page_masthead_image_position'            => 'fullscreen',
			),
		)
	);

	$page->add_control(
		'page_masthead_pt',
		array(
			'label'     => esc_html__( 'Padding Top', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'default'   => 'section_pt-large',
			'options'   => array(
				''                  => esc_html__( 'None', 'cassio' ),
				'section_pt-xsmall' => esc_html__( '+ XSmall', 'cassio' ),
				'section_pt-small'  => esc_html__( '+ Small', 'cassio' ),
				'section_pt'        => esc_html__( '+ Medium', 'cassio' ),
				'section_pt-large'  => esc_html__( '+ Large', 'cassio' ),
				'section_pt-xlarge' => esc_html__( '+ XLarge', 'cassio' ),
			),
			'condition' => array(
				'page_masthead_style'           => 'normal',
				'page_masthead_image_position!' => 'fullscreen',
			),
		)
	);

	$page->add_control(
		'page_masthead_pb',
		array(
			'label'     => esc_html__( 'Padding Bottom', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'default'   => 'section_pb',
			'options'   => array(
				''                  => esc_html__( 'None', 'cassio' ),
				'section_pb-xsmall' => esc_html__( '+ XSmall', 'cassio' ),
				'section_pb-small'  => esc_html__( '+ Small', 'cassio' ),
				'section_pb'        => esc_html__( '+ Medium', 'cassio' ),
				'section_pb-large'  => esc_html__( '+ Large', 'cassio' ),
				'section_pb-xlarge' => esc_html__( '+ XLarge', 'cassio' ),
			),
			'condition' => array(
				'page_masthead_style'           => 'normal',
				'page_masthead_image_position!' => 'fullscreen',
			),
		)
	);
	$page->add_control(
		'page_masthead_mt',
		array(
			'label'     => esc_html__( 'Margin Top', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'default'   => '',
			'options'   => array(
				''                  => esc_html__( 'None', 'cassio' ),
				'section_mt-xsmall' => esc_html__( '+ XSmall', 'cassio' ),
				'section_mt-small'  => esc_html__( '+ Small', 'cassio' ),
				'section_mt'        => esc_html__( '+ Medium', 'cassio' ),
				'section_mt-large'  => esc_html__( '+ Large', 'cassio' ),
				'section_mt-xlarge' => esc_html__( '+ XLarge', 'cassio' ),
			),
			'condition' => array(
				'page_masthead_style'           => 'normal',
				'page_masthead_image_position!' => 'fullscreen',
			),
		)
	);
	$page->add_control(
		'page_masthead_mb',
		array(
			'label'     => esc_html__( 'Margin Bottom', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'default'   => '',
			'options'   => array(
				''                  => esc_html__( 'None', 'cassio' ),
				'section_mb-xsmall' => esc_html__( '+ XSmall', 'cassio' ),
				'section_mb-small'  => esc_html__( '+ Small', 'cassio' ),
				'section_mb'        => esc_html__( '+ Medium', 'cassio' ),
				'section_mb-large'  => esc_html__( '+ Large', 'cassio' ),
				'section_mb-xlarge' => esc_html__( '+ XLarge', 'cassio' ),
			),
			'condition' => array(
				'page_masthead_style'           => 'normal',
				'page_masthead_image_position!' => 'fullscreen',
			),
		)
	);

	$page->add_control(
		'heading_image',
		array(
			'label'     => esc_html__( 'Background', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::HEADING,
			'separator' => 'before',
			'condition' => array(
				'page_masthead_style' => 'normal',
			),
		)
	);

	$page->add_control(
		'page_masthead_enable_video',
		array(
			'label'     => esc_html__( 'Use Featured Video', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::SWITCHER,
			'default'   => 'yes',
			'condition' => array(
				'page_masthead_style' => 'normal',
			),
		)
	);

	$page->add_control(
		'page_masthead_image_position',
		array(
			'label'     => esc_html__( 'Position', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'options'   => array(
				'none'       => esc_html__( 'None (hide)', 'cassio' ),
				'beneath'    => esc_html__( 'Beneath Content', 'cassio' ),
				'fullscreen' => esc_html__( 'Fullscreen', 'cassio' ),
			),
			'default'   => 'beneath',
			'condition' => array(
				'page_masthead_style' => 'normal',
			),
		)
	);

	$page->add_control(
		'page_masthead_overlay_background_color',
		array(
			'label'     => esc_html__( 'Overlay', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'default'   => 'rgba(0,0,0,.6)',
			'selectors' => array(
				'{{WRAPPER}} .section-masthead .section-masthead__overlay' => 'background-color: {{VALUE}};',
			),
			'condition' => array(
				'page_masthead_style'          => 'normal',
				'page_masthead_image_position' => 'fullscreen',
			),
		)
	);

	$page->add_responsive_control(
		'page_masthead_image_height',
		array(
			'label'              => esc_html__( 'Height', 'cassio' ),
			'type'               => \Elementor\Controls_Manager::SLIDER,
			'default'            => array(
				'size' => 900,
				'unit' => 'px',
			),
			'desktop_default'    => array(
				'size' => 900,
				'unit' => 'px',
			),
			'tablet_default'     => array(
				'size' => 70,
				'unit' => 'vh',
			),
			'mobile_default'     => array(
				'size' => 50,
				'unit' => 'vh',
			),
			'range'              => array(
				'px' => array(
					'min' => 0,
					'max' => 1440,
				),
				'vh' => array(
					'min' => 0,
					'max' => 100,
				),
			),
			'size_units'         => array( 'px', 'vh' ),
			'selectors'          => array(
				'{{WRAPPER}} .section-masthead .section-image__wrapper' => 'height: {{SIZE}}{{UNIT}};',
			),
			'condition'          => array(
				'page_masthead_style'          => 'normal',
				'page_masthead_image_position' => 'beneath',
			),
			'frontend_available' => true,
		)
	);

	$page->add_control(
		'page_masthead_image_alignment',
		array(
			'label'     => esc_html__( 'Alignment', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::CHOOSE,
			'options'   => array(
				'section_w-container-center' => array(
					'title' => esc_html__( 'Fullwidth', 'cassio' ),
					'icon'  => 'eicon-h-align-stretch',
				),
				'section_w-container-left'   => array(
					'title' => esc_html__( 'Left', 'cassio' ),
					'icon'  => 'eicon-h-align-left',
				),
				'container'                  => array(
					'title' => esc_html__( 'Center', 'cassio' ),
					'icon'  => 'eicon-h-align-center',
				),
				'section_w-container-right'  => array(
					'title' => esc_html__( 'Right', 'cassio' ),
					'icon'  => 'eicon-h-align-right',
				),
			),
			'default'   => 'section_w-container-center',
			'condition' => array(
				'page_masthead_style'          => 'normal',
				'page_masthead_image_position' => 'beneath',
			),
			'toggle'    => false,
		)
	);

	$page->add_control(
		'page_masthead_image_parallax',
		array(
			'label'     => esc_html__( 'Enable Parallax', 'Elementor Widget', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::SWITCHER,
			'default'   => 'yes',
			'condition' => array(
				'page_masthead_style'           => 'normal',
				'page_masthead_image_position!' => 'none',
			),
		)
	);

	$page->add_control(
		'page_masthead_image_parallax_speed',
		array(
			'label'     => esc_html__( 'Parallax Speed', 'Elementor Widget', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::SLIDER,
			'range'     => array(
				'factor' => array(
					'min'  => -0.5,
					'max'  => 0.5,
					'step' => 0.01,
				),
			),
			'default'   => array(
				'unit' => 'factor',
				'size' => 0.1,
			),
			'condition' => array(
				'page_masthead_style'           => 'normal',
				'page_masthead_image_parallax'  => 'yes',
				'page_masthead_image_position!' => 'none',
			),
		)
	);

	$page->add_control(
		'heading_themes',
		array(
			'label'     => esc_html__( 'Color Themes', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::HEADING,
			'separator' => 'before',
		)
	);

	$page->add_control(
		'page_masthead_content_background',
		array(
			'label'   => esc_html__( 'Color Theme', 'cassio' ),
			'type'    => \Elementor\Controls_Manager::SELECT,
			'options' => array(
				'bg-white'              => esc_html__( 'White', 'cassio' ),
				'bg-off-white'          => esc_html__( 'Off white', 'cassio' ),
				'bg-light'              => esc_html__( 'Light', 'cassio' ),
				'bg-black'              => esc_html__( 'Black', 'cassio' ),
				'bg-dark'               => esc_html__( 'Dark', 'cassio' ),
				'bg-dark-2'             => esc_html__( 'Dark 2', 'cassio' ),
				'bg-dark-3'             => esc_html__( 'Dark 3', 'cassio' ),
				'bg-accent-primary-1'   => esc_html__( 'Accent Primary 1', 'cassio' ),
				'bg-accent-primary-2'   => esc_html__( 'Accent Primary 2', 'cassio' ),
				'bg-accent-primary-3'   => esc_html__( 'Accent Primary 3', 'cassio' ),
				'bg-accent-primary-4'   => esc_html__( 'Accent Primary 4', 'cassio' ),
				'bg-accent-secondary-1' => esc_html__( 'Accent Secondary 1', 'cassio' ),
				'bg-accent-secondary-2' => esc_html__( 'Accent Secondary 2', 'cassio' ),
				'bg-accent-secondary-3' => esc_html__( 'Accent Secondary 3', 'cassio' ),
				'bg-accent-secondary-4' => esc_html__( 'Accent Secondary 4', 'cassio' ),
			),
			'default' => 'bg-light',
		)
	);

	$page->add_control(
		'heading_typography',
		array(
			'label'     => esc_html__( 'Typography', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::HEADING,
			'separator' => 'before',
		)
	);

	$page->add_control(
		'page_masthead_heading_size',
		array(
			'label'       => esc_html__( 'Heading Size', 'cassio' ),
			'description' => esc_html__( 'The HTML tag of the heading remains always <h1>', 'cassio' ),
			'type'        => \Elementor\Controls_Manager::SELECT,
			'default'     => 'h1',
			'options'     => array(
				'h1'       => esc_html__( 'H1', 'cassio' ),
				'h2'       => esc_html__( 'H2', 'cassio' ),
				'h3'       => esc_html__( 'H3', 'cassio' ),
				'h4'       => esc_html__( 'H4', 'cassio' ),
				'h5'       => esc_html__( 'H5', 'cassio' ),
				'h6'       => esc_html__( 'H6', 'cassio' ),
				'text-xl'  => esc_html__( 'XL', 'cassio' ),
				'text-xxl' => esc_html__( 'XXL', 'cassio' ),
			),
		)
	);

	$page->add_control(
		'page_masthead_heading_weight',
		array(
			'label'   => esc_html__( 'Heading Weight', 'cassio' ),
			'type'    => \Elementor\Controls_Manager::SELECT,
			'default' => '',
			'options' => array(
				''              => esc_html__( 'Auto', 'cassio' ),
				'heading-light' => esc_html__( 'Normal', 'cassio' ),
				'heading-bold'  => esc_html__( 'Bold', 'cassio' ),
			),
		)
	);

	$page->add_control(
		'page_masthead_subheading_tag',
		array(
			'label'   => esc_html__( 'Subheading HTML Tag', 'cassio' ),
			'type'    => \Elementor\Controls_Manager::SELECT,
			'default' => 'h2',
			'options' => array(
				'h1' => esc_html( '<h1>' ),
				'h2' => esc_html( '<h2>' ),
				'h3' => esc_html( '<h3>' ),
				'h4' => esc_html( '<h4>' ),
				'h5' => esc_html( '<h5>' ),
				'h6' => esc_html( '<h6>' ),
				'p'  => esc_html( '<p>' ),
			),
		)
	);

	$page->add_control(
		'page_masthead_subheading_size',
		array(
			'label'   => esc_html__( 'Subheading Size', 'cassio' ),
			'type'    => \Elementor\Controls_Manager::SELECT,
			'default' => 'h4',
			'options' => array(
				'h1'       => esc_html__( 'H1', 'cassio' ),
				'h2'       => esc_html__( 'H2', 'cassio' ),
				'h3'       => esc_html__( 'H3', 'cassio' ),
				'h4'       => esc_html__( 'H4', 'cassio' ),
				'h5'       => esc_html__( 'H5', 'cassio' ),
				'h6'       => esc_html__( 'H6', 'cassio' ),
				'text-xl'  => esc_html__( 'XL', 'cassio' ),
				'text-xxl' => esc_html__( 'XXL', 'cassio' ),
			),
		)
	);

	$page->add_control(
		'page_masthead_subheading_weight',
		array(
			'label'   => esc_html__( 'Subheading Weight', 'cassio' ),
			'type'    => \Elementor\Controls_Manager::SELECT,
			'default' => 'heading-light',
			'options' => array(
				''              => esc_html__( 'Auto', 'cassio' ),
				'heading-light' => esc_html__( 'Normal', 'cassio' ),
				'heading-bold'  => esc_html__( 'Bold', 'cassio' ),
			),
		)
	);

	$page->add_control(
		'heading_additional',
		array(
			'label'     => esc_html__( 'Additional Options', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::HEADING,
			'condition' => array(
				'page_masthead_style' => 'normal',
			),
		)
	);

	$page->add_control(
		'page_masthead_headline',
		array(
			'type'      => \Elementor\Controls_Manager::SWITCHER,
			'label'     => esc_html__( 'Show Headline', 'cassio' ),
			'default'   => 'yes',
			'condition' => array(
				'page_masthead_style' => 'normal',
			),
		)
	);

	$page->add_control(
		'page_masthead_category',
		array(
			'type'      => \Elementor\Controls_Manager::SWITCHER,
			'label'     => esc_html__( 'Show Category', 'cassio' ),
			'default'   => 'yes',
			'condition' => array(
				'page_masthead_style' => 'normal',
			),
		)
	);

	$page->add_control(
		'page_masthead_scroll_down',
		array(
			'type'      => \Elementor\Controls_Manager::SWITCHER,
			'label'     => esc_html__( 'Show Scroll Down', 'cassio' ),
			'default'   => '',
			'condition' => array(
				'page_masthead_style'          => 'normal',
				'page_masthead_image_position' => 'fullscreen',
			),
		)
	);

	$page->add_control(
		'cassio_hide_title_enabled',
		array(
			'type'               => \Elementor\Controls_Manager::HIDDEN,
			'default'            => '',
			'condition'          => array(
				'hide_title' => 'yes',
			),
			'selectors'          => array(
				':root {{WRAPPER}}' => '--page-title-display: none',
			),
			'frontend_available' => true,
		)
	);

	$page->add_control(
		'cassio_hide_title_disabled',
		array(
			'type'               => \Elementor\Controls_Manager::HIDDEN,
			'default'            => 'yes',
			'condition'          => array(
				'hide_title' => '',
			),
			'selectors'          => array(
				':root {{WRAPPER}}' => '--page-title-display: block',
			),
			'frontend_available' => true,
		)
	);

	$page->end_controls_section();
}
