<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Page Portfolio Nav in Elementor Document Settings
 */
add_action( 'elementor/element/wp-post/document_settings/after_section_end', 'arts_add_elementor_document_settings_page_portfolio_nav' );
function arts_add_elementor_document_settings_page_portfolio_nav( \Elementor\Core\DocumentTypes\PageBase $page ) {
	$post_id           = get_the_ID();
	$post_type         = get_post_type( $post_id );
	$is_portfolio_item = $post_type == 'arts_portfolio_item';

	if ( $is_portfolio_item ) {
		$page->start_controls_section(
			'page_portfolio_nav_section',
			array(
				'label' => esc_html__( 'Page Portfolio Nav', 'cassio' ),
				'tab'   => \Elementor\Controls_Manager::TAB_SETTINGS,
			)
		);

		$page->add_control(
			'page_portfolio_nav_theme',
			array(
				'label'   => esc_html__( 'Color Theme', 'cassio' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'bg-white'              => esc_html__( 'White', 'cassio' ),
					'bg-off-white'          => esc_html__( 'Off white', 'cassio' ),
					'bg-light'              => esc_html__( 'Light', 'cassio' ),
					'bg-black'              => esc_html__( 'Black', 'cassio' ),
					'bg-dark'               => esc_html__( 'Dark', 'cassio' ),
					'bg-dark-2'             => esc_html__( 'Dark 2', 'cassio' ),
					'bg-dark-3'             => esc_html__( 'Dark 3', 'cassio' ),
					'bg-accent-primary-1'   => esc_html__( 'Accent Primary 1', 'cassio' ),
					'bg-accent-primary-2'   => esc_html__( 'Accent Primary 2', 'cassio' ),
					'bg-accent-primary-3'   => esc_html__( 'Accent Primary 3', 'cassio' ),
					'bg-accent-primary-4'   => esc_html__( 'Accent Primary 4', 'cassio' ),
					'bg-accent-secondary-1' => esc_html__( 'Accent Secondary 1', 'cassio' ),
					'bg-accent-secondary-2' => esc_html__( 'Accent Secondary 2', 'cassio' ),
					'bg-accent-secondary-3' => esc_html__( 'Accent Secondary 3', 'cassio' ),
					'bg-accent-secondary-4' => esc_html__( 'Accent Secondary 4', 'cassio' ),
				),
				'default' => 'bg-white',
			)
		);

		$page->end_controls_section();
	}
}
