<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class WPML_Elementor_Cassio_Widget_Project_Properties extends WPML_Elementor_Module_With_Items {
	/**
	 * @return string
	 */
	public function get_items_field() {
		return 'properties';
	}

	/**
	 * @return array
	 */
	public function get_fields() {
		return array( 'option', 'value' );
	}

	/**
	 * @param string $field
	 *
	 * @return string
	 */
	protected function get_title( $field ) {
		switch ( $field ) {
			case 'option':
				return sprintf( '<strong>%1$s</strong><br>%2$s', esc_html__( 'Project Property', 'cassio' ), esc_html__( 'Option', 'cassio' ) );
			case 'value':
				return sprintf( '<strong>%1$s</strong><br>%2$s', esc_html__( 'Project Property', 'cassio' ), esc_html__( 'Value', 'cassio' ) );
			default:
				return '';
		}
	}

	/**
	 * @param string $field
	 *
	 * @return string
	 */
	protected function get_editor_type( $field ) {
		switch ( $field ) {
			case 'option':
				return 'LINE';
			case 'value':
				return 'LINE';

			default:
				return '';
		}
	}
}
