<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Cassio_Widget_Services_Line extends Arts_Widget_Base {
	protected static $_instance, $_posts, $_post_type = 'arts_service';
	protected static $_data_static_fields             = array( 'title', 'permalink' );

	public function get_name() {
		return 'cassio-widget-services-line';
	}

	public function get_title() {
		return esc_html__( 'Services Line', 'cassio' );
	}

	public function get_icon() {
		return 'eicon-sitemap';
	}

	public function get_categories() {
		return array( 'cassio-dynamic' );
	}

	protected function is_dynamic_content(): bool {
		return true;
	}

	public function wpml_widgets_to_translate_filter( $widgets ) {

		$name  = $this->get_name();
		$title = $this->get_title();

		$widgets[ $name ] = array(
			'conditions' => array( 'widgetType' => $name ),
			'fields'     => array(
				array(
					'field'       => 'button_text',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, esc_html__( 'Button Title', 'cassio' ) ),
					'editor_type' => 'LINE',
				),
			),
		);

		return $widgets;
	}

	public function add_wpml_support() {
		add_filter( 'wpml_elementor_widgets_to_translate', array( $this, 'wpml_widgets_to_translate_filter' ) );
	}

	protected function register_controls() {

		// posts toggles & posts amount
		$this->add_controls_posts_toggles();

		$this->start_controls_section(
			'button_section',
			array(
				'label' => esc_html__( 'Button', 'cassio' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'button_text',
			array(
				'label'   => esc_html__( 'Title', 'cassio' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Learn More', 'cassio' ),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'settings_section',
			array(
				'label' => esc_html__( 'Elements', 'cassio' ),
				'tab'   => Controls_Manager::TAB_SETTINGS,
			)
		);

		$this->add_control(
			'enable_counters',
			array(
				'type'    => Controls_Manager::SWITCHER,
				'label'   => esc_html__( 'Show Counters', 'cassio' ),
				'default' => 'yes',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'style_section',
			array(
				'label' => esc_html__( 'Background', 'cassio' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'color_theme',
			array(
				'label'   => esc_html__( 'Color Theme', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'bg-dark-3',
				'options' => array(
					'bg-white'              => esc_html__( 'White', 'cassio' ),
					'bg-off-white'          => esc_html__( 'Off white', 'cassio' ),
					'bg-light'              => esc_html__( 'Light', 'cassio' ),
					'bg-black'              => esc_html__( 'Black', 'cassio' ),
					'bg-dark'               => esc_html__( 'Dark', 'cassio' ),
					'bg-dark-2'             => esc_html__( 'Dark 2', 'cassio' ),
					'bg-dark-3'             => esc_html__( 'Dark 3', 'cassio' ),
					'bg-accent-primary-1'   => esc_html__( 'Accent Primary 1', 'cassio' ),
					'bg-accent-primary-2'   => esc_html__( 'Accent Primary 2', 'cassio' ),
					'bg-accent-primary-3'   => esc_html__( 'Accent Primary 3', 'cassio' ),
					'bg-accent-primary-4'   => esc_html__( 'Accent Primary 4', 'cassio' ),
					'bg-accent-secondary-1' => esc_html__( 'Accent Secondary 1', 'cassio' ),
					'bg-accent-secondary-2' => esc_html__( 'Accent Secondary 2', 'cassio' ),
					'bg-accent-secondary-3' => esc_html__( 'Accent Secondary 3', 'cassio' ),
					'bg-accent-secondary-4' => esc_html__( 'Accent Secondary 4', 'cassio' ),
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'typography_section',
			array(
				'label' => esc_html__( 'Typography', 'cassio' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'heading_tag',
			array(
				'label'   => esc_html__( 'Headings HTML Tag', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h3',
				'options' => array(
					'h2' => esc_html( '<h2>' ),
					'h3' => esc_html( '<h3>' ),
					'h4' => esc_html( '<h4>' ),
					'h5' => esc_html( '<h5>' ),
					'h6' => esc_html( '<h6>' ),
				),
			)
		);

		$this->add_control(
			'heading_size',
			array(
				'label'   => esc_html__( 'Headings Size', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h3',
				'options' => array(
					'h1'       => esc_html__( 'H1', 'cassio' ),
					'h2'       => esc_html__( 'H2', 'cassio' ),
					'h3'       => esc_html__( 'H3', 'cassio' ),
					'h4'       => esc_html__( 'H4', 'cassio' ),
					'h5'       => esc_html__( 'H5', 'cassio' ),
					'h6'       => esc_html__( 'H6', 'cassio' ),
					'text-xl'  => esc_html__( 'XL', 'cassio' ),
					'text-xxl' => esc_html__( 'XXL', 'cassio' ),
				),
			)
		);

		$this->add_control(
			'heading_weight',
			array(
				'label'   => esc_html__( 'Headings Weight', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					''              => esc_html__( 'Auto', 'cassio' ),
					'heading-light' => esc_html__( 'Normal', 'cassio' ),
					'heading-bold'  => esc_html__( 'Bold', 'cassio' ),
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'animation_section',
			array(
				'label' => esc_html__( 'Animation', 'cassio' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'enable_animation',
			array(
				'label'   => esc_html__( 'Enable on-scroll animation', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => '',
			)
		);

		$this->add_control(
			'transition_text_enabled',
			array(
				'label'   => esc_html__( 'Enable Text Transition', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$posts    = $this->get_posts_to_display();

		$this->add_render_attribute(
			'section',
			array(
				'class'                => array( 'section', 'section-services', $settings['color_theme'] ),
				'data-split-text-type' => 'lines, words, chars',
			)
		);

		$this->add_render_attribute(
			'heading',
			array(
				'class' => array( $settings['heading_size'], $settings['heading_weight'], 'section-services__heading' ),
			)
		);

		if ( $settings['transition_text_enabled'] ) {
			$this->add_render_attribute(
				'heading',
				array(
					'class'                => array( 'split-text', 'js-split-text', 'js-text-to-fly' ),
					'data-split-text-type' => 'lines, words, chars',
				)
			);
		}

		$this->add_render_attribute(
			'counter',
			array(
				'class' => array( 'section-services__counter' ),
			)
		);

		if ( ! $settings['enable_counters'] ) {
			$this->add_render_attribute( 'heading', 'class', 'mt-0' );
		}

		if ( $settings['enable_animation'] ) {

			$this->add_render_attribute(
				'section',
				array(
					'data-os-animation' => 'data-os-animation',
				)
			);

			$this->add_render_attribute(
				'counter',
				array(
					'class'               => array( 'split-text', 'js-split-text' ),
					'data-split-text-set' => 'chars',
				)
			);

			$this->add_render_attribute(
				'heading',
				array(
					'data-split-text-set' => 'chars',
				)
			);

		}

		?>

		<div <?php $this->print_render_attribute_string( 'section' ); ?>>
			<div class="container section-services__inner">
				<div class="row">
					<?php $counter = 1; ?>
					<?php foreach ( $posts as $index => $item ) : ?>
						<?php
							$this->add_render_attribute(
								'linkAtts' . $index,
								array(
									'class' => array( 'section-services__header' ),
									'href'  => $item['permalink'],
								)
							);

						if ( $settings['transition_text_enabled'] ) {
							$this->add_render_attribute( 'linkAtts' . $index, 'data-pjax-link', 'flyingHeading' );
						}

						if ( array_key_exists( 'permalink_is_external', $item ) && ! ! $item['permalink_is_external'] ) {
							$this->add_render_attribute( 'linkAtts' . $index, 'target', '_blank' );
						}

						if ( array_key_exists( 'permalink_nofollow', $item ) && ! ! $item['permalink_nofollow'] ) {
							$this->add_render_attribute( 'linkAtts' . $index, 'rel', 'nofollow' );
						}

						if ( ! empty( $item['title'] ) ) {
							$this->add_render_attribute( 'linkAtts' . $index, 'aria-label', $item['title'] );
						}
						?>
						<div class="col-lg-4 section-services__wrapper-item">
							<a <?php $this->print_render_attribute_string( 'linkAtts' . $index ); ?>>
								<?php if ( $settings['enable_counters'] ) : ?>
									<div <?php $this->print_render_attribute_string( 'counter' ); ?>><?php echo '00' . $counter; ?></div>
								<?php endif; ?>
								<<?php echo $settings['heading_tag']; ?> <?php $this->print_render_attribute_string( 'heading' ); ?>><?php echo $item['title']; ?></<?php echo $settings['heading_tag']; ?>>
								<div class="section-services__wrapper-button">
									<div class="link-arrow section-services__link">
										<div class="link-arrow__label"><?php echo $settings['button_text']; ?></div>
										<div class="link-arrow__icon material-icons">keyboard_arrow_right</div>
									</div>
								</div>
							</a>
							<div class="section-services__border-line"></div>
						</div>
						<?php ++$counter; ?>
					<?php endforeach; ?>
				</div>
			</div>
			<div class="section-services__bg <?php echo $settings['color_theme']; ?>"></div>
		</div>

		<?php
	}
}
