<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Cassio_Widget_About extends Arts_Widget_Base {
	protected static $_instance = null;

	public function get_name() {
		return 'cassio-widget-about';
	}

	public function get_title() {
		return esc_html__( 'About', 'cassio' );
	}

	public function get_icon() {
		return 'eicon-plug';
	}

	public function get_categories() {
		return array( 'cassio-static' );
	}

	public function wpml_widgets_to_translate_filter( $widgets ) {

		$name  = $this->get_name();
		$title = $this->get_title();

		$widgets[ $name ] = array(
			'conditions'        => array( 'widgetType' => $name ),
			'fields'            => array(
				array(
					'field'       => 'heading',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, esc_html__( 'Heading', 'cassio' ) ),
					'editor_type' => 'VISUAL',
				),
			),
			'integration-class' => 'WPML_Elementor_Cassio_Widget_About',
		);

		return $widgets;

	}

	public function add_wpml_support() {
		add_filter( 'wpml_elementor_widgets_to_translate', array( $this, 'wpml_widgets_to_translate_filter' ) );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			array(
				'label' => esc_html__( 'Content', 'cassio' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'heading',
			array(
				'label'       => esc_html__( 'Heading', 'cassio' ),
				'description' => sprintf(
					'%1s <ul><li><strong>%2s</strong></li><strong>%3s</strong></li></ul> %4s',
					esc_html__( 'To override the font weight, please use', 'cassio' ),
					esc_html( 'heading-light' ),
					esc_html( 'heading-bold' ),
					esc_html__( 'helper classes for the elements in editor "Text" tab' )
				),
				'type'        => Controls_Manager::WYSIWYG,
				'default'     => esc_html__( 'Heading...', 'cassio' ),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'background_section',
			array(
				'label' => esc_html__( 'Background', 'cassio' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'heading_background',
			array(
				'label' => esc_html__( 'Background', 'cassio' ),
				'type'  => Controls_Manager::HEADING,
			)
		);

		$this->add_control(
			'background_type',
			array(
				'label'   => esc_html__( 'Type', 'cassio' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => array(
					'image' => array(
						'title' => esc_html__( 'Image', 'cassio' ),
						'icon'  => 'eicon-image-bold',
					),
					'video' => array(
						'title' => esc_html__( 'Video', 'cassio' ),
						'icon'  => 'eicon-video-camera',
					),
				),
				'default' => 'image',
				'toggle'  => false,
			)
		);

		$this->add_control(
			'image',
			array(
				'label'     => esc_html__( 'Choose Image', 'cassio' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'condition' => array(
					'background_type' => 'image',
				),
			)
		);

		$this->add_control(
			'video',
			array(
				'label'      => esc_html__( 'Choose Video', 'cassio' ),
				'type'       => Controls_Manager::MEDIA,
				'media_type' => 'video',
				'condition'  => array(
					'background_type' => 'video',
				),
			)
		);

		$this->add_responsive_control(
			'height',
			array(
				'label'           => esc_html__( 'Background Height', 'cassio' ),
				'type'            => Controls_Manager::SLIDER,
				'default' => array(
					'size' => 800,
					'unit' => 'px',
				),
				'desktop_default' => array(
					'size' => 800,
					'unit' => 'px',
				),
				'tablet_default'  => array(
					'size' => 70,
					'unit' => 'vh',
				),
				'mobile_default'  => array(
					'size' => 50,
					'unit' => 'vh',
				),
				'range'           => array(
					'px' => array(
						'min' => 0,
						'max' => 1440,
					),
					'vh' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'size_units'      => array( 'px', 'vh' ),
				'selectors'       => array(
					'{{WRAPPER}} .section-about__wrapper-img' => 'height: {{SIZE}}{{UNIT}};',
				),
				'condition'       => array(
					'background_type' => 'image',
					'image!'          => array(
						'id'  => '',
						'url' => '',
					),
				),
			)
		);

		$this->add_control(
			'heading_parallax',
			array(
				'label'     => esc_html__( 'Parallax', 'cassio' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_control(
			'image_parallax',
			array(
				'label'     => esc_html__( 'Enable Parallax', 'cassio' ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'yes',
				'condition' => array(
					'image!' => array(
						'id'  => '',
						'url' => '',
					),
				),
			)
		);

		$this->add_control(
			'image_parallax_speed',
			array(
				'label'     => esc_html__( 'Parallax Speed', 'cassio' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'factor' => array(
						'min'  => -0.5,
						'max'  => 0.5,
						'step' => 0.01,
					),
				),
				'default'   => array(
					'unit' => 'factor',
					'size' => 0.1,
				),
				'condition' => array(
					'image_parallax' => 'yes',
					'image!'         => array(
						'id'  => '',
						'url' => '',
					),
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'counters_section',
			array(
				'label' => esc_html__( 'Counters', 'cassio' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'label',
			array(
				'label'       => esc_html__( 'Label', 'cassio' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Label...', 'cassio' ),
			)
		);

		$repeater->add_control(
			'counter_start',
			array(
				'label'   => esc_html__( 'Start Number', 'cassio' ),
				'type'    => Controls_Manager::NUMBER,
				'min'     => 1,
				'max'     => 1000000,
				'step'    => 1,
				'default' => 0,
			)
		);

		$repeater->add_control(
			'counter_target',
			array(
				'label'   => esc_html__( 'Target Number', 'cassio' ),
				'type'    => Controls_Manager::NUMBER,
				'min'     => 1,
				'max'     => 1000000,
				'step'    => 1,
				'default' => 10,
			)
		);

		$this->add_control(
			'counters',
			array(
				'type'          => Controls_Manager::REPEATER,
				'fields'        => $repeater->get_controls(),
				'title_field'   => '{{{ label }}}',
				'prevent_empty' => false,
			)
		);

		$this->add_control(
			'counters_duration',
			array(
				'label'   => esc_html__( 'Animation Duration (seconds)', 'cassio' ),
				'type'    => Controls_Manager::NUMBER,
				'min'     => 1,
				'max'     => 10,
				'step'    => 1,
				'default' => 4,
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'layout_section',
			array(
				'label' => esc_html__( 'Layout', 'cassio' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'content_padding_top',
			array(
				'label'   => esc_html__( 'Padding Top', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					''                  => esc_html__( 'None', 'cassio' ),
					'section_pt-xsmall' => esc_html__( '+ XSmall', 'cassio' ),
					'section_pt-small'  => esc_html__( '+ Small', 'cassio' ),
					'section_pt'        => esc_html__( '+ Medium', 'cassio' ),
					'section_pt-large'  => esc_html__( '+ Large', 'cassio' ),
					'section_pt-xlarge' => esc_html__( '+ XLarge', 'cassio' ),
				),
			)
		);

		$this->add_control(
			'content_padding_bottom',
			array(
				'label'   => esc_html__( 'Padding Bottom', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					''                  => esc_html__( 'None', 'cassio' ),
					'section_pb-xsmall' => esc_html__( '+ XSmall', 'cassio' ),
					'section_pb-small'  => esc_html__( '+ Small', 'cassio' ),
					'section_pb'        => esc_html__( '+ Medium', 'cassio' ),
					'section_pb-large'  => esc_html__( '+ Large', 'cassio' ),
					'section_pb-xlarge' => esc_html__( '+ XLarge', 'cassio' ),
				),
			)
		);

		$this->add_control(
			'content_vertical_alignment',
			array(
				'label'   => esc_html__( 'Vertical Alignment', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'align-items-lg-center',
				'options' => array(
					'align-items-lg-start'  => esc_html__( 'Top', 'cassio' ),
					'align-items-lg-center' => esc_html__( 'Middle', 'cassio' ),
					'align-items-lg-end'    => esc_html__( 'Bottom', 'cassio' ),
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'decorations_section',
			array(
				'label' => esc_html__( 'Decorations', 'cassio' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'enable_line',
			array(
				'label'   => esc_html__( 'Show Heading line', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->add_control(
			'enable_dots',
			array(
				'label'   => esc_html__( 'Show Dots', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'animation_section',
			array(
				'label' => esc_html__( 'Animation', 'cassio' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'enable_animation',
			array(
				'label'   => esc_html__( 'Enable on-scroll animation', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'heading' );

		$this->add_render_attribute(
			'section',
			array(
				'class' => array( 'section', 'section-about', 'section-image' ),
			)
		);

		$this->add_render_attribute(
			'heading',
			array(
				'class' => array( 'section-about__heading' ),
			)
		);

		$this->add_render_attribute( 'wrapper', 'class', 'section-image__wrapper' );

		$this->add_render_attribute(
			'img',
			array(
				'class'    => array( 'lazy-bg' ),
				'data-src' => $settings['image']['url'],
			)
		);

		$this->add_render_attribute(
			'col_content',
			array(
				'class' => array( 'col-lg-6', 'order-lg-2', 'section-about__content', 'section', $settings['content_padding_top'], $settings['content_padding_bottom'] ),
			)
		);

		$this->add_render_attribute(
			'col_image',
			array(
				'class' => array( 'col-lg-6', 'order-lg-1', 'section-about__wrapper-img' ),
			)
		);

		$this->add_render_attribute(
			'row',
			array(
				'class' => array( 'row', 'no-gutters', $settings['content_vertical_alignment'] ),
			)
		);

		if ( $settings['image_parallax'] ) {

			$this->add_render_attribute(
				'wrapper',
				array(
					'data-art-parallax'        => 'image',
					'data-art-parallax-factor' => $settings['image_parallax_speed'] ? $settings['image_parallax_speed']['size'] : 0,
				)
			);

			$this->add_render_attribute( 'img', 'class', 'art-parallax__bg' );
		}

		if ( $settings['enable_animation'] ) {
			$this->add_render_attribute( 'section', 'data-os-animation' );
			$this->add_render_attribute(
				'heading',
				array(
					'class'                => array( 'split-text', 'js-split-text' ),
					'data-split-text-type' => 'lines',
					'data-split-text-set'  => 'lines',
				)
			);
		}

		?>

		<div <?php $this->print_render_attribute_string( 'section' ); ?>>
			<div class="container-fluid no-gutters">
				<div <?php $this->print_render_attribute_string( 'row' ); ?>>
					<div <?php $this->print_render_attribute_string( 'col_content' ); ?>>
						<header class="section-about__header">
							<?php if ( $settings['enable_line'] ) : ?>
								<div class="section__headline section-about__headline"></div>
							<?php endif; ?>
							<div <?php $this->print_render_attribute_string( 'heading' ); ?>><?php echo $settings['heading']; ?></div>
							<?php if ( $settings['enable_dots'] ) : ?>
								<div class="section-about__decor bg-dots" data-art-parallax="element" data-art-parallax-y="25%"></div>
							<?php endif; ?>
						</header>
						<?php if ( ! empty( $settings['counters'] ) ) : ?>
							<div class="section-about__wrapper-content">
								<div class="row">
									<?php foreach ( $settings['counters'] as $index => $item ) : ?>
										<?php
											$labelKey = $this->get_repeater_setting_key( 'label', 'counters', $index );
											$this->add_inline_editing_attributes( $labelKey );
											$this->add_render_attribute(
												'counter',
												array(
													'class' => array( 'counter', 'js-counter' ),
													'data-counter-start' => $item['counter_start'],
													'data-counter-target' => $item['counter_target'],
													'data-counter-duration' => $settings['counters_duration'],
												),
												true,
												true
											);
										?>
										<div class="col-sm-6 section-about__wrapper-counter">
											<div <?php $this->print_render_attribute_string( 'counter' ); ?>>
												<div class="counter__number text-xl js-counter__number"><?php echo $item['counter_target']; ?></div>
												<div class="counter__label">
													<span <?php $this->print_render_attribute_string( $labelKey ); ?>><?php echo $item['label']; ?></span>
												</div>
											</div>
										</div>
									<?php endforeach; ?>
								</div>
							</div>
						<?php endif; ?>
					</div>
					<div <?php $this->print_render_attribute_string( 'col_image' ); ?>>
						<?php if ( $settings['background_type'] === 'video' ) : ?>
							<?php
								arts_the_lazy_image(
									array(
										'id'       => $settings['video']['id'],
										'type'     => 'background-video',
										'class'    => array(
											'wrapper' => array( 'section-image__wrapper' ),
											'image'   => array( 'art-parallax__bg' ),
										),
										'parallax' => array(
											'wrapper' => true,
											'enabled' => $settings['image_parallax'],
											'factor'  => $settings['image_parallax_speed'] ? $settings['image_parallax_speed']['size'] : 0,
										),
									)
								);
							?>
						<?php else : ?>
							<?php
								arts_the_lazy_image(
									array(
										'id'       => $settings['image']['id'],
										'class'    => array(
											'wrapper' => array( 'section-image__wrapper' ),
											'image'   => array( 'art-parallax__bg' ),
										),
										'parallax' => array(
											'wrapper' => true,
											'enabled' => $settings['image_parallax'],
											'factor'  => $settings['image_parallax_speed'] ? $settings['image_parallax_speed']['size'] : 0,
										),
									)
								);
							?>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>

		<?php
	}
}
