<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Cassio_Widget_Award extends Arts_Widget_Base {
	protected static $_instance = null;

	public function get_name() {
		return 'cassio-widget-award';
	}

	public function get_title() {
		return esc_html__( 'Award', 'cassio' );
	}

	public function get_icon() {
		return 'eicon-plug';
	}

	public function get_categories() {
		return array( 'cassio-static' );
	}

	public function wpml_widgets_to_translate_filter( $widgets ) {

		$name  = $this->get_name();
		$title = $this->get_title();

		$widgets[ $name ] = array(
			'conditions' => array( 'widgetType' => $name ),
			'fields'     => array(
				array(
					'field'       => 'year',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, esc_html__( 'Year', 'cassio' ) ),
					'editor_type' => 'LINE',
				),
				array(
					'field'       => 'content',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, esc_html__( 'Content', 'cassio' ) ),
					'editor_type' => 'VISUAL',
				),
			),
		);

		return $widgets;

	}

	public function add_wpml_support() {
		add_filter( 'wpml_elementor_widgets_to_translate', array( $this, 'wpml_widgets_to_translate_filter' ) );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			array(
				'label' => esc_html__( 'Content', 'cassio' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'year',
			array(
				'label'   => esc_html__( 'Year', 'cassio' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Year...', 'cassio' ),
			)
		);

		$this->add_control(
			'content',
			array(
				'type'        => Controls_Manager::WYSIWYG,
				'description' => sprintf(
					'%1s <ul><li><strong>%2s</strong></li><strong>%3s</strong></li></ul> %4s',
					esc_html__( 'To override the font weight, please use', 'cassio' ),
					esc_html( 'heading-light' ),
					esc_html( 'heading-bold' ),
					esc_html__( 'helper classes for the elements in editor "Text" tab' )
				),
				'default'     => esc_html__( 'The content...', 'cassio' ),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'style_section',
			array(
				'label' => esc_html__( 'Style', 'cassio' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'enable_divider',
			array(
				'label'        => esc_html__( 'Show Divider Line', 'cassio' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'figure-award_has-border-line',
				'default'      => 'figure-award_has-border-line',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'animation_section',
			array(
				'label' => esc_html__( 'Animation', 'cassio' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'enable_animation',
			array(
				'label'   => esc_html__( 'Enable on-scroll animation', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		$this->add_render_attribute(
			'section',
			array(
				'class' => array( 'figure-award', $settings['enable_divider'] ),
			)
		);
		$this->add_render_attribute( 'year', 'class', 'figure-award__year' );
		$this->add_render_attribute( 'content', 'class', 'figure-award__items' );

		$this->add_inline_editing_attributes( 'year' );
		$this->add_inline_editing_attributes( 'content' );

		if ( $settings['enable_animation'] ) {
			$this->add_render_attribute( 'section', 'data-os-animation' );
			$this->add_render_attribute(
				'year',
				array(
					'class'                => array( 'split-text', 'js-split-text' ),
					'data-split-text-type' => 'lines, words, chars',
					'data-split-text-set'  => 'chars',
				)
			);
			$this->add_render_attribute(
				'content',
				array(
					'class'                => array( 'split-text', 'js-split-text' ),
					'data-split-text-type' => 'lines',
					'data-split-text-set'  => 'lines',
				)
			);
		}

		?>

		<div class="section section-awards">
			<div <?php $this->print_render_attribute_string( 'section' ); ?>>
				<div class="row figure-award__content">
					<div class="col-sm-6">
						<div <?php $this->print_render_attribute_string( 'year' ); ?>><?php echo $settings['year']; ?></div>
					</div>
					<div class="col-sm-6">
						<div <?php $this->print_render_attribute_string( 'content' ); ?>><?php echo $settings['content']; ?></div>
					</div>
				</div>
				<?php if ( $settings['enable_divider'] ) : ?>
					<div class="figure-award__border-line"></div>
				<?php endif; ?>
			</div>
		</div>

		<?php
	}

	protected function content_template() {
		?>
		<#
			view.addRenderAttribute( 'section', {
				'class': [ 'figure-award', settings.enable_divider ]
			});
			view.addRenderAttribute( 'year', 'class', 'figure-award__year' );
			view.addRenderAttribute( 'content', 'class', 'figure-award__items' );

			view.addInlineEditingAttributes( 'year' );
			view.addInlineEditingAttributes( 'content' );

		#>
		<div class="section section-awards">
			<div {{{ view.getRenderAttributeString( 'section' ) }}}>
				<div class="row figure-award__content">
					<div class="col-sm-6">
						<div {{{ view.getRenderAttributeString( 'year' ) }}}>{{{ settings.year }}}</div>
					</div>
					<div class="col-sm-6">
						<div {{{ view.getRenderAttributeString( 'content' ) }}}>{{{ settings.content }}}</div>
					</div>
				</div>
				<# if ( settings.enable_divider ) { #>
					<div class="figure-award__border-line"></div>
				<# } #>
			</div>
		</div>

		<?php
	}
}
