<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Cassio_Widget_Call_To_Action extends Arts_Widget_Base {
	protected static $_instance = null;

	public function get_name() {
		return 'cassio-widget-call-to-action';
	}

	public function get_title() {
		return esc_html__( 'Call To Action', 'cassio' );
	}

	public function get_icon() {
		return 'eicon-plug';
	}

	public function get_categories() {
		return array( 'cassio-static' );
	}

	public function wpml_widgets_to_translate_filter( $widgets ) {
		$name  = $this->get_name();
		$title = $this->get_title();

		$widgets[ $name ] = array(
			'conditions' => array( 'widgetType' => $name ),
			'fields'     => array(
				array(
					'field'       => 'content',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, esc_html__( 'Content', 'cassio' ) ),
					'editor_type' => 'VISUAL',
				),
				array(
					'field'       => 'button_text',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, esc_html__( 'Button Title', 'cassio' ) ),
					'editor_type' => 'LINE',
				),
				array(
					'field'       => 'button_link',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, esc_html__( 'Button Link', 'cassio' ) ),
					'editor_type' => 'LINE',
				),
			),
		);

		return $widgets;
	}

	public function add_wpml_support() {
		add_filter( 'wpml_elementor_widgets_to_translate', array( $this, 'wpml_widgets_to_translate_filter' ) );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			array(
				'label' => esc_html__( 'Content', 'cassio' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'content',
			array(
				'type'        => Controls_Manager::WYSIWYG,
				'description' => sprintf(
					'%1s <ul><li><strong>%2s</strong></li><strong>%3s</strong></li></ul> %4s',
					esc_html__( 'To override the font weight, please use', 'cassio' ),
					esc_html( 'heading-light' ),
					esc_html( 'heading-bold' ),
					esc_html__( 'helper classes for the elements in editor "Text" tab' )
				),
				'default'     => esc_html__( 'The content...', 'cassio' ),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'background_section',
			array(
				'label' => esc_html__( 'Background', 'cassio' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'background_type',
			array(
				'label'   => esc_html__( 'Type', 'cassio' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => array(
					'image' => array(
						'title' => esc_html__( 'Image', 'cassio' ),
						'icon'  => 'eicon-image-bold',
					),
					'video' => array(
						'title' => esc_html__( 'Video', 'cassio' ),
						'icon'  => 'eicon-video-camera',
					),
				),
				'default' => 'image',
				'toggle'  => false,
			)
		);

		$this->add_control(
			'image',
			array(
				'label'     => esc_html__( 'Choose Image', 'cassio' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'condition' => array(
					'background_type' => 'image',
				),
			)
		);

		$this->add_control(
			'video',
			array(
				'label'      => esc_html__( 'Choose Video', 'cassio' ),
				'type'       => Controls_Manager::MEDIA,
				'media_type' => 'video',
				'condition'  => array(
					'background_type' => 'video',
				),
			)
		);

		$this->add_control(
			'overlay_background_color',
			array(
				'label'     => esc_html__( 'Overlay', 'cassio' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => 'rgba(0,0,0,.6)',
				'selectors' => array(
					'{{WRAPPER}} .section-image__overlay' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'heading_parallax',
			array(
				'label'     => esc_html__( 'Parallax', 'cassio' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_control(
			'image_parallax',
			array(
				'label'     => esc_html__( 'Enable Parallax', 'cassio' ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'yes',
				'condition' => array(
					'image!' => array(
						'id'  => '',
						'url' => '',
					),
				),
			)
		);

		$this->add_control(
			'image_parallax_speed',
			array(
				'label'     => esc_html__( 'Parallax Speed', 'cassio' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'factor' => array(
						'min'  => -0.5,
						'max'  => 0.5,
						'step' => 0.01,
					),
				),
				'default'   => array(
					'unit' => 'factor',
					'size' => 0.1,
				),
				'condition' => array(
					'image_parallax' => 'yes',
					'image!'         => array(
						'id'  => '',
						'url' => '',
					),
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'button_section',
			array(
				'label' => esc_html__( 'Button', 'cassio' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'button_type',
			array(
				'label'   => esc_html__( 'Type', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'link',
				'options' => array(
					'button' => esc_html__( 'Button', 'cassio' ),
					'link'   => esc_html__( 'Link', 'cassio' ),
				),
			)
		);

		$this->add_control(
			'button_text',
			array(
				'label'   => esc_html__( 'Title', 'cassio' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Button...', 'cassio' ),
			)
		);

		$this->add_control(
			'button_link',
			array(
				'label'         => esc_html__( 'Link', 'cassio' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => 'https://...',
				'show_external' => true,
				'default'       => array(
					'url'         => '#',
					'is_external' => true,
					'nofollow'    => true,
				),
			)
		);

		$this->add_control(
			'button_color',
			array(
				'label'       => esc_html__( 'Color', 'cassio' ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT,
				'options'     => array(
					'bg-white'              => esc_html__( 'White', 'cassio' ),
					'bg-off-white'          => esc_html__( 'Off white', 'cassio' ),
					'bg-light'              => esc_html__( 'Light', 'cassio' ),
					'bg-black'              => esc_html__( 'Black', 'cassio' ),
					'bg-dark'               => esc_html__( 'Dark', 'cassio' ),
					'bg-dark-2'             => esc_html__( 'Dark 2', 'cassio' ),
					'bg-dark-3'             => esc_html__( 'Dark 3', 'cassio' ),
					'bg-accent-primary-1'   => esc_html__( 'Accent Primary 1', 'cassio' ),
					'bg-accent-primary-2'   => esc_html__( 'Accent Primary 2', 'cassio' ),
					'bg-accent-primary-3'   => esc_html__( 'Accent Primary 3', 'cassio' ),
					'bg-accent-primary-4'   => esc_html__( 'Accent Primary 4', 'cassio' ),
					'bg-accent-secondary-1' => esc_html__( 'Accent Secondary 1', 'cassio' ),
					'bg-accent-secondary-2' => esc_html__( 'Accent Secondary 2', 'cassio' ),
					'bg-accent-secondary-3' => esc_html__( 'Accent Secondary 3', 'cassio' ),
					'bg-accent-secondary-4' => esc_html__( 'Accent Secondary 4', 'cassio' ),
				),
				'default'     => 'bg-accent-primary-3',
				'condition'   => array(
					'button_type' => 'button',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'layout_section',
			array(
				'label' => esc_html__( 'Layout', 'cassio' ),
				'tab'   => Controls_Manager::TAB_LAYOUT,
			)
		);

		$this->add_control(
			'heading_layout_content',
			array(
				'label' => esc_html__( 'Content', 'cassio' ),
				'type'  => Controls_Manager::HEADING,
			)
		);

		$this->add_control(
			'content_position',
			array(
				'label'   => esc_html__( 'Position', 'cassio' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => array(
					'justify-content-start'  => array(
						'title' => esc_html__( 'Left', 'cassio' ),
						'icon'  => 'eicon-h-align-left',
					),
					'justify-content-center' => array(
						'title' => esc_html__( 'Center', 'cassio' ),
						'icon'  => 'eicon-h-align-center',
					),
					'justify-content-end'    => array(
						'title' => esc_html__( 'Right', 'cassio' ),
						'icon'  => 'eicon-h-align-right',
					),
				),
				'default' => 'justify-content-center',
			)
		);

		$this->add_control(
			'content_alignment',
			array(
				'label'   => esc_html__( 'Alignment', 'cassio' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => array(
					'text-left'   => array(
						'title' => esc_html__( 'Left', 'cassio' ),
						'icon'  => 'eicon-text-align-left',
					),
					'text-center' => array(
						'title' => esc_html__( 'Center', 'cassio' ),
						'icon'  => 'eicon-text-align-center',
					),
					'text-right'  => array(
						'title' => esc_html__( 'Right', 'cassio' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'default' => 'text-center',
			)
		);

		$this->add_control(
			'content_paddings',
			array(
				'label'   => esc_html__( 'Paddings Top / Bottom', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					''                                    => esc_html__( 'None', 'cassio' ),
					'section_pt-xsmall section_pb-xsmall' => esc_html__( '+ XSmall', 'cassio' ),
					'section_pt-small section_pb-small'   => esc_html__( '+ Small', 'cassio' ),
					'section_pt section_pb'               => esc_html__( '+ Medium', 'cassio' ),
					'section_pt-large section_pb-large'   => esc_html__( '+ Large', 'cassio' ),
					'section_pt-xlarge section_pb-xlarge' => esc_html__( '+ XLarge', 'cassio' ),
				),
			)
		);

		$this->add_control(
			'section_fullscreen',
			array(
				'label'   => esc_html__( 'Enable Fit to Screen', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => '',
			)
		);

		$this->add_control(
			'container',
			array(
				'label'   => esc_html__( 'Container', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'container',
				'options' => array(
					'container'       => esc_html__( 'Boxed', 'cassio' ),
					'container-fluid' => esc_html__( 'Fullwidth', 'cassio' ),
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'decorations_section',
			array(
				'label' => esc_html__( 'Decorations', 'cassio' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'enable_line',
			array(
				'label'   => esc_html__( 'Show Top Line', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'animation_section',
			array(
				'label' => esc_html__( 'Animation', 'cassio' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'enable_animation',
			array(
				'label'   => esc_html__( 'Enable on-scroll animation', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'content' );
		$this->add_inline_editing_attributes( 'button_text' );

		$this->add_render_attribute(
			'section',
			array(
				'class' => array( 'section', 'section-content', 'section-cta', 'section-image', 'section_z-100', $settings['content_paddings'] ),
			)
		);

		$this->add_render_attribute(
			'section_content',
			array(
				'class' => array( 'section__content' ),
			)
		);

		$this->add_render_attribute(
			'row',
			array(
				'class' => array( 'row', $settings['content_position'], $settings['content_alignment'] ),
			)
		);

		$this->add_render_attribute(
			'container',
			array(
				'class' => array( $settings['container'] ),
			)
		);

		if ( $settings['button_type'] == 'button' ) {

			$this->add_render_attribute(
				'button',
				array(
					'class' => array( 'button', 'button_icon', $settings['button_color'] ),
					'href'  => $settings['button_link']['url'],
				)
			);

		} else {

			$this->add_render_attribute(
				'button',
				array(
					'class' => array( 'link-arrow' ),
					'href'  => $settings['button_link']['url'],
				)
			);

		}

		if ( $settings['button_link']['is_external'] ) {
			$this->add_render_attribute( 'button', 'target', '_blank' );
		}

		if ( $settings['button_link']['nofollow'] ) {
			$this->add_render_attribute( 'button', 'rel', 'nofollow' );
		}

		if ( $settings['section_fullscreen'] ) {

			$this->add_render_attribute(
				'section',
				array(
					'class' => array( 'section-fullheight' ),
				)
			);

			$this->add_render_attribute(
				'section_content',
				array(
					'class' => array( 'section-fullheight__inner' ),
				)
			);

		}

		if ( $settings['enable_animation'] ) {

			$this->add_render_attribute( 'section', 'data-os-animation' );
			$this->add_render_attribute(
				'content',
				array(
					'class'                => array( 'split-text', 'js-split-text' ),
					'data-split-text-type' => 'lines',
					'data-split-text-set'  => 'lines',
				)
			);

		}

		?>

		<div <?php $this->print_render_attribute_string( 'section' ); ?>>
			<?php if ( $settings['enable_line'] ) : ?>
				<div class="section-cta__line"></div>
			<?php endif; ?>
			<div <?php $this->print_render_attribute_string( 'section_content' ); ?>>
				<div <?php $this->print_render_attribute_string( 'container' ); ?>>
					<div <?php $this->print_render_attribute_string( 'row' ); ?>>
						<div class="col-lg-8">
							<header class="section-cta__header">
								<div <?php $this->print_render_attribute_string( 'content' ); ?>><?php echo $settings['content']; ?></div>
							</header>
							<?php if ( $settings['button_text'] ) : ?>
								<div class="section-cta__wrapper-button section-content__wrapper-button">
									<?php if ( $settings['button_type'] == 'button' ) : ?>
										<a <?php $this->print_render_attribute_string( 'button' ); ?>>
											<div class="button__label" >
												<span <?php $this->print_render_attribute_string( 'button_text' ); ?>><?php echo $settings['button_text']; ?></span>
											</div>
											<div class="button__icon"><i class="material-icons">keyboard_arrow_right</i></div>
										</a>
									<?php else : ?>
										<a <?php $this->print_render_attribute_string( 'button' ); ?>>
											<div class="link-arrow__label" >
												<span <?php $this->print_render_attribute_string( 'button_text' ); ?>><?php echo $settings['button_text']; ?></span>
											</div>
											<div class="link-arrow__icon material-icons">keyboard_arrow_right</div>
										</a>
									<?php endif; ?>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
			<?php if ( $settings['background_type'] === 'video' ) : ?>
				<?php
					arts_the_lazy_image(
						array(
							'id'       => $settings['video']['id'],
							'type'     => 'background-video',
							'class'    => array(
								'wrapper' => array( 'section-image__wrapper', 'section-image__wrapper_absolute' ),
								'image'   => array( 'art-parallax__bg' ),
								'overlay' => array( 'overlay', 'overlay_dark', 'section-image__overlay' ),
							),
							'parallax' => array(
								'wrapper' => true,
								'enabled' => $settings['image_parallax'],
								'factor'  => $settings['image_parallax_speed'] ? $settings['image_parallax_speed']['size'] : 0,
							),
							'overlay'  => true,
						)
					);
				?>
			<?php else : ?>
				<?php
					arts_the_lazy_image(
						array(
							'id'       => $settings['image']['id'],
							'class'    => array(
								'wrapper' => array( 'section-image__wrapper', 'section-image__wrapper_absolute' ),
								'image'   => array( 'art-parallax__bg' ),
								'overlay' => array( 'overlay', 'overlay_dark', 'section-image__overlay' ),
							),
							'parallax' => array(
								'wrapper' => true,
								'enabled' => $settings['image_parallax'],
								'factor'  => $settings['image_parallax_speed'] ? $settings['image_parallax_speed']['size'] : 0,
							),
							'overlay'  => true,
						)
					);
				?>
			<?php endif; ?>
		</div>

		<?php
	}
}
